/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import com.glodblock.github.loader.ChannelLoader;
import com.glodblock.github.util.BlockPos;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileCertusQuartzTank
extends TileEntity
implements IFluidHandler {
    private FluidStack lastBeforeUpdate = null;
    public FluidTank tank = new FluidTank(32000){

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            if (!nbt.func_74764_b("Empty")) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                this.setFluid(fluid);
            } else {
                this.setFluid(null);
            }
            return this;
        }
    };
    private boolean hasUpdate;

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public int getFluidLightLevel() {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid == null || tankFluid.amount == 0 ? 0 : tankFluid.getFluid().getLuminosity(tankFluid);
    }

    public void compareAndUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            FluidStack current = this.tank.getFluid();
            if (current != null) {
                if (this.lastBeforeUpdate != null) {
                    if (Math.abs(current.amount - this.lastBeforeUpdate.amount) >= 500) {
                        ChannelLoader.sendPacketToAllPlayers(this.func_145844_m(), this.field_145850_b);
                        this.lastBeforeUpdate = current.copy();
                    } else if (this.lastBeforeUpdate.amount < this.tank.getCapacity() && current.amount == this.tank.getCapacity() || this.lastBeforeUpdate.amount == this.tank.getCapacity() && current.amount < this.tank.getCapacity()) {
                        ChannelLoader.sendPacketToAllPlayers(this.func_145844_m(), this.field_145850_b);
                        this.lastBeforeUpdate = current.copy();
                    }
                } else {
                    ChannelLoader.sendPacketToAllPlayers(this.func_145844_m(), this.field_145850_b);
                    this.lastBeforeUpdate = current.copy();
                }
            } else if (this.lastBeforeUpdate != null) {
                ChannelLoader.sendPacketToAllPlayers(this.func_145844_m(), this.field_145850_b);
                this.lastBeforeUpdate = null;
            }
        }
    }

    public FluidStack drain(FluidStack fluid, boolean doDrain, boolean findMainTank) {
        TileEntity offTE;
        if (findMainTank) {
            Fluid offFluid;
            int yOff = 0;
            TileEntity offTE2 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + yOff, this.field_145849_e);
            TileCertusQuartzTank mainTank = this;
            while (offTE2 instanceof TileCertusQuartzTank && (offFluid = ((TileCertusQuartzTank)offTE2).getFluid()) != null && offFluid == fluid.getFluid()) {
                mainTank = (TileCertusQuartzTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + yOff, this.field_145849_e);
                offTE2 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + ++yOff, this.field_145849_e);
            }
            return mainTank != null ? mainTank.drain(fluid, doDrain, false) : null;
        }
        FluidStack drained = this.tank.drain(fluid.amount, doDrain);
        this.compareAndUpdate();
        if ((drained == null || drained.amount < fluid.amount) && (offTE = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) instanceof TileCertusQuartzTank) {
            TileCertusQuartzTank tank = (TileCertusQuartzTank)offTE;
            FluidStack externallyDrained = tank.drain(new FluidStack(fluid.getFluid(), fluid.amount - (drained != null ? drained.amount : 0)), doDrain, false);
            if (externallyDrained != null) {
                return new FluidStack(fluid.getFluid(), (drained != null ? drained.amount : 0) + externallyDrained.amount);
            }
            return drained;
        }
        return drained;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.tank.getFluid() == null || resource == null || resource.getFluid() != this.tank.getFluid().getFluid()) {
            return null;
        }
        return this.drain(resource, doDrain, true);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.tank.getFluid() == null) {
            return null;
        }
        return this.drain(from, new FluidStack(this.tank.getFluid(), maxDrain), doDrain);
    }

    public int fill(FluidStack fluid, boolean doFill, boolean findMainTank) {
        TileEntity offTE;
        if (findMainTank) {
            Fluid offFluid;
            int yOff = 0;
            TileEntity offTE2 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - yOff, this.field_145849_e);
            TileCertusQuartzTank mainTank = this;
            while (offTE2 instanceof TileCertusQuartzTank && ((offFluid = ((TileCertusQuartzTank)offTE2).getFluid()) == null || offFluid == fluid.getFluid())) {
                mainTank = (TileCertusQuartzTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - yOff, this.field_145849_e);
                offTE2 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - ++yOff, this.field_145849_e);
            }
            return mainTank != null ? mainTank.fill(fluid, doFill, false) : 0;
        }
        int filled = this.tank.fill(fluid, doFill);
        this.compareAndUpdate();
        if (filled < fluid.amount && (offTE = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) instanceof TileCertusQuartzTank) {
            TileCertusQuartzTank tank = (TileCertusQuartzTank)offTE;
            return filled + tank.fill(new FluidStack(fluid.getFluid(), fluid.amount - filled), doFill, false);
        }
        return filled;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || this.tank.getFluid() != null && resource.getFluid() != this.tank.getFluid().getFluid()) {
            return 0;
        }
        return this.fill(resource, doFill, true);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public Fluid getFluid() {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid != null && tankFluid.amount > 0 ? tankFluid.getFluid() : null;
    }

    public Fluid getRenderFluid() {
        return this.tank.getFluid() != null ? this.tank.getFluid().getFluid() : null;
    }

    public float getRenderScale() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    private void onComparatorUpdate(World world, int x, int y, int z, Block block) {
        world.func_147453_f(x, y, z, block);
    }

    public void func_145845_h() {
        TileCertusQuartzTank below;
        super.func_145845_h();
        if (this.tank.getFluid() != null && (below = this.getTankBelow(this)) != null) {
            FluidStack filled = this.tank.getFluid().copy();
            filled.amount = below.fill(this.tank.getFluid(), true, true);
            if (filled.amount >= 0) {
                this.drain(filled, true, true);
                this.hasUpdate = true;
                below.hasUpdate = true;
            }
        }
        if (this.hasUpdate) {
            this.onComparatorUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.hasUpdate = false;
        }
    }

    private TileCertusQuartzTank getTankBelow(TileEntity tile) {
        TileEntity tank = new BlockPos(tile).getOffSet(0, -1, 0).getTileEntity();
        if (tank != null && tank instanceof TileCertusQuartzTank) {
            return (TileCertusQuartzTank)tank;
        }
        return null;
    }

    public FluidTankInfo[] getTankInfo(boolean goToMainTank) {
        TileCertusQuartzTank mainTank;
        if (!goToMainTank) {
            return new FluidTankInfo[]{this.tank.getInfo()};
        }
        int amount = 0;
        int capacity = 0;
        Fluid fluid = null;
        int yOff = 0;
        TileEntity offTE = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - yOff, this.field_145849_e);
        while (offTE instanceof TileCertusQuartzTank && (((TileCertusQuartzTank)offTE).getFluid() == null || ((TileCertusQuartzTank)offTE).getFluid() == this.getFluid())) {
            offTE = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - ++yOff, this.field_145849_e);
        }
        offTE = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - --yOff, this.field_145849_e);
        while (offTE instanceof TileCertusQuartzTank && ((mainTank = (TileCertusQuartzTank)offTE).getFluid() == null || this.getFluid() == null || mainTank.getFluid() == this.getFluid())) {
            FluidTankInfo info = mainTank.getTankInfo(false)[0];
            if (info != null) {
                capacity += info.capacity;
                if (info.fluid != null) {
                    amount += info.fluid.amount;
                    if (info.fluid.getFluid() != null) {
                        fluid = info.fluid.getFluid();
                    }
                }
            }
            offTE = new BlockPos(offTE).getOffSet(0, 1, 0).getTileEntity();
        }
        return new FluidTankInfo[]{new FluidTankInfo(fluid != null ? new FluidStack(fluid, amount) : null, capacity)};
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getTankInfo(true);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readFromNBTWithoutCoords(tag);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tag) {
        this.tank.readFromNBT(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeToNBTWithoutCoords(tag);
    }

    public void writeToNBTWithoutCoords(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
    }

    public FluidTankInfo[] getInternalFluid() {
        return this.getTankInfo(true);
    }
}

