/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.item;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.MEMonitorHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.items.contents.WirelessTerminalViewCells;
import appeng.items.tools.powered.ToolWirelessTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.ItemBiggerAppEngInventory;
import com.glodblock.github.inventory.WirelessFluidPatternTerminalPatterns;
import com.glodblock.github.inventory.item.IWirelessPatternTerminal;
import com.glodblock.github.util.Util;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class WirelessPatternTerminalInventory
extends MEMonitorHandler<IAEItemStack>
implements IWirelessPatternTerminal {
    private final ItemStack target;
    private final IAEItemPowerStorage ips;
    private final int inventorySlot;
    private final AppEngInternalInventory viewCell;
    private final StorageChannel channel;
    private final IGridNode grid;
    protected AppEngInternalInventory crafting;
    protected AppEngInternalInventory output;
    protected final WirelessFluidPatternTerminalPatterns pattern;
    protected boolean craftingMode = true;
    protected boolean substitute = false;
    protected boolean combine = false;
    protected boolean prioritize = false;
    protected boolean inverted = false;
    protected boolean beSubstitute = false;
    protected boolean autoFillPattern = false;
    protected int activePage = 0;

    public WirelessPatternTerminalInventory(ItemStack is, int slot, IGridNode gridNode, EntityPlayer player) {
        super(Objects.requireNonNull(Util.getWirelessInv(is, player, StorageChannel.ITEMS)));
        this.ips = (ToolWirelessTerminal)is.func_77973_b();
        this.grid = gridNode;
        this.target = is;
        this.inventorySlot = slot;
        this.viewCell = new WirelessTerminalViewCells(is);
        this.channel = StorageChannel.ITEMS;
        this.pattern = new WirelessFluidPatternTerminalPatterns(is, this);
        this.crafting = new ItemBiggerAppEngInventory(is, "crafting", 9);
        this.output = new ItemBiggerAppEngInventory(is, "output", 3);
    }

    public StorageChannel getChannel() {
        return this.channel;
    }

    public ItemStack getItemStack() {
        return this.target;
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        amt = usePowerMultiplier.multiply(amt);
        if (mode == Actionable.SIMULATE) {
            return usePowerMultiplier.divide(Math.min(amt, this.ips.getAECurrentPower(this.target)));
        }
        return usePowerMultiplier.divide(this.ips.extractAEPower(this.target, amt));
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return this;
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return null;
    }

    public void readFromNBT() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
        this.setCraftingRecipe(data.func_74767_n("craftingMode"));
        this.setSubstitution(data.func_74767_n("substitute"));
        this.setCombineMode(data.func_74767_n("combine"));
        this.setBeSubstitute(data.func_74767_n("beSubstitute"));
        this.setActivePage(data.func_74762_e("activePage"));
        this.setAutoFillPattern(data.func_74767_n("autoFillPattern"));
    }

    public void writeToNBT() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
        data.func_74757_a("craftingMode", this.craftingMode);
        data.func_74757_a("substitute", this.substitute);
        data.func_74757_a("combine", this.combine);
        data.func_74757_a("beSubstitute", this.beSubstitute);
        data.func_74768_a("activePage", this.activePage);
        data.func_74757_a("autoFillPattern", this.autoFillPattern);
    }

    public IConfigManager getConfigManager() {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT((NBTTagCompound)Platform.openNbtData((ItemStack)this.target).func_74737_b());
        this.readFromNBT();
        return out;
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }

    public IInventory getViewCellStorage() {
        return this.viewCell;
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.grid;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.NONE;
    }

    public void securityBreak() {
        this.getGridNode(ForgeDirection.UNKNOWN).getMachine().securityBreak();
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ICraftingPatternItem pattern;
        ICraftingPatternDetails details;
        ItemStack is;
        if (inv == this.pattern && slot == 1 && (is = inv.func_70301_a(1)) != null && is.func_77973_b() instanceof ICraftingPatternItem && (details = (pattern = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.getActionableNode().getWorld())) != null) {
            ItemStack packet;
            IAEItemStack item;
            int i;
            IAEItemStack[] inItems = details.getInputs();
            IAEItemStack[] outItems = details.getOutputs();
            this.setCraftingRecipe(details.isCraftable());
            this.setSubstitution(details.canSubstitute());
            if (newStack != null) {
                NBTTagCompound data = newStack.func_77978_p();
                this.setCombineMode(data.func_74762_e("combine") == 1);
                this.setBeSubstitute(details.canBeSubstitute());
            }
            for (i = 0; i < this.crafting.func_70302_i_(); ++i) {
                this.crafting.func_70299_a(i, null);
            }
            for (i = 0; i < this.output.func_70302_i_(); ++i) {
                this.output.func_70299_a(i, null);
            }
            for (i = 0; i < this.crafting.func_70302_i_() && i < inItems.length; ++i) {
                if (inItems[i] == null) continue;
                item = inItems[i];
                if (item != null && item.getItem() instanceof ItemFluidDrop) {
                    packet = ItemFluidPacket.newStack(ItemFluidDrop.getFluidStack(item.getItemStack()));
                    this.crafting.func_70299_a(i, packet);
                    continue;
                }
                this.crafting.func_70299_a(i, item == null ? null : item.getItemStack());
            }
            for (i = 0; i < this.output.func_70302_i_() && i < outItems.length; ++i) {
                if (outItems[i] == null) continue;
                item = outItems[i];
                if (item != null && item.getItem() instanceof ItemFluidDrop) {
                    packet = ItemFluidPacket.newStack(ItemFluidDrop.getFluidStack(item.getItemStack()));
                    this.output.func_70299_a(i, packet);
                    continue;
                }
                this.output.func_70299_a(i, item == null ? null : item.getItemStack());
            }
        }
        if (inv == this.crafting) {
            this.fixCraftingRecipes();
        }
    }

    private void fixCraftingRecipes() {
        if (this.craftingMode) {
            for (int x = 0; x < this.crafting.func_70302_i_(); ++x) {
                ItemStack is = this.crafting.func_70301_a(x);
                if (is == null) continue;
                is.field_77994_a = 1;
            }
        }
    }

    @Override
    public boolean isInverted() {
        return false;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("output")) {
            return this.output;
        }
        if (name.equals("pattern")) {
            return this.pattern;
        }
        return null;
    }

    @Override
    public boolean canBeSubstitute() {
        return this.beSubstitute;
    }

    @Override
    public boolean isPrioritize() {
        return false;
    }

    @Override
    public boolean isSubstitution() {
        return this.substitute;
    }

    @Override
    public boolean shouldCombine() {
        return this.combine;
    }

    @Override
    public void onChangeCrafting(IAEItemStack[] newCrafting, IAEItemStack[] newOutput) {
        IInventory crafting = this.getInventoryByName("crafting");
        IInventory output = this.getInventoryByName("output");
        if (crafting instanceof AppEngInternalInventory && output instanceof AppEngInternalInventory) {
            IAEItemStack item;
            int x;
            for (x = 0; x < crafting.func_70302_i_() && x < newCrafting.length; ++x) {
                item = newCrafting[x];
                crafting.func_70299_a(x, item == null ? null : item.getItemStack());
            }
            for (x = 0; x < output.func_70302_i_() && x < newOutput.length; ++x) {
                item = newOutput[x];
                output.func_70299_a(x, item == null ? null : item.getItemStack());
            }
        }
    }

    @Override
    public void setCraftingRecipe(boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.fixCraftingRecipes();
        ((ItemBiggerAppEngInventory)this.crafting).setCraftingMode(craftingMode);
    }

    @Override
    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
    }

    @Override
    public void setBeSubstitute(boolean canBeSubstitute) {
        this.beSubstitute = canBeSubstitute;
    }

    @Override
    public void setCombineMode(boolean shouldCombine) {
        this.combine = shouldCombine;
    }

    @Override
    public void setPrioritization(boolean canPrioritize) {
        this.prioritize = canPrioritize;
    }

    @Override
    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    @Override
    public int getActivePage() {
        return this.activePage;
    }

    @Override
    public void setActivePage(int activePage) {
        this.activePage = activePage;
    }

    @Override
    public boolean isCraftingRecipe() {
        return this.craftingMode;
    }

    @Override
    public void sortCraftingItems() {
        ArrayList<Object> items = new ArrayList<Object>();
        ArrayList<Object> fluids = new ArrayList<Object>();
        for (ItemStack is : this.crafting) {
            if (is == null) continue;
            if (is.func_77973_b() instanceof ItemFluidPacket) {
                fluids.add(is);
                continue;
            }
            items.add(is);
        }
        if (this.prioritize) {
            fluids.addAll(items);
            items.clear();
        } else {
            items.addAll(fluids);
            fluids.clear();
        }
        for (int i = 0; i < this.crafting.func_70302_i_() && this.crafting.func_70301_a(i) != null; ++i) {
            if (items.isEmpty()) {
                this.crafting.func_70299_a(i, (ItemStack)fluids.get(i));
                continue;
            }
            this.crafting.func_70299_a(i, (ItemStack)items.get(i));
        }
        this.saveChanges();
    }

    @Override
    public boolean isAutoFillPattern() {
        return this.autoFillPattern;
    }

    @Override
    public void setAutoFillPattern(boolean canFill) {
        this.autoFillPattern = canFill;
    }

    @Override
    public void saveSettings() {
        this.writeToNBT();
    }

    public IGridNode getActionableNode() {
        return this.grid;
    }
}

