/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.client.gui.GuiFluidCraftConfirm;
import com.glodblock.github.client.gui.GuiFluidMonitor;
import com.glodblock.github.client.gui.GuiItemMonitor;
import com.glodblock.github.client.gui.GuiLevelMaintainer;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class SPacketMEInventoryUpdate
implements IMessage {
    private List<Object> list;
    private byte ref;
    private boolean isFluid = false;

    public SPacketMEInventoryUpdate() {
        this.ref = 0;
        this.list = new LinkedList<Object>();
    }

    public SPacketMEInventoryUpdate(Boolean isFluid) {
        this.ref = 0;
        this.list = new LinkedList<Object>();
        this.isFluid = isFluid;
    }

    public SPacketMEInventoryUpdate(byte b) {
        this.ref = b;
        this.list = new LinkedList<Object>();
    }

    public void fromBytes(ByteBuf buf) {
        this.isFluid = buf.readBoolean();
        long amount = buf.readLong();
        this.ref = buf.readByte();
        this.list = new LinkedList<Object>();
        try {
            int i = 0;
            while ((long)i < amount) {
                if (this.isFluid) {
                    this.list.add(AEFluidStack.loadFluidStackFromPacket((ByteBuf)buf));
                } else {
                    this.list.add(AEItemStack.loadItemStackFromPacket((ByteBuf)buf));
                }
                ++i;
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isFluid);
        buf.writeLong((long)this.list.size());
        buf.writeByte((int)this.ref);
        try {
            for (Object is : this.list) {
                if (is instanceof IAEItemStack) {
                    ((IAEItemStack)is).writeToPacket(buf);
                }
                if (!(is instanceof IAEFluidStack)) continue;
                ((IAEFluidStack)is).writeToPacket(buf);
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public void appendItem(IAEItemStack is) throws BufferOverflowException {
        this.list.add(is);
    }

    public void appendFluid(IAEFluidStack is) throws BufferOverflowException {
        this.list.add(is);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public static class Handler
    implements IMessageHandler<SPacketMEInventoryUpdate, IMessage> {
        public IMessage onMessage(SPacketMEInventoryUpdate message, MessageContext ctx) {
            GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
            if (gs instanceof GuiFluidMonitor) {
                ((GuiFluidMonitor)gs).postUpdate(message.list);
            } else if (gs instanceof GuiItemMonitor) {
                ((GuiItemMonitor)gs).postUpdate(message.list);
            } else if (gs instanceof GuiFluidCraftConfirm) {
                ((GuiFluidCraftConfirm)gs).postUpdate(message.list, message.ref);
            } else if (gs instanceof GuiLevelMaintainer) {
                ((GuiLevelMaintainer)gs).postUpdate(message.list);
            }
            return null;
        }
    }
}

