/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.render.AppEngRenderItem;
import appeng.core.localization.GuiText;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.gui.container.ContainerFluidPatternEncoder;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.tile.TileFluidPatternEncoder;
import com.glodblock.github.inventory.gui.MouseRegionManager;
import com.glodblock.github.inventory.slot.ISlotFluid;
import com.glodblock.github.inventory.slot.SlotSingleItem;
import com.glodblock.github.network.CPacketEncodePattern;
import com.glodblock.github.util.Ae2ReflectClient;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class GuiFluidPatternEncoder
extends AEBaseGui {
    private static final ResourceLocation TEX_BG = FluidCraft.resource("textures/gui/fluid_pattern_encoder.png");
    private final ContainerFluidPatternEncoder cont;
    private final MouseRegionManager mouseRegions = new MouseRegionManager((GuiContainer)this);
    private final AppEngRenderItem stackSizeRenderer = Ae2ReflectClient.getStackSizeRenderer(this);

    public GuiFluidPatternEncoder(InventoryPlayer ipl, TileFluidPatternEncoder tile) {
        super((Container)new ContainerFluidPatternEncoder(ipl, tile));
        this.cont = (ContainerFluidPatternEncoder)this.field_147002_h;
        this.mouseRegions.addRegion(141, 38, 10, 10, new MouseRegionManager.Handler(){

            @Override
            public List<String> getTooltip() {
                return Collections.singletonList(I18n.func_135052_a((String)"ae2fc.tooltip.encode_pattern", (Object[])new Object[0]));
            }

            @Override
            public boolean onClick(int button) {
                if (button == 0) {
                    if (GuiFluidPatternEncoder.this.cont.canEncodePattern()) {
                        FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketEncodePattern());
                    }
                    return true;
                }
                return false;
            }
        });
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        if (this.mouseRegions.onClick(xCoord, yCoord, btn)) {
            super.func_73864_a(xCoord, yCoord, btn);
        }
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEX_BG);
        this.func_73729_b(offsetX, offsetY, 0, 0, 176, this.field_147000_g);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(I18n.func_135052_a((String)"ae2fc.gui.fluid_pattern_encoder", (Object[])new Object[0])), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 94, 0x404040);
        this.mouseRegions.render(mouseX, mouseY);
    }

    public void func_146977_a(Slot s) {
        this.drawSlot0(s);
    }

    public void drawSlot0(Slot slot) {
        if (slot instanceof ISlotFluid) {
            IAEItemStack stack = ((ISlotFluid)slot).getAeStack();
            super.func_146977_a((Slot)new SlotSingleItem(slot));
            if (stack == null) {
                return;
            }
            IAEItemStack fake = stack.copy();
            if (fake.getItemStack().func_77973_b() instanceof ItemFluidPacket && ItemFluidPacket.getFluidStack(stack) != null && ItemFluidPacket.getFluidStack((IAEItemStack)stack).amount > 0) {
                fake.setStackSize((long)ItemFluidPacket.getFluidStack((IAEItemStack)stack).amount);
            }
            this.stackSizeRenderer.setAeStack(fake);
            this.stackSizeRenderer.func_77021_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack.getItemStack(), slot.field_75223_e, slot.field_75221_f);
        } else {
            super.func_146977_a(slot);
        }
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        FluidStack fluid;
        List<String> list = stack.func_77973_b() instanceof ItemFluidPacket ? ((fluid = ItemFluidPacket.getFluidStack(stack)) != null ? Arrays.asList(fluid.getLocalizedName(), String.format(EnumChatFormatting.GRAY + "%,d mB", fluid.amount)) : stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x)) : stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, stack.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
    }
}

