/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.render.AppEngRenderItem;
import appeng.container.slot.SlotFake;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNEIDragClick;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cofh.core.render.CoFHFontRenderer;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.gui.FCGuiLineField;
import com.glodblock.github.client.gui.FCGuiTextField;
import com.glodblock.github.client.gui.GuiFCImgButton;
import com.glodblock.github.client.gui.container.ContainerLevelMaintainer;
import com.glodblock.github.common.tile.TileLevelMaintainer;
import com.glodblock.github.inventory.gui.MouseRegionManager;
import com.glodblock.github.inventory.slot.SlotFluidConvertingFake;
import com.glodblock.github.inventory.slot.SlotSingleItem;
import com.glodblock.github.network.CPacketLevelMaintainer;
import com.glodblock.github.util.Ae2ReflectClient;
import com.glodblock.github.util.NameConst;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

@Optional.Interface(modid="NotEnoughItems", iface="codechicken.nei.api.INEIGuiHandler")
public class GuiLevelMaintainer
extends AEBaseGui
implements INEIGuiHandler {
    private static final ResourceLocation TEX_BG = FluidCraft.resource("textures/gui/level_maintainer.png");
    private final ContainerLevelMaintainer cont;
    private final Component[] component = new Component[5];
    private final MouseRegionManager mouseRegions = new MouseRegionManager((GuiContainer)this);
    private final AppEngRenderItem stackSizeRenderer = Ae2ReflectClient.getStackSizeRenderer(this);
    private FCGuiTextField input;
    private int lastWorkingTick;
    private int refreshTick;
    private final CoFHFontRenderer render;

    public GuiLevelMaintainer(InventoryPlayer ipl, TileLevelMaintainer tile) {
        super((Container)new ContainerLevelMaintainer(ipl, tile));
        this.cont = (ContainerLevelMaintainer)this.field_147002_h;
        this.field_146999_f = 195;
        this.field_147000_g = 214;
        this.render = new CoFHFontRenderer(Minecraft.func_71410_x().field_71474_y, TEX_BG, Minecraft.func_71410_x().func_110434_K(), true);
        this.refreshTick = 0;
    }

    public void postUpdate(List<IAEItemStack> list) {
        for (SlotFluidConvertingFake slot : this.cont.getRequestSlots()) {
            if (slot.func_75216_d()) continue;
            this.component[slot.getSlotIndex()].setState(TileLevelMaintainer.State.Nothing);
        }
        for (IAEItemStack is : list) {
            NBTTagCompound data = is.getItemStack().func_77978_p();
            long size = data.func_74763_f("Batch");
            int i = data.func_74762_e("Index");
            boolean isEnable = data.func_74767_n("Enable");
            TileLevelMaintainer.State state = TileLevelMaintainer.State.values()[data.func_74762_e("State")];
            this.component[i].getQty().textField.func_146180_a(String.valueOf(is.getStackSize()));
            this.component[i].getBatch().textField.func_146180_a(String.valueOf(size));
            this.component[i].setEnable(isEnable);
            this.component[i].setState(state);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.lastWorkingTick = this.refreshTick;
        for (int i = 0; i < 5; ++i) {
            this.component[i] = new Component(new Widget(new FCGuiTextField(this.field_146289_q, this.field_147003_i + 46, this.field_147009_r + 19 + 19 * i, 52, 14), "ae2fc.tooltip.level_maintainer.request_size", i, "TileLevelMaintainer.Quantity"), new Widget(new FCGuiTextField(this.field_146289_q, this.field_147003_i + 100, this.field_147009_r + 19 + 19 * i, 52, 14), "ae2fc.tooltip.level_maintainer.batch_size", i, "TileLevelMaintainer.Batch"), new GuiFCImgButton(this.field_147003_i + 105 + 47, this.field_147009_r + 17 + 19 * i, "SUBMIT", "SUBMIT", false), new GuiFCImgButton(this.field_147003_i + 9, this.field_147009_r + 20 + 19 * i, "ENABLE", "ENABLE", false), new GuiFCImgButton(this.field_147003_i + 9, this.field_147009_r + 20 + 19 * i, "DISABLE", "DISABLE", false), new FCGuiLineField(this.field_146289_q, this.field_147003_i + 47, this.field_147009_r + 33 + 19 * i, 125), this.field_146292_n);
        }
        FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketLevelMaintainer("TileLevelMaintainer.refresh"));
    }

    public void func_73863_a(int mouseX, int mouseY, float btn) {
        ++this.refreshTick;
        super.func_73863_a(mouseX, mouseY, btn);
        for (Component com : this.component) {
            com.getQty().textField.handleTooltip(mouseX, mouseY, this);
            com.getBatch().textField.handleTooltip(mouseX, mouseY, this);
            com.getLine().handleTooltip(mouseX, mouseY, this);
        }
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEX_BG);
        this.func_73729_b(offsetX, offsetY, 0, 0, 176, this.field_147000_g);
        int tick = this.refreshTick;
        int interval = 20;
        if (tick > this.lastWorkingTick + interval && this.input == null) {
            FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketLevelMaintainer("TileLevelMaintainer.refresh"));
            this.lastWorkingTick = this.refreshTick;
        }
        for (int i = 0; i < 5; ++i) {
            this.component[i].draw();
        }
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(NameConst.i18n("ae2fc.gui.level_maintainer")), 8, 6, 0x404040);
        this.mouseRegions.render(mouseX, mouseY);
    }

    public void func_146977_a(Slot s) {
        if (this.drawSlot0(s)) {
            super.func_146977_a(s);
        }
    }

    public boolean drawSlot0(Slot slot) {
        if (slot instanceof SlotFake) {
            IAEItemStack stack = ((SlotFluidConvertingFake)slot).getAeStack();
            super.func_146977_a((Slot)new SlotSingleItem(slot));
            if (stack == null) {
                return true;
            }
            IAEItemStack fake = stack.copy();
            if (this.component[slot.getSlotIndex()].getQty().textField.func_146179_b().matches("[0-9]+")) {
                fake.setStackSize(Long.parseLong(this.component[slot.getSlotIndex()].getQty().textField.func_146179_b()));
            } else {
                fake.setStackSize(0L);
            }
            this.stackSizeRenderer.setAeStack(fake);
            this.stackSizeRenderer.func_77021_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack.getItemStack(), slot.field_75223_e, slot.field_75221_f);
            return false;
        }
        return true;
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        if (btn == 0) {
            if (this.input != null) {
                this.input.func_146195_b(false);
            }
            for (Component com : this.component) {
                FCGuiTextField textField = com.isMouseIn(xCoord, yCoord);
                if (textField == null) continue;
                textField.func_146195_b(true);
                this.input = textField;
                super.func_73864_a(xCoord, yCoord, btn);
                return;
            }
            this.input = null;
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_73869_a(char character, int key) {
        if (this.input == null) {
            super.func_73869_a(character, key);
            return;
        }
        if (!this.func_146983_a(key)) {
            if (character != ' ' || !this.input.func_146179_b().isEmpty()) {
                this.input.func_146201_a(character, key);
            }
            super.func_73869_a(character, key);
            if (!this.input.func_146179_b().matches("^[0-9]+")) {
                this.input.func_146193_g(0xFF0000);
            } else {
                this.input.func_146193_g(0xFFFFFF);
            }
            if (key == 28) {
                this.input.func_146195_b(false);
                this.input = null;
            }
        }
    }

    protected void func_146984_a(Slot slot, int slotIdx, int ctrlDown, int mouseButton) {
        if (slot instanceof SlotFluidConvertingFake && this.cont.getPlayerInv().func_70445_o() != null) {
            this.component[slot.getSlotIndex()].getQty().textField.func_146180_a(String.valueOf(this.cont.getPlayerInv().func_70445_o().field_77994_a));
            return;
        }
        super.func_146984_a(slot, slotIdx, ctrlDown, mouseButton);
    }

    public void updateAmount(int idx, int stackSize) {
        this.component[idx].getQty().textField.func_146180_a(String.valueOf(stackSize));
    }

    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        for (Component com : this.component) {
            if (com.sendToServer(btn)) break;
        }
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    private Rectangle getSlotArea(SlotFake slot) {
        return new Rectangle(this.field_147003_i + slot.getX(), this.field_147009_r + slot.getY(), 16, 16);
    }

    public boolean handleDragNDrop(GuiContainer gui, int mouseX, int mouseY, ItemStack draggedStack, int button) {
        for (SlotFluidConvertingFake slot : this.cont.getRequestSlots()) {
            if (!this.getSlotArea(slot).contains(mouseX, mouseY)) continue;
            slot.func_75215_d(draggedStack);
            NetworkHandler.instance.sendToServer((AppEngPacket)new PacketNEIDragClick(draggedStack, slot.getSlotIndex()));
            if (draggedStack != null) {
                this.updateAmount(slot.getSlotIndex(), draggedStack.field_77994_a);
                draggedStack.field_77994_a = 0;
            }
            return true;
        }
        if (draggedStack != null) {
            draggedStack.field_77994_a = 0;
        }
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        return false;
    }

    private class Widget {
        public final int idx;
        public final String action;
        private final FCGuiTextField textField;
        private final String tooltip;

        public Widget(FCGuiTextField textField, String tooltip, int idx, String action) {
            this.textField = textField;
            this.textField.func_146185_a(false);
            this.textField.func_146180_a("0");
            this.textField.func_146203_f(10);
            this.idx = idx;
            this.action = action;
            this.tooltip = tooltip;
        }

        public void draw() {
            if (GuiScreen.func_146272_n()) {
                this.setTooltip(GuiLevelMaintainer.this.render.func_78280_d(NameConst.i18n(this.tooltip), GuiLevelMaintainer.this.field_146999_f / 2));
            } else {
                this.setTooltip(GuiLevelMaintainer.this.render.func_78280_d(NameConst.i18n(this.tooltip, "\n", false) + "\n" + NameConst.i18n("ae2fc.tooltip.shift_for_more"), (int)Math.floor((double)GuiLevelMaintainer.this.field_146999_f * 0.8)));
            }
            this.textField.func_146194_f();
        }

        public void setTooltip(String message) {
            this.textField.setMessage(message);
        }
    }

    private class Component {
        public boolean isEnable = true;
        private final Widget qty;
        private final Widget batch;
        private final GuiFCImgButton disable;
        private final GuiFCImgButton enable;
        private final GuiFCImgButton submit;
        private final FCGuiLineField line;
        private TileLevelMaintainer.State state;

        public Component(Widget qtyInput, Widget batchInput, GuiFCImgButton submitBtn, GuiFCImgButton enableBtn, GuiFCImgButton disableBtn, FCGuiLineField line, List buttonList) {
            this.qty = qtyInput;
            this.batch = batchInput;
            this.enable = enableBtn;
            this.disable = disableBtn;
            this.submit = submitBtn;
            this.line = line;
            this.state = TileLevelMaintainer.State.Nothing;
            buttonList.add(this.submit);
            buttonList.add(this.enable);
            buttonList.add(this.disable);
        }

        public int getIndex() {
            return this.getQty().idx;
        }

        public void setEnable(boolean enable) {
            this.isEnable = enable;
        }

        private boolean send(Widget widget) {
            if (((SlotFluidConvertingFake)((GuiLevelMaintainer)GuiLevelMaintainer.this).cont.field_75151_b.get(widget.idx)).func_75216_d()) {
                if (!widget.textField.func_146179_b().isEmpty() && widget.textField.func_146179_b().matches("^[0-9]+")) {
                    String str = widget.textField.func_146179_b().replaceAll("^(0+)", "");
                    widget.textField.func_146180_a(str.isEmpty() ? "0" : str);
                    FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketLevelMaintainer(widget.action, widget.idx, widget.textField.func_146179_b()));
                    widget.textField.func_146193_g(0xFFFFFF);
                    return true;
                }
                widget.textField.func_146193_g(0xFF0000);
                return false;
            }
            return false;
        }

        protected boolean sendToServer(GuiButton btn) {
            boolean didSomething = false;
            if (this.submit == btn) {
                if (this.send(this.getQty())) {
                    this.send(this.getBatch());
                }
                didSomething = true;
            } else if (this.enable == btn) {
                FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketLevelMaintainer("TileLevelMaintainer.Enable", this.getIndex()));
                didSomething = true;
            } else if (this.disable == btn) {
                FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketLevelMaintainer("TileLevelMaintainer.Disable", this.getIndex()));
                didSomething = true;
            }
            return didSomething;
        }

        public FCGuiTextField isMouseIn(int xCoord, int yCoord) {
            if (this.getQty().textField.isMouseIn(xCoord, yCoord)) {
                return this.getQty().textField;
            }
            if (this.getBatch().textField.isMouseIn(xCoord, yCoord)) {
                return this.getBatch().textField;
            }
            return null;
        }

        public Widget getQty() {
            return this.qty;
        }

        public Widget getBatch() {
            return this.batch;
        }

        public FCGuiLineField getLine() {
            return this.line;
        }

        public void draw() {
            this.getQty().draw();
            this.getBatch().draw();
            ArrayList<String> message = new ArrayList<String>();
            message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.title") + "\n");
            switch (this.state) {
                case Idling: {
                    this.line.setColor(-11141291);
                    message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.current") + NameConst.i18n("ae2fc.tooltip.level_maintainer.idle"));
                    break;
                }
                case Crafting: {
                    this.line.setColor(-171);
                    message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.current") + NameConst.i18n("ae2fc.tooltip.level_maintainer.link"));
                    break;
                }
                case Exporting: {
                    this.line.setColor(-5635926);
                    message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.current") + NameConst.i18n("ae2fc.tooltip.level_maintainer.export"));
                    break;
                }
                default: {
                    this.line.setColor(0);
                    message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.current") + NameConst.i18n("ae2fc.tooltip.level_maintainer.none"));
                }
            }
            message.add("");
            if (GuiScreen.func_146272_n()) {
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.idle"));
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.idle_desc") + "\n");
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.link"));
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.link_desc") + "\n");
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.export"));
                message.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.export_desc"));
            } else {
                message.add(NameConst.i18n("ae2fc.tooltip.shift_for_more"));
            }
            this.line.setMessage(GuiLevelMaintainer.this.render.func_78280_d(String.join((CharSequence)"\n", message), (int)Math.floor((double)GuiLevelMaintainer.this.field_146999_f * 0.8)));
            this.line.func_146194_f();
            if (this.isEnable) {
                this.enable.field_146125_m = true;
                this.disable.field_146125_m = false;
            } else {
                this.enable.field_146125_m = false;
                this.disable.field_146125_m = true;
            }
        }

        public void setState(TileLevelMaintainer.State state) {
            this.state = state;
        }
    }
}

