/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.slot.SlotPlayerHotBar;
import appeng.container.slot.SlotPlayerInv;
import appeng.container.slot.SlotRestrictedInput;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.gui.container.base.FCContainerMonitor;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.network.CPacketFluidUpdate;
import com.glodblock.github.network.SPacketFluidUpdate;
import com.glodblock.github.network.SPacketMEInventoryUpdate;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.nio.BufferOverflowException;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.MutablePair;

public class ContainerFluidMonitor
extends FCContainerMonitor<IAEFluidStack> {
    protected final IItemList<IAEFluidStack> fluids = AEApi.instance().storage().createFluidList();

    public ContainerFluidMonitor(InventoryPlayer ip, ITerminalHost monitorable) {
        this(ip, monitorable, true);
    }

    protected ContainerFluidMonitor(InventoryPlayer ip, ITerminalHost monitorable, boolean bindInventory) {
        super(ip, monitorable, bindInventory);
        if (Platform.isServer()) {
            this.serverCM = monitorable.getConfigManager();
            if (monitorable instanceof IGridHost) {
                IGridNode node = ((IGridHost)monitorable).getGridNode(ForgeDirection.UNKNOWN);
                if (node != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                        IStorageGrid storageGrid = (IStorageGrid)g.getCache(IStorageGrid.class);
                        this.monitor = storageGrid.getFluidInventory();
                        if (this.monitor == null) {
                            this.setValidContainer(false);
                        } else {
                            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                        }
                    }
                } else {
                    this.setValidContainer(false);
                }
            } else {
                this.monitor = monitorable.getFluidInventory();
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.setPowerSource((IEnergySource)monitorable);
            }
        } else {
            this.monitor = null;
        }
        this.canAccessViewCells = false;
        if (monitorable instanceof IViewCellStorage) {
            for (int y = 0; y < 5; ++y) {
                this.cellView[y] = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.VIEW_CELL, ((IViewCellStorage)monitorable).getViewCellStorage(), y, 206, y * 18 + 8, this.getInventoryPlayer());
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
                this.func_75146_a((Slot)this.cellView[y]);
            }
        }
        if (bindInventory) {
            this.bindPlayerInventory(ip, 0, 0);
        }
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        Slot clickSlot;
        if (Platform.isClient() && !this.isEssentiaMode() && ((clickSlot = (Slot)this.field_75151_b.get(idx)) instanceof SlotPlayerInv || clickSlot instanceof SlotPlayerHotBar) && clickSlot.func_75216_d() && Util.FluidUtil.isFluidContainer(clickSlot.func_75211_c())) {
            ItemStack tis = clickSlot.func_75211_c();
            HashMap<Integer, IAEFluidStack> tmp = new HashMap<Integer, IAEFluidStack>();
            tmp.put(0, ItemFluidDrop.getAeFluidStack((IAEItemStack)AEItemStack.create((ItemStack)tis)));
            int index = Util.findItemInPlayerInvSlot(p, clickSlot.func_75211_c());
            FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketFluidUpdate(tmp, tis, index));
        }
        return super.func_82846_b(p, idx);
    }

    @Override
    protected void processItemList() {
        if (!this.fluids.isEmpty()) {
            IItemList monitorCache = this.monitor.getStorageList();
            SPacketMEInventoryUpdate piu = new SPacketMEInventoryUpdate(true);
            for (IAEFluidStack is : this.fluids) {
                IAEFluidStack send = (IAEFluidStack)monitorCache.findPrecise((IAEStack)is);
                if (send == null) {
                    is.setStackSize(0L);
                    piu.appendFluid(is);
                    continue;
                }
                piu.appendFluid(send);
            }
            if (!piu.isEmpty()) {
                this.fluids.resetStatus();
                for (Object c : this.field_75149_d) {
                    if (!(c instanceof EntityPlayer)) continue;
                    FluidCraft.proxy.netHandler.sendTo((IMessage)piu, (EntityPlayerMP)c);
                }
            }
        }
    }

    @Override
    protected void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            SPacketMEInventoryUpdate piu = new SPacketMEInventoryUpdate(true);
            IItemList monitorCache = this.monitor.getStorageList();
            for (IAEFluidStack send : monitorCache) {
                try {
                    piu.appendFluid(send);
                }
                catch (BufferOverflowException boe) {
                    FluidCraft.proxy.netHandler.sendTo((IMessage)piu, (EntityPlayerMP)c);
                    piu = new SPacketMEInventoryUpdate(true);
                    piu.appendFluid(send);
                }
            }
            FluidCraft.proxy.netHandler.sendTo((IMessage)piu, (EntityPlayerMP)c);
        }
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        for (IAEFluidStack is : change) {
            this.fluids.add((IAEStack)is);
        }
    }

    protected void dropItem(ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return;
        }
        ItemStack itemStack = is.func_77946_l();
        int i = itemStack.func_77976_d();
        while (itemStack.field_77994_a > 0) {
            if (i > itemStack.field_77994_a) {
                if (this.getPlayerInv().func_70441_a(itemStack.func_77946_l())) break;
                this.getPlayerInv().field_70458_d.func_70099_a(itemStack.func_77946_l(), 0.0f);
                break;
            }
            itemStack.field_77994_a -= i;
            ItemStack item = itemStack.func_77946_l();
            item.field_77994_a = i;
            if (this.getPlayerInv().func_70441_a(item)) continue;
            this.getPlayerInv().field_70458_d.func_70099_a(item, 0.0f);
        }
    }

    protected void dropItem(ItemStack itemStack, int stackSize) {
        if (itemStack == null || itemStack.field_77994_a <= 0) {
            return;
        }
        ItemStack is = itemStack.func_77946_l();
        is.field_77994_a = stackSize;
        this.dropItem(is);
    }

    public void postChange(Iterable<IAEFluidStack> change, ItemStack fluidContainer, EntityPlayer player, int slotIndex) {
        for (IAEFluidStack fluid : change) {
            IAEFluidStack nfluid = (IAEFluidStack)this.monitor.getStorageList().findPrecise((IAEStack)fluid);
            ItemStack out = fluidContainer.func_77946_l();
            out.field_77994_a = 1;
            if (Util.FluidUtil.isEmpty(fluidContainer) && fluid != null) {
                IAEFluidStack real;
                if (nfluid.getStackSize() <= 0L) continue;
                IAEFluidStack toExtract = nfluid.copy();
                MutablePair<Integer, ItemStack> fillStack = Util.FluidUtil.fillStack(out, toExtract.getFluidStack());
                if (fillStack.right == null || (Integer)fillStack.left <= 0) continue;
                toExtract.setStackSize((long)((Integer)fillStack.left).intValue() * (long)fluidContainer.field_77994_a);
                if (((ItemStack)fillStack.right).func_77973_b() instanceof IFluidContainerItem) {
                    real = (IAEFluidStack)this.host.getFluidInventory().extractItems((IAEStack)toExtract, Actionable.MODULATE, this.getActionSource());
                    if (real == null) continue;
                    out = fluidContainer.func_77946_l();
                    out.field_77994_a = 1;
                    fillStack = Util.FluidUtil.fillStack(out, real.getFluidStack());
                    out.field_77994_a = ((ItemStack)fillStack.right).field_77994_a = (int)(real.getStackSize() / (long)((Integer)fillStack.left).intValue());
                    if ((int)(real.getStackSize() % (long)((Integer)fillStack.left).intValue()) > 0) {
                        this.dropItem(Util.FluidUtil.setFluidContainerAmount((ItemStack)fillStack.right, (int)(real.getStackSize() % (long)((Integer)fillStack.left).intValue())), 1);
                        ++out.field_77994_a;
                    }
                } else if (FluidContainerRegistry.isContainer((ItemStack)((ItemStack)fillStack.right))) {
                    real = (IAEFluidStack)this.host.getFluidInventory().extractItems((IAEStack)toExtract, Actionable.MODULATE, this.getActionSource());
                    if (real == null) continue;
                    out = fluidContainer.func_77946_l();
                    out.field_77994_a = 1;
                    fillStack = Util.FluidUtil.fillStack(out, real.getFluidStack());
                    out.field_77994_a = ((ItemStack)fillStack.right).field_77994_a = (int)(real.getStackSize() / (long)((Integer)fillStack.left).intValue());
                    toExtract.setStackSize((long)((ItemStack)fillStack.right).field_77994_a * (long)((Integer)fillStack.left).intValue());
                }
                this.dropItem((ItemStack)fillStack.right);
            } else {
                if (Util.FluidUtil.isEmpty(fluidContainer)) continue;
                AEFluidStack fluidStack = Util.getAEFluidFromItem(fluidContainer);
                IAEFluidStack aeFluidStack = fluidStack.copy();
                IAEFluidStack notInserted = (IAEFluidStack)this.host.getFluidInventory().injectItems((IAEStack)aeFluidStack, Actionable.MODULATE, this.getActionSource());
                MutablePair<Integer, ItemStack> drainStack = Util.FluidUtil.drainStack(out.func_77946_l(), aeFluidStack.getFluidStack());
                if (notInserted != null && notInserted.getStackSize() > 0L) {
                    if (fluidStack.getStackSize() == notInserted.getStackSize()) continue;
                    aeFluidStack.decStackSize(notInserted.getStackSize());
                    if ((long)((Integer)drainStack.left).intValue() > aeFluidStack.getStackSize() && FluidContainerRegistry.isContainer((ItemStack)((ItemStack)drainStack.right))) {
                        aeFluidStack.setStackSize((long)((Integer)drainStack.left).intValue() - aeFluidStack.getStackSize());
                        this.host.getFluidInventory().extractItems((IAEStack)aeFluidStack, Actionable.MODULATE, this.getActionSource());
                        continue;
                    }
                    this.dropItem((ItemStack)drainStack.right, (int)(aeFluidStack.getStackSize() / (long)((Integer)drainStack.left).intValue()));
                    out.field_77994_a = (int)(notInserted.getStackSize() / (long)((Integer)drainStack.left).intValue());
                    if (((ItemStack)drainStack.right).func_77973_b() instanceof IFluidContainerItem) {
                        if (notInserted.getStackSize() % (long)((Integer)drainStack.left).intValue() > 0L) {
                            fluidStack.setStackSize(notInserted.getStackSize() % (long)((Integer)drainStack.left).intValue());
                            ((IFluidContainerItem)((ItemStack)drainStack.right).func_77973_b()).fill((ItemStack)drainStack.right, fluidStack.getFluidStack(), true);
                            this.dropItem((ItemStack)drainStack.right, 1);
                        }
                    } else if (FluidContainerRegistry.isContainer((ItemStack)((ItemStack)drainStack.right)) && notInserted.getStackSize() % (long)((Integer)drainStack.left).intValue() > 0L) {
                        aeFluidStack.setStackSize(aeFluidStack.getStackSize() % (long)((Integer)drainStack.left).intValue());
                        this.host.getFluidInventory().extractItems((IAEStack)aeFluidStack, Actionable.MODULATE, this.getActionSource());
                        ++out.field_77994_a;
                    }
                    if (slotIndex == -1) {
                        out.field_77994_a = fluidContainer.field_77994_a - out.field_77994_a;
                    }
                } else {
                    out.field_77994_a = slotIndex == -1 ? fluidContainer.field_77994_a : (int)((long)fluidContainer.field_77994_a - aeFluidStack.getStackSize() / (long)((Integer)drainStack.left).intValue());
                    this.dropItem((ItemStack)drainStack.right, fluidContainer.field_77994_a);
                }
            }
            if (slotIndex == -1) {
                player.field_71071_by.func_70445_o().field_77994_a -= out.field_77994_a;
                if (player.field_71071_by.func_70445_o().field_77994_a > 0) {
                    FluidCraft.proxy.netHandler.sendTo((IMessage)new SPacketFluidUpdate(new HashMap<Integer, IAEFluidStack>(), player.field_71071_by.func_70445_o()), (EntityPlayerMP)player);
                    continue;
                }
                player.field_71071_by.func_70437_b(null);
                FluidCraft.proxy.netHandler.sendTo((IMessage)new SPacketFluidUpdate(new HashMap<Integer, IAEFluidStack>()), (EntityPlayerMP)player);
                continue;
            }
            player.field_71071_by.func_70299_a(slotIndex, (ItemStack)(out.field_77994_a > 0 ? out : null));
        }
        this.func_75142_b();
    }

    protected boolean isEssentiaMode() {
        return false;
    }

    @Override
    protected boolean isWirelessTerminal() {
        return false;
    }
}

