/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.client.gui.container.ContainerLevelMaintainer;
import com.glodblock.github.network.SPacketMEUpdateBuffer;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CPacketLevelMaintainer
implements IMessage {
    private String action;
    private long size;
    private int slotIndex;

    public CPacketLevelMaintainer() {
    }

    public CPacketLevelMaintainer(String action, int slotIndex) {
        this.action = action;
        this.size = 0L;
        this.slotIndex = slotIndex;
    }

    public CPacketLevelMaintainer(String action) {
        this.action = action;
        this.size = 0L;
        this.slotIndex = 0;
    }

    public CPacketLevelMaintainer(String action, int slotIndex, long size) {
        this.action = action;
        this.size = size;
        this.slotIndex = slotIndex;
    }

    public CPacketLevelMaintainer(String action, int slotIndex, String size) {
        this.action = action;
        this.slotIndex = slotIndex;
        this.size = size.isEmpty() ? 0L : Long.parseLong(size);
    }

    public static IAEItemStack setTag(IAEItemStack ias, long batch, int slotIndex, boolean enable, int state) {
        NBTTagCompound data = new NBTTagCompound();
        ItemStack is = ias.getItemStack();
        data.func_74772_a("Batch", batch);
        data.func_74772_a("Index", (long)slotIndex);
        data.func_74757_a("Enable", enable);
        data.func_74768_a("State", state);
        is.func_77982_d(data);
        AEItemStack iaeItemStack = AEItemStack.create((ItemStack)is);
        iaeItemStack.setStackSize(ias.getStackSize());
        return iaeItemStack;
    }

    public void fromBytes(ByteBuf buf) {
        int leAction = buf.readInt();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < leAction; ++i) {
            sb.append(buf.readChar());
        }
        this.action = sb.toString();
        this.slotIndex = buf.readInt();
        this.size = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.length());
        for (int i = 0; i < this.action.length(); ++i) {
            buf.writeChar((int)this.action.charAt(i));
        }
        buf.writeInt(this.slotIndex);
        buf.writeLong(this.size);
    }

    public static class Handler
    implements IMessageHandler<CPacketLevelMaintainer, IMessage> {
        private void refresh(ContainerLevelMaintainer cca, EntityPlayerMP player) {
            ArrayList<IAEItemStack> toSend = new ArrayList<IAEItemStack>(5);
            for (int i = 0; i < 5; ++i) {
                IAEItemStack is = cca.getTile().requests.getRequestQtyStack(i);
                IAEItemStack is1 = cca.getTile().requests.getRequestBatches().getStack(i);
                if (is == null) continue;
                if (is1 != null) {
                    NBTTagCompound data = is1.getItemStack().func_77978_p();
                    toSend.add(CPacketLevelMaintainer.setTag(is, is1.getStackSize(), i, data.func_74767_n("Enable"), cca.getTile().requests.getState(i).ordinal()));
                    continue;
                }
                toSend.add(CPacketLevelMaintainer.setTag(is, 0L, i, true, 0));
            }
            SPacketMEUpdateBuffer.scheduleItemUpdate(player, toSend);
        }

        @Nullable
        public IMessage onMessage(CPacketLevelMaintainer message, MessageContext ctx) {
            if (message.action.startsWith("TileLevelMaintainer.") && ctx.getServerHandler().field_147369_b.field_71070_bA instanceof ContainerLevelMaintainer) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                ContainerLevelMaintainer cca = (ContainerLevelMaintainer)ctx.getServerHandler().field_147369_b.field_71070_bA;
                switch (message.action) {
                    case "TileLevelMaintainer.Quantity": {
                        cca.getTile().updateQuantity(message.slotIndex, message.size);
                        break;
                    }
                    case "TileLevelMaintainer.Batch": {
                        cca.getTile().updateBatchSize(message.slotIndex, message.size);
                        break;
                    }
                    case "TileLevelMaintainer.Enable": {
                        cca.getTile().setRequestStatus(message.slotIndex, false);
                        break;
                    }
                    case "TileLevelMaintainer.Disable": {
                        cca.getTile().setRequestStatus(message.slotIndex, true);
                    }
                }
                this.refresh(cca, player);
            }
            return null;
        }
    }
}

