/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.container.AEBaseContainer;
import com.glodblock.github.client.gui.GuiLevelMaintainer;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IClickableInTerminal;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class CPacketLevelTerminalCommands
implements IMessage {
    private Action action;
    private int x;
    private int y;
    private int z;
    private int dim;
    private ForgeDirection side;

    public CPacketLevelTerminalCommands() {
    }

    public CPacketLevelTerminalCommands(Action action, int x, int y, int z, int dim, ForgeDirection side) {
        this.action = action;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
        this.side = side;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
        switch (this.action) {
            case EDIT: 
            case BACK: {
                this.x = buf.readInt();
                this.y = buf.readInt();
                this.z = buf.readInt();
                this.dim = buf.readInt();
                this.side = ForgeDirection.getOrientation((int)buf.readInt());
                break;
            }
            case ENABLE: {
                break;
            }
            case DISABLE: {
                break;
            }
            case ENABLE_ALL: {
                break;
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        switch (this.action) {
            case EDIT: 
            case BACK: {
                buf.writeInt(this.x);
                buf.writeInt(this.y);
                buf.writeInt(this.z);
                buf.writeInt(this.dim);
                buf.writeInt(this.side.ordinal());
                break;
            }
            case ENABLE: {
                break;
            }
            case DISABLE: {
                break;
            }
            case ENABLE_ALL: {
                break;
            }
        }
    }

    public static enum Action {
        EDIT,
        BACK,
        ENABLE,
        DISABLE,
        ENABLE_ALL,
        DISABLE_ALL;

    }

    public static class Handler
    implements IMessageHandler<CPacketLevelTerminalCommands, IMessage> {
        public IMessage onMessage(CPacketLevelTerminalCommands message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            AEBaseContainer con = (AEBaseContainer)player.field_71070_bA;
            switch (message.action) {
                case EDIT: {
                    TileEntity tile = DimensionManager.getWorld((int)message.dim).func_147438_o(message.x, message.y, message.z);
                    InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(tile), message.side, GuiType.LEVEL_MAINTAINER);
                    break;
                }
                case BACK: {
                    GuiType originalGui = null;
                    GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
                    if (gs instanceof GuiLevelMaintainer) {
                        GuiLevelMaintainer guiLevelMaintainer = (GuiLevelMaintainer)gs;
                        originalGui = guiLevelMaintainer.getOriginalGui();
                    }
                    if (originalGui == null) {
                        return null;
                    }
                    InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(message.x, message.y, message.z, (World)DimensionManager.getWorld((int)message.dim)), message.side, originalGui);
                    break;
                }
                case ENABLE: {
                    Object gs = con.getTarget();
                    if (!(gs instanceof IClickableInTerminal)) break;
                    IClickableInTerminal clickableInterface = (IClickableInTerminal)gs;
                    Util.DimensionalCoordSide intMsg = clickableInterface.getClickedInterface();
                    TileEntity tileEntity = DimensionManager.getWorld((int)intMsg.getDimension()).func_147438_o(intMsg.x, intMsg.y, intMsg.z);
                    break;
                }
                case DISABLE: {
                    Object intMsg = con.getTarget();
                    if (!(intMsg instanceof IClickableInTerminal)) break;
                    IClickableInTerminal clickableInterface = (IClickableInTerminal)intMsg;
                    intMsg = clickableInterface.getClickedInterface();
                    TileEntity tileEntity = DimensionManager.getWorld((int)intMsg.getDimension()).func_147438_o(((Util.DimensionalCoordSide)((Object)intMsg)).x, ((Util.DimensionalCoordSide)((Object)intMsg)).y, ((Util.DimensionalCoordSide)((Object)intMsg)).z);
                    break;
                }
                case ENABLE_ALL: {
                    Object intMsg = con.getTarget();
                    if (!(intMsg instanceof IClickableInTerminal)) break;
                    IClickableInTerminal clickableInterface = (IClickableInTerminal)intMsg;
                    intMsg = clickableInterface.getClickedInterface();
                    TileEntity tileEntity = DimensionManager.getWorld((int)intMsg.getDimension()).func_147438_o(((Util.DimensionalCoordSide)((Object)intMsg)).x, ((Util.DimensionalCoordSide)((Object)intMsg)).y, ((Util.DimensionalCoordSide)((Object)intMsg)).z);
                    break;
                }
                case DISABLE_ALL: {
                    Object intMsg = con.getTarget();
                    if (!(intMsg instanceof IClickableInTerminal)) break;
                    IClickableInTerminal clickableInterface = (IClickableInTerminal)intMsg;
                    intMsg = clickableInterface.getClickedInterface();
                    TileEntity tileEntity = DimensionManager.getWorld((int)intMsg.getDimension()).func_147438_o(((Util.DimensionalCoordSide)((Object)intMsg)).x, ((Util.DimensionalCoordSide)((Object)intMsg)).y, ((Util.DimensionalCoordSide)((Object)intMsg)).z);
                }
            }
            return null;
        }
    }
}

