/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory;

import appeng.api.config.FuzzyMode;
import appeng.api.config.InsertionMode;
import appeng.api.config.Upgrades;
import appeng.api.parts.IPart;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.p2p.PartP2PLiquids;
import appeng.tile.misc.TileInterface;
import appeng.tile.networking.TileCableBus;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import cofh.api.transport.IItemDuct;
import com.glodblock.github.common.Config;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.PartFluidExportBus;
import com.glodblock.github.common.parts.PartFluidInterface;
import com.glodblock.github.common.parts.PartFluidP2PInterface;
import com.glodblock.github.common.tile.TileFluidInterface;
import com.glodblock.github.inventory.IDualHost;
import com.glodblock.github.util.Ae2Reflect;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.Util;
import crazypants.enderio.conduit.item.IItemConduit;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidConvertingInventoryAdaptor
extends InventoryAdaptor {
    private final InventoryAdaptor invItems;
    private final IFluidHandler invFluids;
    private final ForgeDirection side;
    private final BlockPos posInterface;
    @Nullable
    private final IInterfaceHost targetInterface;
    @Nullable
    private final IInterfaceHost selfInterface;
    private final boolean onmi;
    private static Method eioTypeCheck;
    private static Class<?> conduitClazz;

    public FluidConvertingInventoryAdaptor(TileEntity te, @Nullable InventoryAdaptor invItems, @Nullable IFluidHandler invFluids, ForgeDirection facing, BlockPos pos, boolean isOnmi) {
        this.invItems = invItems;
        this.invFluids = invFluids;
        this.side = facing;
        this.posInterface = pos;
        this.onmi = isOnmi;
        this.selfInterface = FluidConvertingInventoryAdaptor.getInterfaceTE(pos.getTileEntity(), facing.getOpposite());
        this.targetInterface = FluidConvertingInventoryAdaptor.getInterfaceTE(te, facing);
    }

    public static InventoryAdaptor wrap(TileEntity capProvider, ForgeDirection face) {
        TileEntity inter = capProvider.func_145831_w().func_147438_o(capProvider.field_145851_c + face.offsetX, capProvider.field_145848_d + face.offsetY, capProvider.field_145849_e + face.offsetZ);
        if (!(Config.noFluidPacket || inter instanceof TileFluidInterface || Util.getPart(inter, face.getOpposite()) instanceof PartFluidInterface || Util.getPart(inter, face.getOpposite()) instanceof PartFluidExportBus || Util.getPart(inter, face.getOpposite()) instanceof PartFluidP2PInterface)) {
            return InventoryAdaptor.getAdaptor((Object)capProvider, (ForgeDirection)face);
        }
        InventoryAdaptor item = InventoryAdaptor.getAdaptor((Object)capProvider, (ForgeDirection)face);
        IFluidHandler fluid = capProvider instanceof IFluidHandler ? (IFluidHandler)capProvider : null;
        boolean onmi = false;
        if (inter instanceof TileInterface) {
            onmi = ((TileInterface)inter).getTargets().size() > 1;
        }
        return new FluidConvertingInventoryAdaptor(capProvider, item, fluid, face, new BlockPos(inter), onmi);
    }

    public ItemStack addItems(ItemStack toBeAdded, InsertionMode insertionMode) {
        FluidStack fluid = Util.getFluidFromVirtual(toBeAdded);
        if (!this.onmi) {
            if (!this.checkValidSide(this.posInterface.getOffSet(this.side.getOpposite()).getTileEntity(), this.side.getOpposite())) {
                return toBeAdded;
            }
            if (fluid != null) {
                int filled = this.fillSideFluid(fluid, this.invFluids, this.side, true);
                fluid.amount -= filled;
                return ItemFluidPacket.newStack(fluid);
            }
            ItemStack notFilled = this.fillSideItem(toBeAdded, this.invItems, insertionMode, true);
            if (notFilled != null) {
                return this.fillEIOConduit(notFilled, this.posInterface.getOffSet(this.side.getOpposite()).getTileEntity(), this.side);
            }
            return null;
        }
        if (fluid != null) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (fluid.amount <= 0) {
                    return null;
                }
                if (!this.checkValidSide(this.posInterface.getOffSet(dir).getTileEntity(), dir)) continue;
                int filled = this.fillSideFluid(fluid, this.getSideFluid(dir), dir.getOpposite(), true);
                fluid.amount -= filled;
            }
            return ItemFluidPacket.newStack(fluid);
        }
        ItemStack item = toBeAdded.func_77946_l();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (item == null || item.field_77994_a <= 0) {
                return null;
            }
            if (!this.checkValidSide(this.posInterface.getOffSet(dir).getTileEntity(), dir)) continue;
            item = this.fillSideItem(item, this.getSideItem(dir), insertionMode, true);
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (item == null || item.field_77994_a <= 0) {
                return null;
            }
            if (!this.checkValidSide(this.posInterface.getOffSet(dir).getTileEntity(), dir)) continue;
            item = this.fillEIOConduit(item, this.posInterface.getOffSet(dir).getTileEntity(), dir.getOpposite());
        }
        return item;
    }

    public ItemStack addItems(ItemStack toBeAdded) {
        return this.addItems(toBeAdded, InsertionMode.DEFAULT);
    }

    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return this.simulateAdd(toBeSimulated, InsertionMode.DEFAULT);
    }

    public ItemStack simulateAdd(ItemStack toBeSimulated, InsertionMode insertionMode) {
        FluidStack fluid = Util.getFluidFromVirtual(toBeSimulated);
        if (!this.onmi) {
            if (!this.checkValidSide(this.posInterface.getOffSet(this.side.getOpposite()).getTileEntity(), this.side.getOpposite())) {
                return toBeSimulated;
            }
            if (fluid != null) {
                int filled = this.fillSideFluid(fluid, this.invFluids, this.side, false);
                fluid.amount -= filled;
                return ItemFluidPacket.newStack(fluid);
            }
            if (this.isConduit(this.posInterface.getOffSet(this.side.getOpposite()).getTileEntity())) {
                return null;
            }
            return this.fillSideItem(toBeSimulated, this.invItems, insertionMode, false);
        }
        boolean sus = false;
        if (fluid != null) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int filled;
                if (!this.checkValidSide(this.posInterface.getOffSet(dir).getTileEntity(), dir) || (filled = this.fillSideFluid(fluid, this.getSideFluid(dir), dir.getOpposite(), false)) <= 0) continue;
                sus = true;
                break;
            }
        } else {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!this.checkValidSide(this.posInterface.getOffSet(dir).getTileEntity(), dir)) continue;
                if (this.isConduit(this.posInterface.getOffSet(dir).getTileEntity())) {
                    return null;
                }
                ItemStack notFilled = this.fillSideItem(toBeSimulated, this.getSideItem(dir), insertionMode, false);
                if (notFilled != null && notFilled.field_77994_a >= toBeSimulated.field_77994_a) continue;
                sus = true;
                break;
            }
        }
        return sus ? null : toBeSimulated;
    }

    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.removeItems(amount, filter, destination) : null;
    }

    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.simulateRemove(amount, filter, destination) : null;
    }

    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.removeSimilarItems(amount, filter, fuzzyMode, destination) : null;
    }

    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.simulateSimilarRemove(amount, filter, fuzzyMode, destination) : null;
    }

    public boolean containsItems() {
        if (!this.onmi) {
            return this.checkItemFluids(this.invFluids, this.invItems, this.side) > 0;
        }
        boolean anyValid = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.checkValidSide(this.posInterface.getOffSet(dir).getTileEntity(), dir) || this.isItemConduit(this.posInterface.getOffSet(dir).getTileEntity())) continue;
            int result = this.checkItemFluids(this.getSideFluid(dir), this.getSideItem(dir), dir.getOpposite());
            if (result == 1) {
                return true;
            }
            if (result == 2) continue;
            anyValid = true;
        }
        return !anyValid;
    }

    public boolean hasSlots() {
        return this.invFluids != null && this.invFluids.getTankInfo(this.side).length > 0 || this.invItems != null;
    }

    public Iterator<ItemSlot> iterator() {
        FluidTankInfo[] info = null;
        if (this.invFluids != null) {
            info = this.invFluids.getTankInfo(this.side);
        }
        if (info == null) {
            info = new FluidTankInfo[]{};
        }
        return new SlotIterator(info, this.invItems != null ? this.invItems.iterator() : Collections.emptyIterator());
    }

    private IFluidHandler getSideFluid(ForgeDirection direction) {
        TileEntity te = this.posInterface.getOffSet(direction).getTileEntity();
        if (te instanceof IFluidHandler) {
            return (IFluidHandler)te;
        }
        return null;
    }

    private int fillSideFluid(FluidStack fluid, IFluidHandler tank, ForgeDirection direction, boolean doFill) {
        if (tank != null) {
            return tank.fill(direction, fluid, doFill);
        }
        return 0;
    }

    private ItemStack fillSideItem(ItemStack item, InventoryAdaptor inv, InsertionMode mode, boolean doFill) {
        if (inv != null) {
            if (doFill) {
                return inv.addItems(item, mode);
            }
            return inv.simulateAdd(item, mode);
        }
        return item;
    }

    private int gtMachineCircuitCheck(InventoryAdaptor ad) {
        if (ad == null) {
            return 0;
        }
        for (ItemSlot i : ad) {
            ItemStack is = i.getItemStack();
            if (is == null || Objects.requireNonNull(is.func_77973_b()).func_77658_a().equals("gt.integrated_circuit")) continue;
            return 1;
        }
        return 0;
    }

    private boolean isGTMachine(Object o) {
        if (!ModAndClassUtil.GT5 && !ModAndClassUtil.GT5NH) {
            return false;
        }
        if (o instanceof TileEntity) {
            TileEntity te = (TileEntity)o;
            return te.func_145838_q().func_149739_a().equals("gt.blockmachines");
        }
        return false;
    }

    private boolean isItemConduit(TileEntity te) {
        if (ModAndClassUtil.EIO && conduitClazz.isInstance(te)) {
            try {
                return eioTypeCheck.invoke((Object)te, IItemConduit.class) != null;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isConduit(TileEntity te) {
        return ModAndClassUtil.EIO && te instanceof IItemDuct;
    }

    private ItemStack fillEIOConduit(ItemStack item, TileEntity te, ForgeDirection direction) {
        if (this.isConduit(te)) {
            return ((IItemDuct)te).insertItem(direction, item);
        }
        return item;
    }

    private InventoryAdaptor getSideItem(ForgeDirection direction) {
        TileEntity te = this.posInterface.getOffSet(direction).getTileEntity();
        return InventoryAdaptor.getAdaptor((Object)te, (ForgeDirection)direction.getOpposite());
    }

    private int checkItemFluids(IFluidHandler tank, InventoryAdaptor inv, ForgeDirection direction) {
        if (tank == null && inv == null) {
            return 2;
        }
        if (this.targetInterface != null && this.targetInterface.getInstalledUpgrades(Upgrades.ADVANCED_BLOCKING) > 0 && this.targetInterface instanceof IDualHost && !((IDualHost)this.targetInterface).getDualityFluid().getFluidInventory().getStorageList().isEmpty()) {
            return 1;
        }
        if (tank != null && tank.getTankInfo(direction) != null) {
            LinkedList<FluidTankInfo[]> tankInfos = new LinkedList<FluidTankInfo[]>();
            Object object = Util.getPart(tank, direction);
            if (object instanceof PartP2PLiquids) {
                PartP2PLiquids invFluidsP2P = (PartP2PLiquids)object;
                try {
                    Iterator it = invFluidsP2P.getOutputs().iterator();
                    boolean checkedInput = false;
                    while (it.hasNext() || !checkedInput) {
                        FluidTankInfo[] info;
                        IFluidHandler target;
                        PartP2PLiquids p2p;
                        if (it.hasNext()) {
                            p2p = (PartP2PLiquids)it.next();
                        } else {
                            p2p = (PartP2PLiquids)invFluidsP2P.getInput();
                            checkedInput = true;
                        }
                        if (p2p == invFluidsP2P || p2p == null || (target = Ae2Reflect.getP2PLiquidTarget(p2p)) == null || (info = target.getTankInfo(p2p.getSide().getOpposite())) == null) continue;
                        tankInfos.add(info);
                    }
                }
                catch (GridAccessException gridAccessException) {}
            } else {
                tankInfos.add(tank.getTankInfo(direction));
            }
            boolean hasTank = false;
            object = tankInfos.iterator();
            while (object.hasNext()) {
                FluidTankInfo[] tankInfoArray;
                for (FluidTankInfo tankInfo : tankInfoArray = (FluidTankInfo[])object.next()) {
                    hasTank = true;
                    FluidStack fluid = tankInfo.fluid;
                    if (fluid == null || fluid.amount <= 0) continue;
                    return 1;
                }
            }
            if (!hasTank && inv == null) {
                return 2;
            }
        }
        if (this.isGTMachine(tank)) {
            return this.gtMachineCircuitCheck(inv);
        }
        return inv != null && inv.containsItems() ? 1 : 0;
    }

    private boolean checkValidSide(TileEntity te, ForgeDirection direction) {
        if (this.isGTMachine(te)) {
            return this.checkGTPipeConnection(te, direction.getOpposite());
        }
        return this.isDifferentGrid(FluidConvertingInventoryAdaptor.getInterfaceTE(te, direction.getOpposite()));
    }

    private boolean checkGTPipeConnection(TileEntity te, ForgeDirection direction) {
        IMetaTileEntity mte;
        if (te instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)te).getMetaTileEntity()) instanceof MetaPipeEntity) {
            return ((MetaPipeEntity)mte).isConnectedAtSide(direction);
        }
        return true;
    }

    private static IInterfaceHost getInterfaceTE(TileEntity te, ForgeDirection face) {
        IPart part;
        if (te instanceof IInterfaceHost) {
            return (IInterfaceHost)te;
        }
        if (te instanceof TileCableBus && (part = ((TileCableBus)te).getPart(face)) instanceof IInterfaceHost) {
            return (IInterfaceHost)part;
        }
        return null;
    }

    private boolean isDifferentGrid(IInterfaceHost target) {
        if (this.selfInterface != null && target != null) {
            DualityInterface other = target.getInterfaceDuality();
            DualityInterface self = this.selfInterface.getInterfaceDuality();
            try {
                AENetworkProxy proxy1 = Ae2Reflect.getInterfaceProxy(other);
                AENetworkProxy proxy2 = Ae2Reflect.getInterfaceProxy(self);
                if (proxy1.getGrid() == proxy2.getGrid()) {
                    return false;
                }
            }
            catch (GridAccessException e) {
                return true;
            }
        }
        return true;
    }

    static {
        if (ModAndClassUtil.EIO) {
            try {
                conduitClazz = Class.forName("crazypants.enderio.conduit.TileConduitBundle");
                eioTypeCheck = conduitClazz.getDeclaredMethod("getConduit", Class.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                eioTypeCheck = null;
            }
        } else {
            eioTypeCheck = null;
        }
    }

    private static class SlotIterator
    implements Iterator<ItemSlot> {
        private final FluidTankInfo[] tanks;
        private final Iterator<ItemSlot> itemSlots;
        private int nextSlotIndex = 0;

        SlotIterator(FluidTankInfo[] tanks, Iterator<ItemSlot> itemSlots) {
            this.tanks = tanks;
            this.itemSlots = itemSlots;
        }

        @Override
        public boolean hasNext() {
            return this.itemSlots.hasNext() || this.nextSlotIndex < this.tanks.length;
        }

        @Override
        public ItemSlot next() {
            if (this.nextSlotIndex < this.tanks.length) {
                FluidStack fluid = this.tanks[this.nextSlotIndex].fluid;
                ItemSlot slot = new ItemSlot();
                slot.setSlot(this.nextSlotIndex++);
                slot.setItemStack(fluid != null ? ItemFluidPacket.newStack(fluid) : null);
                Ae2Reflect.setItemSlotExtractable(slot, false);
                return slot;
            }
            ItemSlot slot = this.itemSlots.next();
            slot.setSlot(this.nextSlotIndex++);
            return slot;
        }
    }
}

