/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.loader.RecipeLoader;
import com.glodblock.github.util.Util;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.MutablePair;

public class TileFluidAutoFiller
extends AENetworkInvTile
implements ICraftingProvider,
IMEMonitorHandlerReceiver<IAEFluidStack>,
IGridTickable {
    private final AppEngInternalInventory inventory = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
    private final BaseActionSource source = new MachineSource((IActionHost)this);
    private IItemList<IAEFluidStack> fluids = AEApi.instance().storage().createFluidList();
    private final Item encodedPattern = (Item)AEApi.instance().definitions().items().encodedPattern().maybeItem().orNull();
    private IAEItemStack returnStack;
    private boolean isPowered;

    public IInventory getInventory() {
        return this.inventory;
    }

    public TileFluidAutoFiller() {
        this.getProxy().setIdlePowerUsage(1.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.inventory.func_70299_a(0, RecipeLoader.BUCKET);
    }

    public ItemStack getContainerItem() {
        return this.getInventory().func_70301_a(0);
    }

    public void setContainerItem(ItemStack is) {
        this.getInventory().func_70299_a(0, is);
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    public int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return new int[0];
    }

    public boolean canBeRotated() {
        return false;
    }

    public void updatePattern() {
        ItemStack is = this.inventory.func_70301_a(0);
        if (is == null) {
            return;
        }
        this.setContainerItem(is);
        this.postEvent();
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTEvent(NBTTagCompound data) {
        this.inventory.readFromNBT(data, "Inv");
        if (this.inventory.func_70301_a(0) == null) {
            this.inventory.func_70299_a(0, RecipeLoader.BUCKET);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public NBTTagCompound writeToNBTEvent(NBTTagCompound data) {
        this.inventory.writeToNBT(data, "Inv");
        return data;
    }

    @Nonnull
    public IInventory getInternalInventory() {
        return this.inventory;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    private IStorageGrid getStorageGrid() {
        try {
            return (IStorageGrid)this.getProxy().getGrid().getCache(IStorageGrid.class);
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        IStorageGrid storage = this.getStorageGrid();
        if (storage == null) {
            return;
        }
        IItemList fluidStorage = this.fluids.isEmpty() ? storage.getFluidInventory().getStorageList() : this.fluids;
        for (IAEFluidStack fluidStack : fluidStorage) {
            int maxCapacity;
            Fluid fluid = fluidStack.getFluid();
            if (fluid == null || (maxCapacity = Util.FluidUtil.getCapacity(this.getContainerItem(), fluid)) == 0) continue;
            MutablePair<Integer, ItemStack> filled = Util.FluidUtil.fillStack(this.getContainerItem().func_77946_l(), new FluidStack(fluid, maxCapacity));
            if (filled.right == null) continue;
            ItemStack pattern = this.getPattern(this.getContainerItem(), (ItemStack)filled.right);
            ICraftingPatternItem patter = (ICraftingPatternItem)pattern.func_77973_b();
            craftingTracker.addCraftingOption((ICraftingMedium)this, patter.getPatternForItem(pattern, this.func_145831_w()));
        }
    }

    private ItemStack getPattern(ItemStack emptyContainer, ItemStack filledContainer) {
        NBTTagList in = new NBTTagList();
        NBTTagList out = new NBTTagList();
        in.func_74742_a((NBTBase)emptyContainer.func_77955_b(new NBTTagCompound()));
        ItemStack fluidDrop = ItemFluidDrop.newStack(Util.FluidUtil.getFluidFromContainer(filledContainer));
        in.func_74742_a(this.createItemTag(fluidDrop));
        out.func_74742_a((NBTBase)filledContainer.func_77955_b(new NBTTagCompound()));
        NBTTagCompound itemTag = new NBTTagCompound();
        itemTag.func_74782_a("in", (NBTBase)in);
        itemTag.func_74782_a("out", (NBTBase)out);
        itemTag.func_74757_a("crafting", false);
        ItemStack pattern = new ItemStack(this.encodedPattern);
        pattern.func_77982_d(itemTag);
        return pattern;
    }

    protected NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (i != null) {
            Util.writeItemStackToNBT(i, c);
        }
        return c;
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        this.returnStack = AEApi.instance().storage().createItemStack(patternDetails.getCondensedOutputs()[0].getItemStack());
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return true;
    }

    public boolean isBusy() {
        return this.returnStack != null;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource source) {
        if (this.getProxy().isActive() && this.getStorageGrid() != null) {
            boolean hasChanged = false;
            IItemList stored = this.getStorageGrid().getFluidInventory().getStorageList();
            for (IAEFluidStack tmp : change) {
                if (stored.findPrecise((IAEStack)tmp) != null && this.fluids.findPrecise((IAEStack)tmp) != null) continue;
                hasChanged = true;
                this.fluids = stored;
                break;
            }
            if (hasChanged) {
                this.postEvent();
            }
        }
    }

    private boolean postEvent() {
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getGridNode(ForgeDirection.UNKNOWN)));
            return true;
        }
        catch (GridAccessException ignored) {
            return false;
        }
    }

    public void onListUpdate() {
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange p) {
        this.updatePowerState();
    }

    @MENetworkEventSubscribe
    public final void bootingRender(MENetworkBootingStatusChange c) {
        this.updatePowerState();
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            boolean bl = newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
            if (newState != this.isPowered && newState) {
                this.getProxy().getStorage().getFluidInventory().addListener((IMEMonitorHandlerReceiver)this, null);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    public void gridChanged() {
        try {
            this.getProxy().getStorage().getFluidInventory().removeListener((IMEMonitorHandlerReceiver)this);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        super.gridChanged();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 5, this.returnStack == null, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.getStorageGrid() == null) {
            return TickRateModulation.SLOWER;
        }
        IAEItemStack nodAdded = (IAEItemStack)this.getStorageGrid().getItemInventory().injectItems((IAEStack)this.returnStack, Actionable.SIMULATE, this.source);
        if (nodAdded == null) {
            this.getStorageGrid().getItemInventory().injectItems((IAEStack)this.returnStack, Actionable.MODULATE, this.source);
            this.returnStack = null;
            return TickRateModulation.SLEEP;
        }
        return TickRateModulation.SLOWER;
    }

    public boolean dropItems() {
        return false;
    }
}

