/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerPatternItemRenamer;
import appeng.helpers.InventoryAction;
import appeng.tile.networking.TileCableBus;
import appeng.util.item.AEItemStack;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.gui.container.ContainerPatternMulti;
import com.glodblock.github.client.gui.container.ContainerPatternValueAmount;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.network.SPacketSetItemAmount;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class CPacketInventoryAction
implements IMessage {
    private InventoryAction action;
    private int slot;
    private long id;
    private IAEItemStack stack;
    private boolean isEmpty;

    public CPacketInventoryAction() {
    }

    public CPacketInventoryAction(InventoryAction action, int slot, int id) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.stack = null;
        this.isEmpty = true;
    }

    public CPacketInventoryAction(InventoryAction action, int slot, int id, IAEItemStack stack) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.stack = stack;
        this.isEmpty = stack == null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.slot);
        buf.writeLong(this.id);
        buf.writeBoolean(this.isEmpty);
        if (!this.isEmpty) {
            try {
                this.stack.writeToPacket(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.action = InventoryAction.values()[buf.readInt()];
        this.slot = buf.readInt();
        this.id = buf.readLong();
        this.isEmpty = buf.readBoolean();
        if (!this.isEmpty) {
            try {
                this.stack = AEItemStack.loadItemStackFromPacket((ByteBuf)buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Handler
    implements IMessageHandler<CPacketInventoryAction, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketInventoryAction message, MessageContext ctx) {
            EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            Container container = sender.field_71070_bA;
            if (container instanceof AEBaseContainer) {
                AEBaseContainer baseContainer = (AEBaseContainer)container;
                Object target = baseContainer.getTarget();
                if (message.action == InventoryAction.AUTO_CRAFT) {
                    ContainerOpenContext context = baseContainer.getOpenContext();
                    if (context != null) {
                        TileEntity te = context.getTile();
                        if (te != null) {
                            InventoryHandler.openGui((EntityPlayer)sender, te.func_145831_w(), new BlockPos(te), Objects.requireNonNull(baseContainer.getOpenContext().getSide()), GuiType.FLUID_CRAFTING_AMOUNT);
                        } else if (target instanceof IWirelessTerminal) {
                            IWirelessTerminal wt = (IWirelessTerminal)target;
                            InventoryHandler.openGui((EntityPlayer)sender, sender.field_70170_p, new BlockPos(wt.getInventorySlot(), Util.GuiHelper.encodeType(0, Util.GuiHelper.GuiType.ITEM), 0), ForgeDirection.UNKNOWN, GuiType.FLUID_CRAFTING_AMOUNT);
                        }
                        Container container2 = sender.field_71070_bA;
                        if (container2 instanceof ContainerCraftAmount) {
                            ContainerCraftAmount cca = (ContainerCraftAmount)container2;
                            if (baseContainer.getTargetStack() != null) {
                                cca.getCraftingItem().func_75215_d(baseContainer.getTargetStack().getItemStack());
                                cca.setItemToCraft(baseContainer.getTargetStack());
                            }
                            cca.func_75142_b();
                        }
                    }
                } else if (message.action == InventoryAction.SET_PATTERN_VALUE) {
                    ContainerOpenContext context = baseContainer.getOpenContext();
                    if (context != null && message.stack != null) {
                        TileEntity te = context.getTile();
                        if (te != null) {
                            if (te instanceof TileCableBus) {
                                InventoryHandler.openGui((EntityPlayer)sender, te.func_145831_w(), new BlockPos(te), Objects.requireNonNull(baseContainer.getOpenContext().getSide()), GuiType.PATTERN_VALUE_SET);
                            } else {
                                InventoryHandler.openGui((EntityPlayer)sender, te.func_145831_w(), new BlockPos(te), Objects.requireNonNull(baseContainer.getOpenContext().getSide()), GuiType.PATTERN_VALUE_SET_TILE);
                            }
                        } else if (target instanceof IWirelessTerminal) {
                            IWirelessTerminal wt = (IWirelessTerminal)target;
                            InventoryHandler.openGui((EntityPlayer)sender, sender.field_70170_p, new BlockPos(wt.getInventorySlot(), Util.GuiHelper.encodeType(0, Util.GuiHelper.GuiType.ITEM), 0), ForgeDirection.UNKNOWN, GuiType.PATTERN_VALUE_SET);
                        }
                        int amt = (int)message.stack.getStackSize();
                        if (message.stack.getItem() instanceof ItemFluidPacket) {
                            FluidStack fluid = ItemFluidPacket.getFluidStack(message.stack);
                            amt = fluid == null ? 1 : fluid.amount;
                        }
                        FluidCraft.proxy.netHandler.sendTo(new SPacketSetItemAmount(amt), sender);
                        Container container3 = sender.field_71070_bA;
                        if (container3 instanceof ContainerPatternValueAmount) {
                            ContainerPatternValueAmount cpv = (ContainerPatternValueAmount)container3;
                            if (baseContainer.getTargetStack() != null) {
                                cpv.setValueIndex(message.slot);
                                cpv.getPatternValue().func_75215_d(baseContainer.getTargetStack().getItemStack());
                            }
                            cpv.func_75142_b();
                        }
                    }
                } else if (message.action == InventoryAction.SET_PATTERN_MULTI) {
                    ContainerOpenContext context = baseContainer.getOpenContext();
                    if (context != null) {
                        TileEntity te = context.getTile();
                        if (te != null) {
                            InventoryHandler.openGui((EntityPlayer)sender, te.func_145831_w(), new BlockPos(te), Objects.requireNonNull(baseContainer.getOpenContext().getSide()), GuiType.GUI_PATTERN_MULTI);
                        } else if (target instanceof IWirelessTerminal) {
                            IWirelessTerminal wt = (IWirelessTerminal)target;
                            InventoryHandler.openGui((EntityPlayer)sender, sender.field_70170_p, new BlockPos(wt.getInventorySlot(), Util.GuiHelper.encodeType(0, Util.GuiHelper.GuiType.ITEM), 0), ForgeDirection.UNKNOWN, GuiType.GUI_PATTERN_MULTI);
                        }
                        Container container4 = sender.field_71070_bA;
                        if (container4 instanceof ContainerPatternMulti) {
                            ContainerPatternMulti cpm = (ContainerPatternMulti)container4;
                            cpm.func_75142_b();
                        }
                    }
                } else if (message.action == InventoryAction.RENAME_PATTERN_ITEM) {
                    ContainerOpenContext context = baseContainer.getOpenContext();
                    if (context != null) {
                        TileEntity te = context.getTile();
                        if (te != null) {
                            InventoryHandler.openGui((EntityPlayer)sender, te.func_145831_w(), new BlockPos(te), Objects.requireNonNull(baseContainer.getOpenContext().getSide()), GuiType.GUI_PATTERN_ITEM_RENAMER);
                        } else if (target instanceof IWirelessTerminal) {
                            IWirelessTerminal wt = (IWirelessTerminal)target;
                            InventoryHandler.openGui((EntityPlayer)sender, sender.field_70170_p, new BlockPos(wt.getInventorySlot(), Util.GuiHelper.encodeType(0, Util.GuiHelper.GuiType.ITEM), 0), ForgeDirection.UNKNOWN, GuiType.GUI_PATTERN_ITEM_RENAMER);
                        }
                        Container container5 = sender.field_71070_bA;
                        if (container5 instanceof ContainerPatternItemRenamer) {
                            ContainerPatternItemRenamer cpir = (ContainerPatternItemRenamer)container5;
                            if (baseContainer.getTargetStack() != null) {
                                cpir.getPatternValue().func_75215_d(baseContainer.getTargetStack().getItemStack());
                            }
                            cpir.func_75142_b();
                        }
                    }
                } else {
                    baseContainer.doAction(sender, message.action, message.slot, message.id);
                }
            }
            return null;
        }
    }
}

