/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei;

import appeng.api.AEApi;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.CellInventoryHandler;
import appeng.util.IterationCounter;
import codechicken.nei.SearchField;
import codechicken.nei.SearchTokenParser;
import codechicken.nei.api.ItemFilter;
import com.glodblock.github.common.storage.IFluidCellInventory;
import com.glodblock.github.common.storage.IFluidCellInventoryHandler;
import com.glodblock.github.common.storage.IStorageFluidCell;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class NEISearchFilter
implements SearchTokenParser.ISearchParserProvider {
    public ItemFilter getFilter(String searchText) {
        Pattern pattern = SearchField.getPattern((String)searchText);
        return pattern == null ? null : new Filter(pattern);
    }

    public char getPrefix() {
        return '\u0000';
    }

    public EnumChatFormatting getHighlightedColor() {
        return null;
    }

    public SearchTokenParser.SearchMode getSearchMode() {
        return SearchTokenParser.SearchMode.ALWAYS;
    }

    public static class Filter
    implements ItemFilter {
        Pattern pattern;

        public Filter(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean matches(ItemStack itemStack) {
            boolean result;
            IItemList out;
            IFluidCellInventoryHandler handler;
            IFluidCellInventory cellInventory;
            IMEInventoryHandler inventory;
            if (itemStack.func_77973_b() instanceof IStorageFluidCell && (inventory = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.FLUIDS)) instanceof IFluidCellInventoryHandler && (cellInventory = (handler = (IFluidCellInventoryHandler)inventory).getCellInv()) != null) {
                out = new ArrayList();
                handler.getPartitionInv().forEach(((ArrayList)out)::add);
                out.addAll(cellInventory.getContents());
                for (IAEFluidStack fluid : out) {
                    result = this.pattern.matcher(fluid.getFluidStack().getLocalizedName().toLowerCase()).find();
                    if (!result) continue;
                    return true;
                }
            }
            if (itemStack.func_77973_b() instanceof IStorageCell && (inventory = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.ITEMS)) instanceof CellInventoryHandler && (cellInventory = (handler = (CellInventoryHandler)inventory).getCellInv()) != null) {
                out = AEApi.instance().storage().createItemFilterList();
                for (IAEItemStack item : handler.getPartitionList().getItems()) {
                    out.add((IAEStack)item);
                }
                cellInventory.getAvailableItems(out, IterationCounter.fetchNewId());
                for (IAEItemStack item : out) {
                    result = this.pattern.matcher(item.getItemStack().func_82833_r().toLowerCase()).find();
                    if (!result) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

