/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import com.glodblock.github.client.gui.container.ContainerLevelMaintainer;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.inventory.Container;

public class CPacketLevelMaintainer
implements IMessage {
    private Action action;
    private long size;
    private int slotIndex;

    public CPacketLevelMaintainer() {
    }

    public CPacketLevelMaintainer(Action action, int slotIndex) {
        this.action = action;
        this.slotIndex = slotIndex;
        this.size = 0L;
    }

    public CPacketLevelMaintainer(Action action, int slotIndex, long size) {
        this.action = action;
        this.slotIndex = slotIndex;
        this.size = size;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
        this.slotIndex = buf.readInt();
        this.size = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.slotIndex);
        buf.writeLong(this.size);
    }

    public static enum Action {
        Quantity,
        Batch,
        Enable,
        Disable;

    }

    public static class Handler
    implements IMessageHandler<CPacketLevelMaintainer, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketLevelMaintainer message, MessageContext ctx) {
            Container container = ctx.getServerHandler().field_147369_b.field_71070_bA;
            if (container instanceof ContainerLevelMaintainer) {
                ContainerLevelMaintainer clm = (ContainerLevelMaintainer)container;
                switch (message.action) {
                    case Quantity: {
                        clm.getTile().updateQuantity(message.slotIndex, message.size);
                        break;
                    }
                    case Batch: {
                        clm.getTile().updateBatchSize(message.slotIndex, message.size);
                        break;
                    }
                    case Enable: {
                        clm.getTile().updateStatus(message.slotIndex, false);
                        break;
                    }
                    case Disable: {
                        clm.getTile().updateStatus(message.slotIndex, true);
                    }
                }
                clm.updateGui();
            }
            return null;
        }
    }
}

