/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternOutputs;
import appeng.helpers.InventoryAction;
import appeng.util.item.AEItemStack;
import com.glodblock.github.client.gui.container.FCBasePartContainer;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.PatternConsumer;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.util.FluidPatternDetails;
import com.glodblock.github.util.Util;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ContainerFluidPatternTerminal
extends FCBasePartContainer
implements PatternConsumer {
    public ContainerFluidPatternTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
    }

    public void encodeAllItemAndMoveToInventory() {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (output != null) {
            if (this.patternSlotIN.func_75211_c() != null) {
                output.field_77994_a += this.patternSlotIN.func_75211_c().field_77994_a;
            }
            if (!this.getPlayerInv().func_70441_a(output)) {
                this.getPlayerInv().field_70458_d.func_70099_a(output, 0.0f);
            }
            this.patternSlotOUT.func_75215_d(null);
            this.patternSlotIN.func_75215_d(null);
        }
    }

    @Override
    public void encode() {
        if (!this.checkHasFluidPattern()) {
            super.encode();
            return;
        }
        ItemStack stack = this.patternSlotOUT.func_75211_c();
        if (stack == null) {
            stack = this.patternSlotIN.func_75211_c();
            if (!ContainerFluidPatternTerminal.isPattern(stack)) {
                return;
            }
            if (stack.field_77994_a == 1) {
                this.patternSlotIN.func_75215_d(null);
            } else {
                --stack.field_77994_a;
            }
            this.encodeFluidPattern();
        } else if (ContainerFluidPatternTerminal.isPattern(stack)) {
            this.encodeFluidPattern();
        }
    }

    private static boolean isPattern(ItemStack output) {
        if (output == null) {
            return false;
        }
        if (output.func_77973_b() instanceof ItemFluidEncodedPattern) {
            return true;
        }
        IDefinitions defs = AEApi.instance().definitions();
        return defs.items().encodedPattern().isSameAs(output) || defs.materials().blankPattern().isSameAs(output);
    }

    private boolean checkHasFluidPattern() {
        if (this.craftingMode) {
            return false;
        }
        boolean hasFluid = false;
        boolean search = false;
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
            ItemStack crafting = slotFakeCraftingMatrix.func_75211_c();
            if (crafting == null) continue;
            search = true;
            if (!(crafting.func_77973_b() instanceof ItemFluidPacket)) continue;
            hasFluid = true;
            break;
        }
        if (!search) {
            return false;
        }
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.outputSlots) {
            ItemStack out = slotFakeCraftingMatrix.func_75211_c();
            if (out == null) continue;
            search = false;
            if (hasFluid) break;
            if (!(out.func_77973_b() instanceof ItemFluidPacket)) continue;
            hasFluid = true;
            break;
        }
        return hasFluid && !search;
    }

    private void encodeFluidPattern() {
        ItemStack patternStack = new ItemStack((Item)ItemAndBlockHolder.PATTERN);
        FluidPatternDetails pattern = new FluidPatternDetails(patternStack);
        pattern.setInputs(ContainerFluidPatternTerminal.collectInventory((Slot[])this.craftingSlots));
        pattern.setOutputs(ContainerFluidPatternTerminal.collectInventory((Slot[])this.outputSlots));
        this.patternSlotOUT.func_75215_d(pattern.writeToStack());
    }

    private static IAEItemStack[] collectInventory(Slot[] slots) {
        IAEItemStack[] stacks = new IAEItemStack[slots.length];
        for (int i = 0; i < stacks.length; ++i) {
            IAEItemStack dropStack;
            ItemStack stack = slots[i].func_75211_c();
            if (stack != null && stack.func_77973_b() instanceof ItemFluidPacket && (dropStack = ItemFluidDrop.newAeStack(ItemFluidPacket.getFluidStack(stack))) != null) {
                stacks[i] = dropStack;
                continue;
            }
            AEItemStack aeStack = AEItemStack.create((ItemStack)stack);
            stacks[i] = aeStack;
        }
        return stacks;
    }

    @Override
    public void acceptPattern(IAEItemStack[] inputs, IAEItemStack[] outputs) {
        if (this.getPatternTerminal() != null) {
            this.getPatternTerminal().onChangeCrafting(inputs, outputs);
        }
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slotId, long id) {
        if (this.isCraftingMode()) {
            super.doAction(player, action, slotId, id);
            return;
        }
        if (slotId < 0 || slotId >= this.field_75151_b.size()) {
            super.doAction(player, action, slotId, id);
            return;
        }
        if (action == InventoryAction.MOVE_REGION) {
            super.doAction(player, InventoryAction.SPLIT_OR_PLACE_SINGLE, slotId, id);
            return;
        }
        if (action == InventoryAction.PICKUP_SINGLE) {
            super.doAction(player, InventoryAction.PICKUP_OR_SET_DOWN, slotId, id);
            return;
        }
        Slot slot = this.func_75139_a(slotId);
        ItemStack stack = player.field_71071_by.func_70445_o();
        if (Util.getFluidFromItem(stack) == null || Util.getFluidFromItem((ItemStack)stack).amount <= 0) {
            super.doAction(player, action, slotId, id);
            return;
        }
        if ((slot instanceof SlotFakeCraftingMatrix || slot instanceof SlotPatternOutputs) && (stack.func_77973_b() instanceof IFluidContainerItem || FluidContainerRegistry.isContainer((ItemStack)stack))) {
            FluidStack fluid = null;
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    fluid = Util.getFluidFromItem(stack);
                    slot.func_75215_d(ItemFluidPacket.newStack(fluid));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    fluid = Util.getFluidFromItem(Util.copyStackWithSize(stack, 1));
                    FluidStack origin = ItemFluidPacket.getFluidStack(slot.func_75211_c());
                    if (fluid != null && fluid.equals((Object)origin)) {
                        fluid.amount += origin.amount;
                        if (fluid.amount <= 0) {
                            fluid = null;
                        }
                    }
                    slot.func_75215_d(ItemFluidPacket.newStack(fluid));
                }
            }
            if (fluid == null) {
                super.doAction(player, action, slotId, id);
                return;
            }
            return;
        }
        super.doAction(player, action, slotId, id);
    }
}

