/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.storage.ITerminalHost;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.IContainerCraftingPacket;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import com.glodblock.github.client.gui.container.FCBaseMonitorContain;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.PartFluidPatternTerminalEx;
import com.glodblock.github.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class FCBasePartContainerEx
extends FCBaseMonitorContain
implements IAEAppEngInventory,
IOptionalSlotHost,
IContainerCraftingPacket {
    private static final int CRAFTING_GRID_PAGES = 2;
    private static final int CRAFTING_GRID_WIDTH = 4;
    private static final int CRAFTING_GRID_HEIGHT = 4;
    private static final int CRAFTING_GRID_SLOTS = 16;
    private final PartFluidPatternTerminalEx patternTerminal;
    protected final ProcessingSlotFake[] craftingSlots = new ProcessingSlotFake[32];
    protected final ProcessingSlotFake[] outputSlots = new ProcessingSlotFake[32];
    protected final SlotRestrictedInput patternSlotIN;
    protected final SlotRestrictedInput patternSlotOUT;
    @GuiSync(value=115)
    public boolean combine = false;
    @GuiSync(value=116)
    public boolean substitute = false;
    @GuiSync(value=120)
    public boolean inverted;
    @GuiSync(value=121)
    public int activePage = 0;
    @GuiSync(value=117)
    public boolean prioritize = false;

    public FCBasePartContainerEx(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable, false);
        this.patternTerminal = (PartFluidPatternTerminalEx)monitorable;
        this.inverted = this.patternTerminal.isInverted();
        IInventory patternInv = this.getPatternTerminal().getInventoryByName("pattern");
        IInventory output = this.getPatternTerminal().getInventoryByName("output");
        IInventory crafting = this.getPatternTerminal().getInventoryByName("crafting");
        for (int page = 0; page < 2; ++page) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    ProcessingSlotFake processingSlotFake = new ProcessingSlotFake(crafting, this, x + y * 4 + page * 16, 15, -83, x, y, x + 4);
                    this.craftingSlots[x + y * 4 + page * 16] = processingSlotFake;
                    this.func_75146_a((Slot)processingSlotFake);
                }
            }
            for (int x = 0; x < 4; ++x) {
                for (int y = 0; y < 4; ++y) {
                    ProcessingSlotFake processingSlotFake = new ProcessingSlotFake(output, this, x * 4 + y + page * 16, 112, -83, -x, y, x);
                    this.outputSlots[x * 4 + y + page * 16] = processingSlotFake;
                    this.func_75146_a((Slot)processingSlotFake);
                }
            }
        }
        this.patternSlotIN = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, patternInv, 0, 147, -81, this.getInventoryPlayer());
        this.func_75146_a((Slot)this.patternSlotIN);
        this.patternSlotOUT = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, patternInv, 1, 147, -38, this.getInventoryPlayer());
        this.func_75146_a((Slot)this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
        this.bindPlayerInventory(ip, 0, 0);
    }

    public void saveChanges() {
    }

    public void clear() {
        for (ProcessingSlotFake s : this.craftingSlots) {
            s.func_75215_d(null);
        }
        for (ProcessingSlotFake s : this.outputSlots) {
            s.func_75215_d(null);
        }
        this.func_75142_b();
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public void encodeAndMoveToInventory() {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (output != null) {
            if (!this.getPlayerInv().func_70441_a(output)) {
                this.getPlayerInv().field_70458_d.func_70099_a(output, 0.0f);
            }
            this.patternSlotOUT.func_75215_d(null);
        }
    }

    public void encode() {
        ItemStack encodedPatternStack;
        Iterator iterator;
        ItemStack output = this.patternSlotOUT.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (output != null && !this.isPattern(output)) {
            return;
        }
        if (output == null) {
            output = this.patternSlotIN.func_75211_c();
            if (!this.isPattern(output)) {
                return;
            }
            --output.field_77994_a;
            if (output.field_77994_a == 0) {
                this.patternSlotIN.func_75215_d(null);
            }
            iterator = AEApi.instance().definitions().items().encodedPattern().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                output = encodedPatternStack = (ItemStack)iterator.next();
                this.patternSlotOUT.func_75215_d(output);
            }
        } else if (output.func_77973_b() instanceof ItemFluidEncodedPattern) {
            iterator = AEApi.instance().definitions().items().encodedPattern().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                output = encodedPatternStack = (ItemStack)iterator.next();
                this.patternSlotOUT.func_75215_d(output);
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.func_74742_a(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.func_74742_a(this.createItemTag(i));
        }
        encodedValue.func_74782_a("in", (NBTBase)tagIn);
        encodedValue.func_74782_a("out", (NBTBase)tagOut);
        encodedValue.func_74757_a("substitute", this.isSubstitute());
        encodedValue.func_74782_a("in", (NBTBase)tagIn);
        encodedValue.func_74782_a("out", (NBTBase)tagOut);
        encodedValue.func_74757_a("prioritize", this.isPrioritize());
        output.func_77982_d(encodedValue);
    }

    private ItemStack[] getInputs() {
        ItemStack[] input = new ItemStack[32];
        boolean hasValue = false;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].func_75211_c();
            if (input[x] == null) continue;
            hasValue = true;
        }
        if (hasValue) {
            return input;
        }
        return null;
    }

    private ItemStack[] getOutputs() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(32);
        boolean hasValue = false;
        for (ProcessingSlotFake outputSlot : this.outputSlots) {
            ItemStack out = outputSlot.func_75211_c();
            if (out == null || out.field_77994_a <= 0) continue;
            list.add(out);
            hasValue = true;
        }
        if (hasValue) {
            return list.toArray(new ItemStack[0]);
        }
        return null;
    }

    private boolean isPattern(ItemStack output) {
        if (output == null) {
            return false;
        }
        if (output.func_77973_b() instanceof ItemFluidEncodedPattern) {
            return true;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        boolean isPattern = definitions.items().encodedPattern().isSameAs(output);
        return isPattern |= definitions.materials().blankPattern().isSameAs(output);
    }

    private NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (i != null) {
            i.func_77955_b(c);
        }
        return c;
    }

    public boolean isSlotEnabled(int idx) {
        if (idx < 4) {
            return this.inverted || idx == 0;
        }
        return !this.inverted || idx == 4;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            this.substitute = this.patternTerminal.isSubstitution();
            this.combine = this.patternTerminal.shouldCombine();
            this.prioritize = this.patternTerminal.isPrioritize();
            if (this.inverted != this.patternTerminal.isInverted() || this.activePage != this.patternTerminal.getActivePage()) {
                this.inverted = this.patternTerminal.isInverted();
                this.activePage = this.patternTerminal.getActivePage();
                this.offsetSlots();
            }
        }
    }

    private void offsetSlots() {
        for (int page = 0; page < 2; ++page) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    this.craftingSlots[x + y * 4 + page * 16].setHidden(page != this.activePage || x > 0 && this.inverted);
                    this.outputSlots[x * 4 + y + page * 16].setHidden(page != this.activePage || x > 0 && !this.inverted);
                }
            }
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (field.equals("inverted") || field.equals("activePage")) {
            this.offsetSlots();
        }
    }

    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT && Platform.isServer()) {
            this.inverted = this.patternTerminal.isInverted();
            for (Object crafter : this.field_75149_d) {
                ICrafting icrafting = (ICrafting)crafter;
                for (Object g : this.field_75151_b) {
                    if (!(g instanceof OptionalSlotFake)) continue;
                    Slot sri = (Slot)g;
                    icrafting.func_71111_a((Container)this, sri.field_75222_d, sri.func_75211_c());
                }
                ((EntityPlayerMP)icrafting).field_71137_h = false;
            }
            this.func_75142_b();
        }
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("player")) {
            return this.getInventoryPlayer();
        }
        return this.getPatternTerminal().getInventoryByName(name);
    }

    public boolean useRealItems() {
        return false;
    }

    public PartFluidPatternTerminalEx getPatternTerminal() {
        return this.patternTerminal;
    }

    private boolean isSubstitute() {
        return this.substitute;
    }

    private boolean isPrioritize() {
        return this.prioritize;
    }

    static boolean canDoubleStacks(SlotFake[] slots) {
        List enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
        long emptyStots = enabledSlots.stream().filter(s -> s.func_75211_c() == null).count();
        long fullSlots = enabledSlots.stream().filter(s -> s.func_75211_c() != null && s.func_75211_c().field_77994_a * 2 > 127).count();
        return fullSlots <= emptyStots;
    }

    static void doubleStacksInternal(SlotFake[] slots) {
        ArrayList<ItemStack> overFlowStacks = new ArrayList<ItemStack>();
        List enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
        for (Slot s : enabledSlots) {
            ItemStack st = s.func_75211_c();
            if (st == null) continue;
            if (Util.isFluidPacket(st)) {
                FluidStack fluidStack = ItemFluidPacket.getFluidStack(st);
                if (fluidStack != null) {
                    fluidStack = ItemFluidPacket.getFluidStack(st).copy();
                    if (fluidStack.amount < 0x3FFFFFFF) {
                        fluidStack.amount *= 2;
                    }
                }
                s.func_75215_d(ItemFluidPacket.newStack(fluidStack));
                continue;
            }
            if (st.field_77994_a * 2 > 127) {
                overFlowStacks.add(st.func_77946_l());
                continue;
            }
            st.field_77994_a *= 2;
            s.func_75215_d(st);
        }
        Iterator ow = overFlowStacks.iterator();
        for (Slot s : enabledSlots) {
            if (!ow.hasNext()) break;
            if (s.func_75211_c() != null) continue;
            s.func_75215_d((ItemStack)ow.next());
        }
        assert (!ow.hasNext());
    }

    public void doubleStacks(boolean isShift) {
        if (FCBasePartContainerEx.canDoubleStacks((SlotFake[])this.craftingSlots) && FCBasePartContainerEx.canDoubleStacks((SlotFake[])this.outputSlots)) {
            FCBasePartContainerEx.doubleStacksInternal((SlotFake[])this.craftingSlots);
            FCBasePartContainerEx.doubleStacksInternal((SlotFake[])this.outputSlots);
            if (isShift && !FCBasePartContainerEx.containsFluid((SlotFake[])this.outputSlots) && !FCBasePartContainerEx.containsFluid((SlotFake[])this.craftingSlots)) {
                while (FCBasePartContainerEx.canDoubleStacks((SlotFake[])this.craftingSlots) && FCBasePartContainerEx.canDoubleStacks((SlotFake[])this.outputSlots)) {
                    FCBasePartContainerEx.doubleStacksInternal((SlotFake[])this.craftingSlots);
                    FCBasePartContainerEx.doubleStacksInternal((SlotFake[])this.outputSlots);
                }
            }
            this.func_75142_b();
        }
    }

    static boolean containsFluid(SlotFake[] slots) {
        List enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
        long fluid = enabledSlots.stream().filter(s -> Util.isFluidPacket(s.func_75211_c())).count();
        return fluid > 0L;
    }

    public void setActivePage(int activePage) {
        this.activePage = activePage;
    }

    public int getActivePage() {
        return this.activePage;
    }

    private static class ProcessingSlotFake
    extends OptionalSlotFake {
        private static final int POSITION_SHIFT = 9000;
        private boolean hidden = false;

        public ProcessingSlotFake(IInventory inv, IOptionalSlotHost containerBus, int idx, int x, int y, int offX, int offY, int groupNum) {
            super(inv, containerBus, idx, x, y, offX, offY, groupNum);
            this.setRenderDisabled(false);
        }

        public void setHidden(boolean hide) {
            if (this.hidden != hide) {
                this.hidden = hide;
                this.field_75223_e += (hide ? -1 : 1) * 9000;
            }
        }
    }
}

