/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.storage;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.exceptions.AppEngException;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.common.storage.FluidCellInventoryHandler;
import com.glodblock.github.common.storage.IFluidCellInventory;
import com.glodblock.github.common.storage.IStorageFluidCell;
import com.glodblock.github.util.Util;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class FluidCellInventory
implements IFluidCellInventory {
    private static final String FLUID_TYPE_TAG = "ft";
    private static final String FLUID_COUNT_TAG = "fc";
    private static final String FLUID_SLOT = "#";
    private static final String FLUID_SLOT_COUNT = "@";
    private IStorageFluidCell cellType;
    private static String[] fluidSlots;
    private static String[] fluidSlotCount;
    private final ItemStack cellItem;
    private final ISaveProvider container;
    private static final int MAX_TYPE = 1;
    private long storedFluidCount;
    private short storedFluids;
    private IItemList<IAEFluidStack> cellItems;
    private final NBTTagCompound tagCompound;

    public FluidCellInventory(ItemStack o, ISaveProvider container) throws AppEngException {
        if (fluidSlots == null) {
            fluidSlots = new String[1];
            fluidSlotCount = new String[1];
            for (int x = 0; x < 1; ++x) {
                FluidCellInventory.fluidSlots[x] = FLUID_SLOT + x;
                FluidCellInventory.fluidSlotCount[x] = FLUID_SLOT_COUNT + x;
            }
        }
        if (o == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.cellType = null;
        this.cellItem = o;
        Item type = this.cellItem.func_77973_b();
        if (type instanceof IStorageFluidCell) {
            this.cellType = (IStorageFluidCell)this.cellItem.func_77973_b();
        }
        if (this.cellType == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        if (!this.cellType.isStorageCell(this.cellItem)) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.container = container;
        this.tagCompound = Platform.openNbtData((ItemStack)o);
        this.storedFluids = this.tagCompound.func_74765_d(FLUID_TYPE_TAG);
        this.storedFluidCount = this.tagCompound.func_74763_f(FLUID_COUNT_TAG);
        this.cellItems = null;
    }

    public static IMEInventoryHandler<IAEFluidStack> getCell(ItemStack o, ISaveProvider container2) {
        try {
            return new FluidCellInventoryHandler(new FluidCellInventory(o, container2));
        }
        catch (AppEngException e) {
            return null;
        }
    }

    public static boolean isCell(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item type = itemStack.func_77973_b();
        if (type instanceof IStorageFluidCell) {
            return ((IStorageFluidCell)type).isStorageCell(itemStack);
        }
        return false;
    }

    @Override
    public ItemStack getItemStack() {
        return this.cellItem;
    }

    @Override
    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    @Override
    public IInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.cellItem);
    }

    @Override
    public int getBytesPerType() {
        return this.cellType.getBytesPerType(this.cellItem);
    }

    @Override
    public boolean canHoldNewFluid() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedFluidCount() > 0) && this.getRemainingFluidTypes() > 0L;
    }

    @Override
    public long getTotalBytes() {
        return this.cellType.getBytes(this.cellItem);
    }

    @Override
    public long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    @Override
    public long getUsedBytes() {
        long bytesForItemCount = (this.getStoredFluidCount() + (long)this.getUnusedFluidCount()) / 8L / 256L;
        return this.getStoredFluidTypes() * (long)this.getBytesPerType() + bytesForItemCount;
    }

    @Override
    public long getTotalFluidTypes() {
        return 1L;
    }

    @Override
    public long getStoredFluidCount() {
        return this.storedFluidCount;
    }

    @Override
    public long getStoredFluidTypes() {
        return this.storedFluids;
    }

    public long getRemainingFluidTypes() {
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        long baseOnTotal = this.getTotalFluidTypes() - this.getStoredFluidTypes();
        return Math.min(basedOnStorage, baseOnTotal);
    }

    @Override
    public long getRemainingFluidCount() {
        long remaining = this.getFreeBytes() * 8L * 256L + (long)this.getUnusedFluidCount();
        return remaining > 0L ? remaining : 0L;
    }

    @Override
    public int getUnusedFluidCount() {
        int div = (int)(this.getStoredFluidCount() % 8L);
        if (div == 0) {
            return 0;
        }
        return 8 - div;
    }

    @Override
    public int getStatusForCell() {
        if (this.canHoldNewFluid()) {
            return 1;
        }
        if (this.getRemainingFluidCount() > 0L) {
            return 2;
        }
        return 3;
    }

    private void loadCellItems() {
        if (this.cellItems == null) {
            this.cellItems = AEApi.instance().storage().createFluidList();
        }
        this.cellItems.resetStatus();
        int types = (int)this.getStoredFluidTypes();
        for (int x = 0; x < types; ++x) {
            FluidStack t = FluidStack.loadFluidStackFromNBT((NBTTagCompound)this.tagCompound.func_74775_l(fluidSlots[x]));
            AEFluidStack aet = AEFluidStack.create((Object)t);
            if (aet == null) continue;
            aet.setStackSize(this.tagCompound.func_74763_f(fluidSlotCount[x]));
            if (aet.getStackSize() <= 0L) continue;
            this.cellItems.add((IAEStack)aet);
        }
    }

    private IItemList<IAEFluidStack> getCellItems() {
        if (this.cellItems == null) {
            this.loadCellItems();
        }
        return this.cellItems;
    }

    private void updateFluidCount(long delta) {
        this.storedFluidCount += delta;
        this.tagCompound.func_74772_a(FLUID_COUNT_TAG, this.storedFluidCount);
    }

    private void saveChanges() {
        long itemCount = 0L;
        int x = 0;
        for (IAEFluidStack v : this.cellItems) {
            itemCount += v.getStackSize();
            NBTBase c = this.tagCompound.func_74781_a(fluidSlots[x]);
            if (c instanceof NBTTagCompound) {
                v.writeToNBT((NBTTagCompound)c);
            } else {
                NBTTagCompound g = new NBTTagCompound();
                v.writeToNBT(g);
                this.tagCompound.func_74782_a(fluidSlots[x], (NBTBase)g);
            }
            this.tagCompound.func_74772_a(fluidSlotCount[x], v.getStackSize());
            ++x;
        }
        int oldStoredItems = this.storedFluids;
        this.storedFluids = (short)this.cellItems.size();
        if (this.cellItems.isEmpty()) {
            this.tagCompound.func_82580_o(FLUID_TYPE_TAG);
        } else {
            this.tagCompound.func_74777_a(FLUID_TYPE_TAG, this.storedFluids);
        }
        this.storedFluidCount = itemCount;
        if (itemCount == 0L) {
            this.tagCompound.func_82580_o(FLUID_COUNT_TAG);
        } else {
            this.tagCompound.func_74772_a(FLUID_COUNT_TAG, itemCount);
        }
        while (x < oldStoredItems && x < 1) {
            this.tagCompound.func_82580_o(fluidSlots[x]);
            this.tagCompound.func_82580_o(fluidSlotCount[x]);
            ++x;
        }
        if (this.container != null) {
            this.container.saveChanges((IMEInventory)this);
        }
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource src) {
        long remainingItemCount;
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (this.cellType.isBlackListed(this.cellItem, input)) {
            return input;
        }
        FluidStack sharedFluidStack = input.getFluidStack();
        IAEFluidStack l = (IAEFluidStack)this.getCellItems().findPrecise((IAEStack)input);
        if (l != null) {
            long remainingItemSlots = this.getRemainingFluidCount();
            if (remainingItemSlots < 0L) {
                return input;
            }
            if (input.getStackSize() > remainingItemSlots) {
                IAEFluidStack r = input.copy();
                r.setStackSize(r.getStackSize() - remainingItemSlots);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + remainingItemSlots);
                    this.updateFluidCount(remainingItemSlots);
                    this.saveChanges();
                }
                return r;
            }
            if (mode == Actionable.MODULATE) {
                l.setStackSize(l.getStackSize() + input.getStackSize());
                this.updateFluidCount(input.getStackSize());
                this.saveChanges();
            }
            return null;
        }
        if (this.canHoldNewFluid() && (remainingItemCount = this.getRemainingFluidCount() - (long)(this.getBytesPerType() * 8)) > 0L) {
            if (input.getStackSize() > remainingItemCount) {
                FluidStack toReturn = Util.cloneFluidStack(sharedFluidStack);
                toReturn.amount = (int)((long)sharedFluidStack.amount - remainingItemCount);
                if (mode == Actionable.MODULATE) {
                    FluidStack toWrite = Util.cloneFluidStack(sharedFluidStack);
                    toWrite.amount = (int)remainingItemCount;
                    this.cellItems.add((IAEStack)AEFluidStack.create((Object)toWrite));
                    this.updateFluidCount(toWrite.amount);
                    this.saveChanges();
                }
                return AEFluidStack.create((Object)toReturn);
            }
            if (mode == Actionable.MODULATE) {
                this.updateFluidCount(input.getStackSize());
                this.cellItems.add((IAEStack)input);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        if (request == null) {
            return null;
        }
        long size = Math.min(Integer.MAX_VALUE, request.getStackSize());
        IAEFluidStack results = null;
        IAEFluidStack l = (IAEFluidStack)this.getCellItems().findPrecise((IAEStack)request);
        if (l != null) {
            results = l.copy();
            if (l.getStackSize() <= size) {
                results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    this.updateFluidCount(-l.getStackSize());
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - size);
                    this.updateFluidCount(-size);
                    this.saveChanges();
                }
            }
        }
        return results;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        for (IAEFluidStack i : this.getCellItems()) {
            out.add((IAEStack)i);
        }
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }
}

