/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory;

import appeng.api.config.FuzzyMode;
import appeng.api.config.InsertionMode;
import appeng.tile.networking.TileCableBus;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import com.glodblock.github.common.Config;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.PartFluidInterface;
import com.glodblock.github.common.tile.TileFluidInterface;
import com.glodblock.github.util.Ae2Reflect;
import com.glodblock.github.util.Util;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidConvertingInventoryAdaptor
extends InventoryAdaptor {
    private final InventoryAdaptor invItems;
    private final IFluidHandler invFluids;
    private final ForgeDirection side;

    public static InventoryAdaptor wrap(TileEntity capProvider, EnumFacing face) {
        ForgeDirection f = Util.from(face);
        TileEntity inter = capProvider.func_145831_w().func_147438_o(capProvider.field_145851_c + f.offsetX, capProvider.field_145848_d + f.offsetY, capProvider.field_145849_e + f.offsetZ);
        if (!(Config.noFluidPacket || inter instanceof TileFluidInterface || inter instanceof TileCableBus && ((TileCableBus)inter).getPart(f.getOpposite()) instanceof PartFluidInterface)) {
            return InventoryAdaptor.getAdaptor((Object)capProvider, (ForgeDirection)f);
        }
        InventoryAdaptor item = InventoryAdaptor.getAdaptor((Object)capProvider, (ForgeDirection)f);
        IFluidHandler fluid = capProvider instanceof IFluidHandler ? (IFluidHandler)capProvider : null;
        return new FluidConvertingInventoryAdaptor(item, fluid, face);
    }

    public FluidConvertingInventoryAdaptor(@Nullable InventoryAdaptor invItems, @Nullable IFluidHandler invFluids, EnumFacing facing) {
        this.invItems = invItems;
        this.invFluids = invFluids;
        this.side = Util.from(facing);
    }

    public ItemStack addItems(ItemStack toBeAdded, InsertionMode insertionMode) {
        if (toBeAdded.func_77973_b() instanceof ItemFluidPacket) {
            int filled;
            FluidStack fluid;
            if (this.invFluids != null && (fluid = ItemFluidPacket.getFluidStack(toBeAdded)) != null && (filled = this.invFluids.fill(this.side, fluid, true)) > 0) {
                fluid.amount -= filled;
                return ItemFluidPacket.newStack(fluid);
            }
            return toBeAdded;
        }
        return this.invItems != null ? this.invItems.addItems(toBeAdded, insertionMode) : toBeAdded;
    }

    public ItemStack addItems(ItemStack toBeAdded) {
        return this.addItems(toBeAdded, InsertionMode.DEFAULT);
    }

    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return this.simulateAdd(toBeSimulated, InsertionMode.DEFAULT);
    }

    public ItemStack simulateAdd(ItemStack toBeSimulated, InsertionMode insertionMode) {
        if (toBeSimulated.func_77973_b() instanceof ItemFluidPacket) {
            int filled;
            FluidStack fluid;
            if (this.invFluids != null && (fluid = ItemFluidPacket.getFluidStack(toBeSimulated)) != null && (filled = this.invFluids.fill(this.side, fluid, false)) > 0) {
                fluid.amount -= filled;
                return ItemFluidPacket.newStack(fluid);
            }
            return toBeSimulated;
        }
        return this.invItems != null ? this.invItems.simulateAdd(toBeSimulated, insertionMode) : toBeSimulated;
    }

    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.removeItems(amount, filter, destination) : null;
    }

    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.simulateRemove(amount, filter, destination) : null;
    }

    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.removeSimilarItems(amount, filter, fuzzyMode, destination) : null;
    }

    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return this.invItems != null ? this.invItems.simulateSimilarRemove(amount, filter, fuzzyMode, destination) : null;
    }

    public boolean containsItems() {
        if (this.invFluids != null && this.invFluids.getTankInfo(this.side) != null) {
            for (FluidTankInfo tank : this.invFluids.getTankInfo(this.side)) {
                FluidStack fluid = tank.fluid;
                if (fluid == null || fluid.amount <= 0) continue;
                return true;
            }
        }
        return this.invItems != null && this.invItems.containsItems();
    }

    public boolean hasSlots() {
        return this.invFluids != null && this.invFluids.getTankInfo(this.side).length > 0 || this.invItems != null;
    }

    public Iterator<ItemSlot> iterator() {
        return new SlotIterator(this.invFluids != null ? this.invFluids.getTankInfo(this.side) : new FluidTankInfo[]{}, this.invItems != null ? this.invItems.iterator() : Collections.emptyIterator());
    }

    private static class SlotIterator
    implements Iterator<ItemSlot> {
        private final FluidTankInfo[] tanks;
        private final Iterator<ItemSlot> itemSlots;
        private int nextSlotIndex = 0;

        SlotIterator(FluidTankInfo[] tanks, Iterator<ItemSlot> itemSlots) {
            this.tanks = tanks;
            this.itemSlots = itemSlots;
        }

        @Override
        public boolean hasNext() {
            return this.nextSlotIndex < this.tanks.length || this.itemSlots.hasNext();
        }

        @Override
        public ItemSlot next() {
            if (this.nextSlotIndex < this.tanks.length) {
                FluidStack fluid = this.tanks[this.nextSlotIndex].fluid;
                ItemSlot slot = new ItemSlot();
                slot.setSlot(this.nextSlotIndex++);
                slot.setItemStack(fluid != null ? ItemFluidPacket.newStack(fluid) : null);
                Ae2Reflect.setItemSlotExtractable(slot, false);
                return slot;
            }
            ItemSlot slot = this.itemSlots.next();
            slot.setSlot(this.nextSlotIndex++);
            return slot;
        }
    }
}

