/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei.recipes.extractor;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.glodblock.github.nei.object.IRecipeExtractor;
import com.glodblock.github.nei.object.OrderStack;
import com.glodblock.github.util.Ae2Reflect;
import crazypants.enderio.machine.crusher.CrusherRecipeManager;
import crazypants.enderio.nei.VatRecipeHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class EnderIORecipeExtractor
implements IRecipeExtractor {
    @Override
    public List<OrderStack<?>> getInputIngredients(List<PositionedStack> rawInputs) {
        LinkedList tmp = new LinkedList();
        for (int i = 0; i < rawInputs.size(); ++i) {
            OrderStack<ItemStack> stack;
            if (rawInputs.get(i) == null || (stack = OrderStack.pack(rawInputs.get(i), i)) == null) continue;
            tmp.add(stack);
        }
        return tmp;
    }

    @Override
    public List<OrderStack<?>> getOutputIngredients(List<PositionedStack> rawOutputs) {
        LinkedList tmp = new LinkedList();
        for (int i = 0; i < rawOutputs.size(); ++i) {
            OrderStack<ItemStack> stack;
            if (rawOutputs.get(i) == null || (stack = OrderStack.pack(rawOutputs.get(i), i)) == null) continue;
            tmp.add(stack);
        }
        return tmp;
    }

    @Override
    public List<OrderStack<?>> getInputIngredients(List<PositionedStack> rawInputs, IRecipeHandler recipe, int index) {
        TemplateRecipeHandler tRecipe = (TemplateRecipeHandler)recipe;
        LinkedList tmp = new LinkedList();
        if (tRecipe.arecipes.get(index) instanceof VatRecipeHandler.InnerVatRecipe) {
            VatRecipeHandler.InnerVatRecipe vatRecipe = (VatRecipeHandler.InnerVatRecipe)tRecipe.arecipes.get(index);
            ArrayList inputs = ReflectEIO.getInputs(vatRecipe);
            for (int i = 0; i < inputs.size(); ++i) {
                OrderStack<ItemStack> stack;
                if (inputs.get(i) == null || (stack = OrderStack.pack(rawInputs.get(i), i)) == null) continue;
                tmp.add(stack);
            }
            FluidStack in = ReflectEIO.getInputFluid(vatRecipe);
            if (in != null) {
                tmp.add(new OrderStack<FluidStack>(in, inputs.size()));
            }
            return tmp;
        }
        if (tRecipe.getOverlayIdentifier().equals("EnderIOSagMill")) {
            for (int i = rawInputs.size() - 1; i >= 0; --i) {
                PositionedStack stack = rawInputs.get(i);
                if (stack == null || !CrusherRecipeManager.getInstance().isValidSagBall(stack.items[0])) continue;
                rawInputs.remove(i);
                break;
            }
            return this.getInputIngredients(rawInputs);
        }
        return this.getInputIngredients(rawInputs);
    }

    @Override
    public List<OrderStack<?>> getOutputIngredients(List<PositionedStack> rawOutputs, IRecipeHandler recipe, int index) {
        TemplateRecipeHandler tRecipe = (TemplateRecipeHandler)recipe;
        LinkedList tmp = new LinkedList();
        if (tRecipe.arecipes.get(index) instanceof VatRecipeHandler.InnerVatRecipe) {
            VatRecipeHandler.InnerVatRecipe vatRecipe = (VatRecipeHandler.InnerVatRecipe)tRecipe.arecipes.get(index);
            FluidStack result = ReflectEIO.getResult(vatRecipe);
            if (result != null) {
                tmp.add(new OrderStack<FluidStack>(result, 0));
            }
            return tmp;
        }
        return this.getOutputIngredients(rawOutputs);
    }

    private static class ReflectEIO {
        private static final Field inputsF;
        private static final Field resultF;
        private static final Field inFluidF;

        private ReflectEIO() {
        }

        private static ArrayList<PositionedStack> getInputs(VatRecipeHandler.InnerVatRecipe vat) {
            return (ArrayList)Ae2Reflect.readField(vat, inputsF);
        }

        private static FluidStack getResult(VatRecipeHandler.InnerVatRecipe vat) {
            return (FluidStack)Ae2Reflect.readField(vat, resultF);
        }

        private static FluidStack getInputFluid(VatRecipeHandler.InnerVatRecipe vat) {
            return (FluidStack)Ae2Reflect.readField(vat, inFluidF);
        }

        static {
            try {
                inputsF = Ae2Reflect.reflectField(VatRecipeHandler.InnerVatRecipe.class, "inputs");
                resultF = Ae2Reflect.reflectField(VatRecipeHandler.InnerVatRecipe.class, "result");
                inFluidF = Ae2Reflect.reflectField(VatRecipeHandler.InnerVatRecipe.class, "inFluid");
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Failed to initialize EIO reflection hacks!", e);
            }
        }
    }
}

