/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei.recipes.extractor;

import codechicken.nei.PositionedStack;
import com.glodblock.github.nei.object.IRecipeExtractor;
import com.glodblock.github.nei.object.OrderStack;
import gregtech.api.enums.ItemList;
import gregtech.common.items.GT_FluidDisplayItem;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GregTech5RecipeExtractor
implements IRecipeExtractor {
    boolean removeSpecial;

    public GregTech5RecipeExtractor(boolean removeSpecial) {
        this.removeSpecial = removeSpecial;
    }

    @Override
    public List<OrderStack<?>> getInputIngredients(List<PositionedStack> rawInputs) {
        if (this.removeSpecial) {
            this.removeSpecial(rawInputs);
        }
        LinkedList tmp = new LinkedList();
        for (int i = 0; i < rawInputs.size(); ++i) {
            OrderStack<ItemStack> stack;
            if (rawInputs.get(i) == null) continue;
            ItemStack item = rawInputs.get((int)i).items[0].func_77946_l();
            if (item.func_77973_b() instanceof GT_FluidDisplayItem) {
                NBTTagCompound aNBT = item.func_77978_p();
                int amt = (int)aNBT.func_74763_f("mFluidDisplayAmount");
                if (amt <= 0) continue;
                stack = new OrderStack<FluidStack>(new FluidStack(FluidRegistry.getFluid((int)item.func_77960_j()), amt), i);
                tmp.add(stack);
                continue;
            }
            stack = OrderStack.pack(rawInputs.get(i), i);
            if (stack == null) continue;
            tmp.add(stack);
        }
        return tmp;
    }

    @Override
    public List<OrderStack<?>> getOutputIngredients(List<PositionedStack> rawOutputs) {
        LinkedList tmp = new LinkedList();
        for (int i = 0; i < rawOutputs.size(); ++i) {
            OrderStack<ItemStack> stack;
            if (rawOutputs.get(i) == null) continue;
            ItemStack item = rawOutputs.get((int)i).items[0].func_77946_l();
            if (item.func_77973_b() instanceof GT_FluidDisplayItem) {
                NBTTagCompound aNBT = item.func_77978_p();
                int amt = (int)aNBT.func_74763_f("mFluidDisplayAmount");
                if (amt <= 0) continue;
                stack = new OrderStack<FluidStack>(new FluidStack(FluidRegistry.getFluid((int)item.func_77960_j()), amt), i);
                tmp.add(stack);
                continue;
            }
            stack = OrderStack.pack(rawOutputs.get(i), i);
            if (stack == null) continue;
            tmp.add(stack);
        }
        return tmp;
    }

    private void removeSpecial(List<PositionedStack> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            PositionedStack positionedStack = list.get(i);
            if (positionedStack == null || !positionedStack.items[0].func_77969_a(ItemList.Tool_DataStick.get(1L, new Object[0])) && !positionedStack.items[0].func_77969_a(ItemList.Tool_DataOrb.get(1L, new Object[0]))) continue;
            list.remove(i);
            break;
        }
    }
}

