/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei.recipes.extractor;

import codechicken.nei.PositionedStack;
import com.glodblock.github.nei.object.IRecipeExtractor;
import com.glodblock.github.nei.object.OrderStack;
import gregapi.item.ItemFluidDisplay;
import gregapi.recipes.Recipe;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregTech6RecipeExtractor
implements IRecipeExtractor {
    private final Recipe.RecipeMap Recipes;

    public GregTech6RecipeExtractor(Recipe.RecipeMap aMap) {
        this.Recipes = aMap;
    }

    @Override
    public List<OrderStack<?>> getInputIngredients(List<PositionedStack> rawInputs) {
        this.removeMachine(rawInputs);
        LinkedList tmp = new LinkedList();
        for (int i = 0; i < rawInputs.size(); ++i) {
            OrderStack<ItemStack> stack;
            if (rawInputs.get(i) == null) continue;
            ItemStack item = rawInputs.get((int)i).items[0].func_77946_l();
            if (item.func_77973_b() instanceof ItemFluidDisplay) {
                FluidStack fluid = ((ItemFluidDisplay)item.func_77973_b()).getFluid(item);
                if (fluid == null || fluid.amount <= 0) continue;
                stack = new OrderStack<FluidStack>(fluid, i);
                tmp.add(stack);
                continue;
            }
            stack = OrderStack.pack(rawInputs.get(i), i);
            if (stack == null) continue;
            tmp.add(stack);
        }
        return tmp;
    }

    @Override
    public List<OrderStack<?>> getOutputIngredients(List<PositionedStack> rawOutputs) {
        LinkedList tmp = new LinkedList();
        for (int i = 0; i < rawOutputs.size(); ++i) {
            OrderStack<ItemStack> stack;
            if (rawOutputs.get(i) == null) continue;
            ItemStack item = rawOutputs.get((int)i).items[0].func_77946_l();
            if (item.func_77973_b() instanceof ItemFluidDisplay) {
                FluidStack fluid = ((ItemFluidDisplay)item.func_77973_b()).getFluid(item);
                if (fluid == null || fluid.amount <= 0) continue;
                stack = new OrderStack<FluidStack>(fluid, i);
                tmp.add(stack);
                continue;
            }
            stack = OrderStack.pack(rawOutputs.get(i), i);
            if (stack == null) continue;
            tmp.add(stack);
        }
        return tmp;
    }

    private void removeMachine(List<PositionedStack> list) {
        block0: for (int i = list.size() - 1; i >= 0; --i) {
            PositionedStack positionedStack = list.get(i);
            if (positionedStack == null) continue;
            for (ItemStack machine : this.Recipes.mRecipeMachineList) {
                if (!positionedStack.items[0].func_77969_a(machine)) continue;
                list.remove(i);
                continue block0;
            }
        }
    }
}

