/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import com.glodblock.github.client.gui.container.ContainerFluidPatternTerminal;
import com.glodblock.github.client.gui.container.ContainerFluidPatternTerminalEx;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.nei.NEIUtils;
import com.glodblock.github.nei.object.OrderStack;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class CPacketTransferRecipe
implements IMessage {
    private List<OrderStack<?>> inputs;
    private List<OrderStack<?>> outputs;
    private boolean isCraft;
    private static final int MAX_INDEX = 32;

    public CPacketTransferRecipe() {
    }

    public CPacketTransferRecipe(List<OrderStack<?>> IN, List<OrderStack<?>> OUT, boolean craft) {
        this.inputs = IN;
        this.outputs = OUT;
        this.isCraft = craft;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isCraft);
        NBTTagCompound nbt_m = new NBTTagCompound();
        NBTTagCompound nbt_i = new NBTTagCompound();
        NBTTagCompound nbt_o = new NBTTagCompound();
        for (OrderStack<?> stack : this.inputs) {
            stack.writeToNBT(nbt_i);
        }
        for (OrderStack<?> stack : this.outputs) {
            stack.writeToNBT(nbt_o);
        }
        nbt_m.func_74782_a("i", (NBTBase)nbt_i);
        nbt_m.func_74782_a("o", (NBTBase)nbt_o);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt_m);
    }

    public void fromBytes(ByteBuf buf) {
        OrderStack<?> tmp;
        int i;
        this.isCraft = buf.readBoolean();
        this.inputs = new LinkedList();
        this.outputs = new LinkedList();
        NBTTagCompound nbt_m = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagCompound nbt_i = nbt_m.func_74775_l("i");
        NBTTagCompound nbt_o = nbt_m.func_74775_l("o");
        for (i = 0; i < 32; ++i) {
            tmp = OrderStack.readFromNBT(nbt_i, null, i);
            if (tmp == null) continue;
            this.inputs.add(tmp);
        }
        for (i = 0; i < 32; ++i) {
            tmp = OrderStack.readFromNBT(nbt_o, null, i);
            if (tmp == null) continue;
            this.outputs.add(tmp);
        }
    }

    public static class Handler
    implements IMessageHandler<CPacketTransferRecipe, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketTransferRecipe message, MessageContext ctx) {
            Container c = ctx.getServerHandler().field_147369_b.field_71070_bA;
            if (c instanceof ContainerFluidPatternTerminal) {
                ItemStack stack1;
                int index;
                int i;
                ContainerFluidPatternTerminal cf = (ContainerFluidPatternTerminal)c;
                boolean combine = cf.combine;
                cf.getPatternTerminal().setCraftingRecipe(message.isCraft);
                IInventory inputSlot = cf.getInventoryByName("crafting");
                IInventory outputSlot = cf.getInventoryByName("output");
                for (i = 0; i < inputSlot.func_70302_i_(); ++i) {
                    inputSlot.func_70299_a(i, null);
                }
                for (i = 0; i < outputSlot.func_70302_i_(); ++i) {
                    outputSlot.func_70299_a(i, null);
                }
                if (!message.isCraft) {
                    if (combine) {
                        message.inputs = NEIUtils.compress(message.inputs);
                        message.outputs = NEIUtils.compress(message.outputs);
                    }
                    message.inputs = NEIUtils.clearNull(message.inputs);
                    message.outputs = NEIUtils.clearNull(message.outputs);
                }
                for (OrderStack stack : message.inputs) {
                    if (stack == null) continue;
                    index = stack.getIndex();
                    if (stack.getStack() instanceof ItemStack) {
                        stack1 = ((ItemStack)stack.getStack()).func_77946_l();
                    } else if (stack.getStack() instanceof FluidStack) {
                        stack1 = ItemFluidPacket.newStack((FluidStack)stack.getStack());
                    } else {
                        throw new UnsupportedOperationException("Trying to get an unsupported item!");
                    }
                    if (index >= inputSlot.func_70302_i_()) continue;
                    inputSlot.func_70299_a(index, stack1);
                }
                for (OrderStack stack : message.outputs) {
                    if (stack == null) continue;
                    index = stack.getIndex();
                    if (stack.getStack() instanceof ItemStack) {
                        stack1 = ((ItemStack)stack.getStack()).func_77946_l();
                    } else if (stack.getStack() instanceof FluidStack) {
                        stack1 = ItemFluidPacket.newStack((FluidStack)stack.getStack());
                    } else {
                        throw new UnsupportedOperationException("Trying to get an unsupported item!");
                    }
                    if (index >= outputSlot.func_70302_i_()) continue;
                    outputSlot.func_70299_a(index, stack1);
                }
                c.func_75130_a(inputSlot);
                c.func_75130_a(outputSlot);
            } else if (c instanceof ContainerFluidPatternTerminalEx) {
                ItemStack stack1;
                int index;
                int i;
                ContainerFluidPatternTerminalEx cf = (ContainerFluidPatternTerminalEx)c;
                boolean combine = cf.combine;
                IInventory inputSlot = cf.getInventoryByName("crafting");
                IInventory outputSlot = cf.getInventoryByName("output");
                for (i = 0; i < inputSlot.func_70302_i_(); ++i) {
                    inputSlot.func_70299_a(i, null);
                }
                for (i = 0; i < outputSlot.func_70302_i_(); ++i) {
                    outputSlot.func_70299_a(i, null);
                }
                if (combine) {
                    message.inputs = NEIUtils.compress(message.inputs);
                    message.outputs = NEIUtils.compress(message.outputs);
                }
                message.inputs = NEIUtils.clearNull(message.inputs);
                message.outputs = NEIUtils.clearNull(message.outputs);
                for (OrderStack stack : message.inputs) {
                    if (stack == null) continue;
                    index = stack.getIndex();
                    if (stack.getStack() instanceof ItemStack) {
                        stack1 = ((ItemStack)stack.getStack()).func_77946_l();
                    } else if (stack.getStack() instanceof FluidStack) {
                        stack1 = ItemFluidPacket.newStack((FluidStack)stack.getStack());
                    } else {
                        throw new UnsupportedOperationException("Trying to get an unsupported item!");
                    }
                    if (index >= inputSlot.func_70302_i_()) continue;
                    inputSlot.func_70299_a(index, stack1);
                }
                for (OrderStack stack : message.outputs) {
                    if (stack == null) continue;
                    index = stack.getIndex();
                    if (stack.getStack() instanceof ItemStack) {
                        stack1 = ((ItemStack)stack.getStack()).func_77946_l();
                    } else if (stack.getStack() instanceof FluidStack) {
                        stack1 = ItemFluidPacket.newStack((FluidStack)stack.getStack());
                    } else {
                        throw new UnsupportedOperationException("Trying to get an unsupported item!");
                    }
                    if (index >= outputSlot.func_70302_i_()) continue;
                    outputSlot.func_70299_a(index, stack1);
                }
                c.func_75130_a(inputSlot);
                c.func_75130_a(outputSlot);
            }
            return null;
        }
    }
}

