/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.client.gui.GuiFCBaseMonitor;
import com.glodblock.github.client.gui.GuiFluidCraftConfirm;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class SPacketMEInventoryUpdate
implements IMessage {
    private List<IAEItemStack> list;
    private byte ref;

    public SPacketMEInventoryUpdate() {
        this.ref = 0;
        this.list = new LinkedList<IAEItemStack>();
    }

    public SPacketMEInventoryUpdate(byte b) {
        this.ref = b;
        this.list = new LinkedList<IAEItemStack>();
    }

    public void fromBytes(ByteBuf buf) {
        long amount = buf.readLong();
        this.ref = buf.readByte();
        this.list = new LinkedList<IAEItemStack>();
        try {
            int i = 0;
            while ((long)i < amount) {
                this.list.add(AEItemStack.loadItemStackFromPacket((ByteBuf)buf));
                ++i;
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong((long)this.list.size());
        buf.writeByte((int)this.ref);
        try {
            for (IAEItemStack itemStack : this.list) {
                itemStack.writeToPacket(buf);
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public void appendItem(IAEItemStack is) throws BufferOverflowException {
        this.list.add(is);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public static class Handler
    implements IMessageHandler<SPacketMEInventoryUpdate, IMessage> {
        public IMessage onMessage(SPacketMEInventoryUpdate message, MessageContext ctx) {
            GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
            if (gs instanceof GuiFCBaseMonitor) {
                ((GuiFCBaseMonitor)gs).postUpdate(message.list);
            } else if (gs instanceof GuiFluidCraftConfirm) {
                ((GuiFluidCraftConfirm)gs).postUpdate(message.list, message.ref);
            }
            return null;
        }
    }
}

