/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.api;

import com.mojang.authlib.GameProfile;
import glowredman.amazingtrophies.api.AchievementProperties;
import glowredman.amazingtrophies.api.ConditionHandler;
import glowredman.amazingtrophies.api.TrophyModelHandler;
import glowredman.amazingtrophies.api.TrophyProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class AmazingTrophiesAPI {
    public static final String TAGNAME_ID = "trophyID";
    public static final String TAGNAME_TIME = "time";
    public static final String TAGNAME_UUID = "uuid";
    public static final String TAGNAME_NAME = "name";
    static final Logger LOGGER = LogManager.getLogger((String)"Amazing Trophies API");
    private static final Map<String, AchievementProperties> ACHIEVEMENTS = new LinkedHashMap<String, AchievementProperties>();
    private static final Map<String, TrophyProperties> TROPHIES = new LinkedHashMap<String, TrophyProperties>();
    private static final Map<String, ConditionHandler> ACHIEVEMENT_CONDITION_HANDLERS = new HashMap<String, ConditionHandler>();
    private static final Map<String, ConditionHandler> TROPHY_CONDITION_HANDLERS = new HashMap<String, ConditionHandler>();
    private static final Map<String, Supplier<TrophyModelHandler>> TROPHY_MODEL_HANDLER_PROVIDERS = new HashMap<String, Supplier<TrophyModelHandler>>();
    private static Block blockTrophy;

    @Nullable
    public static AchievementProperties getAchievementProperties(@Nullable String id) {
        return ACHIEVEMENTS.get(id);
    }

    public static Set<String> getAchievementIDs() {
        return ACHIEVEMENTS.keySet();
    }

    public static Collection<AchievementProperties> getAchievements() {
        return ACHIEVEMENTS.values();
    }

    @Nullable
    public static TrophyProperties getTrophyProperties(@Nullable String id) {
        return TROPHIES.get(id);
    }

    public static Set<String> getTrophyIDs() {
        return TROPHIES.keySet();
    }

    public static Collection<TrophyProperties> getTrophies() {
        return TROPHIES.values();
    }

    @Nullable
    public static ConditionHandler getAchievementConditionHandler(@Nullable String id) {
        return ACHIEVEMENT_CONDITION_HANDLERS.get(id);
    }

    public static Set<String> getAchievementConditionHandlerIDs() {
        return ACHIEVEMENT_CONDITION_HANDLERS.keySet();
    }

    public static Collection<ConditionHandler> getAchievementConditionHandlers() {
        return ACHIEVEMENT_CONDITION_HANDLERS.values();
    }

    @Nullable
    public static ConditionHandler getTrophyConditionHandler(@Nullable String id) {
        return TROPHY_CONDITION_HANDLERS.get(id);
    }

    public static Set<String> getTrophyConditionHandlerIDs() {
        return TROPHY_CONDITION_HANDLERS.keySet();
    }

    public static Collection<ConditionHandler> getTrophyConditionHandlers() {
        return TROPHY_CONDITION_HANDLERS.values();
    }

    @Nullable
    public static Supplier<TrophyModelHandler> getTrophyModelHandlerProvider(@Nullable String id) {
        return TROPHY_MODEL_HANDLER_PROVIDERS.get(id);
    }

    public static Set<String> getTrophyModelHandlerProviderIDs() {
        return TROPHY_MODEL_HANDLER_PROVIDERS.keySet();
    }

    public static Collection<Supplier<TrophyModelHandler>> getTrophyModelHandlerProviders() {
        return TROPHY_MODEL_HANDLER_PROVIDERS.values();
    }

    @Nullable
    public static Block getTrophyBlock() {
        return blockTrophy;
    }

    public static ItemStack getTrophyWithNBT(String trophyID, @Nullable EntityPlayer player) {
        ItemStack stack = new ItemStack(blockTrophy);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a(TAGNAME_ID, trophyID);
        if (player != null) {
            GameProfile gameProfile = player.func_146103_bH();
            nbt.func_74772_a(TAGNAME_TIME, System.currentTimeMillis());
            nbt.func_74778_a(TAGNAME_UUID, gameProfile.getId().toString());
            nbt.func_74778_a(TAGNAME_NAME, gameProfile.getName());
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    public static void awardTrophy(String trophyID, EntityPlayer player) {
        ItemStack trophy = AmazingTrophiesAPI.getTrophyWithNBT(trophyID, player);
        if (player.field_71071_by.func_70441_a(trophy)) {
            return;
        }
        World world = player.field_70170_p;
        world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, trophy));
    }

    public static boolean setTrophyBlock(Block block) {
        if (blockTrophy == null) {
            blockTrophy = block;
            return true;
        }
        LOGGER.error("Could not set trophy block to {}, already set to {}!", new Object[]{block.getClass().getName(), blockTrophy.getClass().getName()});
        return false;
    }

    public static void registerAchievement(String id, AchievementProperties props) {
        if (ACHIEVEMENTS.containsKey(id)) {
            LOGGER.error("Achievement with id {} already exists! {} will not be registered.", new Object[]{id, props});
            return;
        }
        props.setID(id);
        ACHIEVEMENTS.put(id, props);
    }

    public static void registerTrophy(String id, TrophyProperties props) {
        if (TROPHIES.containsKey(id)) {
            LOGGER.error("Trophy with id {} already exists! {} will not be registered.", new Object[]{id, props});
            return;
        }
        props.setID(id);
        TROPHIES.put(id, props);
    }

    public static void registerConditionHandler(Supplier<ConditionHandler> handlerSupplier) {
        ConditionHandler achievementHandler = handlerSupplier.get();
        String id = achievementHandler.getID();
        if (ACHIEVEMENT_CONDITION_HANDLERS.containsKey(id)) {
            LOGGER.error("Condition Handler with id {} already exists! {} will not be registered.", new Object[]{id, achievementHandler.getClass().getName()});
            return;
        }
        achievementHandler.setOwner("achievements");
        achievementHandler.setListener((achievementID, player) -> {
            StatBase stat = StatList.func_151177_a((String)achievementID);
            if (stat == null || !stat.func_75967_d()) {
                return;
            }
            player.func_71029_a(stat);
        });
        ACHIEVEMENT_CONDITION_HANDLERS.put(id, achievementHandler);
        ConditionHandler trophyHandler = handlerSupplier.get();
        trophyHandler.setOwner("trophies");
        trophyHandler.setListener(AmazingTrophiesAPI::awardTrophy);
        TROPHY_CONDITION_HANDLERS.put(id, trophyHandler);
    }

    public static void registerTrophyModelHandlerProvider(String id, Supplier<TrophyModelHandler> provider) {
        if (TROPHY_MODEL_HANDLER_PROVIDERS.containsKey(id)) {
            LOGGER.error("Trophy model handler with id {} already exists! {} will not be registered.", new Object[]{id, provider});
            return;
        }
        TROPHY_MODEL_HANDLER_PROVIDERS.put(id, provider);
    }
}

