/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.resource.GLAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.math.BigInteger;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import jss.notfine.config.MCPatcherForgeConfig;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class MipmapHelper {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.EXTENDED_HD);
    private static final ResourceLocation MIPMAP_PROPERTIES = TexturePackAPI.newMCPatcherResourceLocation("mipmap.properties");
    static final int TEX_FORMAT = 32993;
    static final int TEX_DATA_TYPE = 33639;
    private static final boolean mipmapSupported;
    static final boolean mipmapEnabled;
    static final int maxMipmapLevel;
    private static final boolean useMipmap;
    private static final boolean anisoSupported;
    static final int anisoLevel;
    private static final int anisoMax;
    private static final boolean lodSupported;
    private static final int lodBias;
    private static final Map<String, Boolean> mipmapType;

    static void setupTexture(int width, int height, boolean blur, boolean clamp, String textureName) {
        int wrap;
        int mipmaps = MipmapHelper.useMipmapsForTexture(textureName) ? MipmapHelper.getMipmapLevels(width, height, 1) : 0;
        logger.finer("setupTexture(%s) %dx%d %d mipmaps", textureName, width, height, mipmaps);
        int magFilter = blur ? 9729 : 9728;
        int minFilter = mipmaps > 0 ? 9986 : magFilter;
        int n = wrap = clamp ? 10496 : 10497;
        if (mipmaps > 0) {
            GL11.glTexParameteri((int)3553, (int)33085, (int)mipmaps);
            MipmapHelper.checkGLError("%s: set GL_TEXTURE_MAX_LEVEL = %d", textureName, mipmaps);
            if (anisoSupported && anisoLevel > 1) {
                GL11.glTexParameterf((int)3553, (int)34046, (float)anisoLevel);
                MipmapHelper.checkGLError("%s: set GL_TEXTURE_MAX_ANISOTROPY_EXT = %f", textureName, anisoLevel);
            }
            if (lodSupported) {
                GL11.glTexEnvi((int)34048, (int)34049, (int)lodBias);
                MipmapHelper.checkGLError("%s: set GL_TEXTURE_LOD_BIAS_EXT = %d", textureName, lodBias);
            }
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
        GL11.glTexParameteri((int)3553, (int)10242, (int)wrap);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wrap);
        for (int level = 0; level <= mipmaps; ++level) {
            GL11.glTexImage2D((int)3553, (int)level, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)null);
            MipmapHelper.checkGLError("%s: glTexImage2D %dx%d level %d", textureName, width, height, level);
            width >>= 1;
            height >>= 1;
        }
    }

    public static void setupTexture(int glTexture, int width, int height, String textureName) {
        GLAPI.glBindTexture(glTexture);
        logger.finer("setupTexture(tilesheet %s, %d, %dx%d)", textureName, glTexture, width, height);
        MipmapHelper.setupTexture(width, height, false, false, textureName);
    }

    static void reset() {
        mipmapType.clear();
        mipmapType.put("terrain", true);
        mipmapType.put("items", false);
        PropertiesFile properties = PropertiesFile.get(logger, MIPMAP_PROPERTIES);
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey().trim();
                boolean value = Boolean.parseBoolean(entry.getValue().trim().toLowerCase());
                if (!key.endsWith(".png")) continue;
                mipmapType.put(key, value);
            }
        }
    }

    static boolean useMipmapsForTexture(String texture) {
        if (!useMipmap || texture == null) {
            return false;
        }
        if (mipmapType.containsKey(texture)) {
            return mipmapType.get(texture);
        }
        return !texture.contains("item") && !texture.startsWith("textures/colormap/") && !texture.startsWith("textures/environment/") && !texture.startsWith("textures/font/") && !texture.startsWith("textures/gui/") && !texture.startsWith("textures/map/") && !texture.startsWith("textures/misc/") && !texture.startsWith("mcpatcher/colormap/") && !texture.startsWith("mcpatcher/cit/") && !texture.startsWith("mcpatcher/dial/") && !texture.startsWith("mcpatcher/font/") && !texture.startsWith("mcpatcher/lightmap/") && !texture.startsWith("mcpatcher/sky/") && !texture.startsWith("%") && !texture.startsWith("##") && !texture.startsWith("/achievement/") && !texture.startsWith("/environment/") && !texture.startsWith("/font/") && !texture.startsWith("/gui/") && !texture.startsWith("/misc/") && !texture.startsWith("/terrain/") && !texture.startsWith("/title/");
    }

    static int getMipmapLevelsForCurrentTexture() {
        int filter = GL11.glGetTexParameteri((int)3553, (int)10241);
        if (filter != 9986 && filter != 9984) {
            return 0;
        }
        return Math.min(maxMipmapLevel, GL11.glGetTexParameteri((int)3553, (int)33085));
    }

    private static int gcd(int a, int b) {
        return BigInteger.valueOf(a).gcd(BigInteger.valueOf(b)).intValue();
    }

    private static int getMipmapLevels(int width, int height, int minSize) {
        int mipmap;
        int size = MipmapHelper.gcd(width, height);
        for (mipmap = 0; size >= minSize && (size & 1) == 0 && mipmap < maxMipmapLevel; size >>= 1, ++mipmap) {
        }
        return mipmap;
    }

    static void scaleHalf(IntBuffer in, int w, int h, IntBuffer out, int rotate) {
        for (int i = 0; i < w / 2; ++i) {
            for (int j = 0; j < h / 2; ++j) {
                int k = w * 2 * j + 2 * i;
                int pixel00 = in.get(k);
                int pixel01 = in.get(k + 1);
                int pixel10 = in.get(k + w);
                int pixel11 = in.get(k + w + 1);
                if (rotate != 0) {
                    pixel00 = Integer.rotateLeft(pixel00, rotate);
                    pixel01 = Integer.rotateLeft(pixel01, rotate);
                    pixel10 = Integer.rotateLeft(pixel10, rotate);
                    pixel11 = Integer.rotateLeft(pixel11, rotate);
                }
                int pixel = MipmapHelper.average4RGBA(pixel00, pixel01, pixel10, pixel11);
                if (rotate != 0) {
                    pixel = Integer.rotateRight(pixel, rotate);
                }
                out.put(w / 2 * j + i, pixel);
            }
        }
    }

    private static int average4RGBA(int pixel00, int pixel01, int pixel10, int pixel11) {
        int a00 = pixel00 & 0xFF;
        int a01 = pixel01 & 0xFF;
        int a10 = pixel10 & 0xFF;
        int a11 = pixel11 & 0xFF;
        switch (a00 << 24 | a01 << 16 | a10 << 8 | a11) {
            case -16777216: {
                return pixel00;
            }
            case 0xFF0000: {
                return pixel01;
            }
            case 65280: {
                return pixel10;
            }
            case 255: {
                return pixel11;
            }
            case -65536: {
                return MipmapHelper.average2RGBA(pixel00, pixel01);
            }
            case -16711936: {
                return MipmapHelper.average2RGBA(pixel00, pixel10);
            }
            case -16776961: {
                return MipmapHelper.average2RGBA(pixel00, pixel11);
            }
            case 0xFFFF00: {
                return MipmapHelper.average2RGBA(pixel01, pixel10);
            }
            case 0xFF00FF: {
                return MipmapHelper.average2RGBA(pixel01, pixel11);
            }
            case 65535: {
                return MipmapHelper.average2RGBA(pixel10, pixel11);
            }
            case -1: 
            case 0: {
                return MipmapHelper.average2RGBA(MipmapHelper.average2RGBA(pixel00, pixel11), MipmapHelper.average2RGBA(pixel01, pixel10));
            }
        }
        int a = a00 + a01 + a10 + a11;
        int pixel = a >> 2;
        for (int i = 8; i < 32; i += 8) {
            int average = (a00 * (pixel00 >> i & 0xFF) + a01 * (pixel01 >> i & 0xFF) + a10 * (pixel10 >> i & 0xFF) + a11 * (pixel11 >> i & 0xFF)) / a;
            pixel |= average << i;
        }
        return pixel;
    }

    private static int average2RGBA(int a, int b) {
        return ((a & 0xFEFEFEFE) >>> 1) + ((b & 0xFEFEFEFE) >>> 1) | a & b & 0x1010101;
    }

    private static void checkGLError(String format, Object ... params) {
        int error = GL11.glGetError();
        if (error != 0) {
            String message = GLU.gluErrorString((int)error) + ": " + String.format(format, params);
            new RuntimeException(message).printStackTrace();
        }
    }

    static {
        mipmapEnabled = MCPatcherForgeConfig.instance().mipmap;
        maxMipmapLevel = MCPatcherForgeConfig.instance().maxMipMapLevel;
        mipmapType = new HashMap<String, Boolean>();
        mipmapSupported = GLContext.getCapabilities().OpenGL12;
        useMipmap = mipmapSupported && mipmapEnabled && maxMipmapLevel > 0;
        anisoSupported = GLContext.getCapabilities().GL_EXT_texture_filter_anisotropic;
        if (anisoSupported) {
            anisoMax = (int)GL11.glGetFloat((int)34047);
            MipmapHelper.checkGLError("glGetFloat(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT)", new Object[0]);
            anisoLevel = Math.max(Math.min(MCPatcherForgeConfig.instance().anisotropicFiltering, anisoMax), 1);
        } else {
            anisoLevel = 1;
            anisoMax = 1;
        }
        lodSupported = GLContext.getCapabilities().GL_EXT_texture_lod_bias;
        lodBias = lodSupported ? MCPatcherForgeConfig.instance().lodBias : 0;
        logger.config("mipmap: supported=%s, enabled=%s, level=%d", mipmapSupported, mipmapEnabled, maxMipmapLevel);
        logger.config("anisotropic: supported=%s, level=%d, max=%d", anisoSupported, anisoLevel, anisoMax);
        logger.config("lod bias: supported=%s, bias=%d", lodSupported, lodBias);
    }
}

