/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.asm;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import jss.notfine.config.MCPatcherForgeConfig;

public enum AsmTransformers {
    RENDERBLOCKS("RenderBlocks transformer", () -> AngelicaConfig.enableMCPatcherForgeFeatures && MCPatcherForgeConfig.instance().customColorsEnabled, Side.CLIENT, "jss.notfine.asm.RenderBlocksTransformer"),
    WORLDRENDERER("WorldRenderer transformer", () -> AngelicaConfig.enableMCPatcherForgeFeatures, Side.CLIENT, "jss.notfine.asm.WorldRendererTransformer");

    private final Supplier<Boolean> applyIf;
    private final Side side;
    private final String[] transformerClasses;

    private AsmTransformers(String description, Supplier<Boolean> applyIf, Side side, String ... transformers) {
        this.applyIf = applyIf;
        this.side = side;
        this.transformerClasses = transformers;
    }

    private boolean shouldBeLoaded() {
        return this.applyIf.get() != false && this.shouldLoadSide();
    }

    private boolean shouldLoadSide() {
        return this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    public static String[] getTransformers() {
        ArrayList<String> list = new ArrayList<String>();
        for (AsmTransformers transformer : AsmTransformers.values()) {
            if (transformer.shouldBeLoaded()) {
                AngelicaTweaker.LOGGER.info("Loading transformer {}", (Object[])transformer.transformerClasses);
                list.addAll(Arrays.asList(transformer.transformerClasses));
                continue;
            }
            AngelicaTweaker.LOGGER.info("Not loading transformer {}", (Object[])transformer.transformerClasses);
        }
        return list.toArray(new String[0]);
    }

    private static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }
}

