/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.option.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuContainer;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuElement;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuOptionElement;

public class OptionMenuElementScreen {
    public final List<OptionMenuElement> elements = new ArrayList<OptionMenuElement>();
    private final Optional<Integer> columnCount;

    public OptionMenuElementScreen(OptionMenuContainer container, ShaderProperties shaderProperties, ShaderPackOptions shaderPackOptions, List<String> elementStrings, Optional<Integer> columnCount) {
        this.columnCount = columnCount;
        for (String elementString : elementStrings) {
            if ("*".equals(elementString)) {
                container.queueForUnusedOptionDump(this.elements.size(), this.elements);
                continue;
            }
            try {
                OptionMenuElement element = OptionMenuElement.create(elementString, container, shaderProperties, shaderPackOptions);
                if (element == null) continue;
                this.elements.add(element);
                if (!(element instanceof OptionMenuOptionElement)) continue;
                container.notifyOptionAdded(elementString, (OptionMenuOptionElement)element);
            }
            catch (IllegalArgumentException error) {
                Iris.logger.warn(error.getMessage());
                this.elements.add(OptionMenuElement.EMPTY);
            }
        }
    }

    public int getColumnCount() {
        return this.columnCount.orElse(this.elements.size() > 18 ? 3 : 2);
    }
}

