/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.models;

import com.gtnewhorizons.angelica.compat.mojang.Axis;
import com.gtnewhorizons.angelica.models.NdQuadBuilder;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Vector3f;

public abstract class GeometryHelper {
    public static boolean isQuadParallelToFace(ForgeDirection face, NdQuadBuilder quad) {
        int i = Axis.fromDirection(face).ordinal();
        float val = quad.posByIndex(0, i);
        return MathUtil.fuzzy_eq(val, quad.posByIndex(1, i)) && MathUtil.fuzzy_eq(val, quad.posByIndex(2, i)) && MathUtil.fuzzy_eq(val, quad.posByIndex(3, i));
    }

    public static ForgeDirection lightFace(NdQuadBuilder quad) {
        ForgeDirection forgeDirection;
        Vector3f normal = quad.faceNormal;
        switch (GeometryHelper.longestAxis(normal)) {
            case X: {
                if (normal.x() > 0.0f) {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case Y: {
                if (normal.y() > 0.0f) {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case Z: {
                if (normal.z() > 0.0f) {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            default: {
                forgeDirection = ForgeDirection.UP;
            }
        }
        return forgeDirection;
    }

    public static Axis longestAxis(Vector3f vec) {
        return GeometryHelper.longestAxis(vec.x(), vec.y(), vec.z());
    }

    public static Axis longestAxis(float normalX, float normalY, float normalZ) {
        Axis result = Axis.Y;
        float longest = Math.abs(normalY);
        float a = Math.abs(normalX);
        if (a > longest) {
            result = Axis.X;
            longest = a;
        }
        return Math.abs(normalZ) > longest ? Axis.Z : result;
    }
}

