/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.models.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import com.gtnewhorizons.angelica.models.json.JsonModel;
import com.gtnewhorizons.angelica.models.json.Variant;
import com.gtnewhorizons.angelica.utils.Callback;
import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class Loader {
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(JsonModel.class, (Object)new JsonModel.Deserializer()).create();
    private static final List<ResourceLocation> unloadedModels = new ObjectArrayList();
    private static final Map<ResourceLocation, JsonModel> loadedModels = new Object2ObjectOpenHashMap();
    private static final Map<Variant, JsonModel> modelsToBake = new Object2ObjectOpenHashMap();
    private static final List<Callback> postBakeCallbacks = new ObjectArrayList();

    public static void registerModels(Callback loader, Variant ... variants) {
        Loader.registerModels(loader, Arrays.asList(variants));
    }

    public static void registerModels(Callback loader, Collection<Variant> variants) {
        for (Variant v : variants) {
            unloadedModels.add(v.getModel());
            modelsToBake.put(v, null);
        }
        postBakeCallbacks.add(loader);
    }

    public static void loadModels() {
        for (ResourceLocation l : unloadedModels) {
            if (l == null || loadedModels.containsKey(l)) continue;
            JsonModel model = Loader.loadJson("/assets/" + l.func_110624_b() + "/models/" + l.func_110623_a() + ".json", JsonModel.class);
            unloadedModels.addAll(model.getParents());
            loadedModels.put(l, model);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T loadJson(String path, Class<T> clazz) {
        try (InputStream is = Loader.class.getResourceAsStream(path);){
            Object object = GSON.fromJson((Reader)new InputStreamReader(is), clazz);
            return (T)object;
        }
        catch (IOException | NullPointerException e) {
            AngelicaTweaker.LOGGER.fatal("Could not find " + path);
            throw new RuntimeException(e);
        }
    }

    public static void bakeModels() {
        for (Map.Entry<Variant, JsonModel> l : modelsToBake.entrySet()) {
            JsonModel dough = new JsonModel(loadedModels.get(l.getKey().getModel()));
            dough.resolveParents((Function<ResourceLocation, JsonModel>)((Function)loadedModels::get));
            dough.bake(l.getKey());
            l.setValue(dough);
        }
        for (Callback c : postBakeCallbacks) {
            c.run();
        }
    }

    public static JsonModel getModel(Variant loc) {
        return modelsToBake.get(loc);
    }
}

