/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.lwjgl;

import com.gtnewhorizons.angelica.compat.lwjgl.Pointer;
import it.unimi.dsi.fastutil.longs.LongPredicate;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import sun.misc.Unsafe;

public class CompatMemoryUtil {
    public static final long NULL = 0L;
    static final Unsafe UNSAFE;
    private static final Class<? extends ByteBuffer> BUFFER_BYTE;
    private static final Class<? extends IntBuffer> BUFFER_INT;
    private static final Class<? extends FloatBuffer> BUFFER_FLOAT;
    private static final long MARK;
    private static final long POSITION;
    private static final long LIMIT;
    private static final long CAPACITY;
    private static final long ADDRESS;
    private static final int FILL_PATTERN_32;
    private static final long FILL_PATTERN_64;
    private static final int MAGIC_CAPACITY = 219540062;
    private static final int MAGIC_POSITION = 16435934;

    public static ByteBuffer memReallocDirect(ByteBuffer old, int capacity) {
        ByteBuffer newBuf = BufferUtils.createByteBuffer((int)capacity);
        int oldPos = old.position();
        old.rewind();
        newBuf.put(old);
        newBuf.position(Math.min(capacity, oldPos));
        return newBuf;
    }

    public static IntBuffer memReallocDirect(IntBuffer old, int capacity) {
        IntBuffer newBuf = BufferUtils.createIntBuffer((int)capacity);
        int oldPos = old.position();
        old.rewind();
        newBuf.put(old);
        newBuf.position(Math.min(capacity, oldPos));
        return newBuf;
    }

    public static FloatBuffer memReallocDirect(FloatBuffer old, int capacity) {
        FloatBuffer newBuf = BufferUtils.createFloatBuffer((int)capacity);
        int oldPos = old.position();
        old.rewind();
        newBuf.put(old);
        newBuf.position(Math.min(capacity, oldPos));
        return newBuf;
    }

    public static void memSet(long ptr, int value, long bytes) {
        int p = (int)ptr;
        if (Pointer.BITS64) {
            if ((p & 7) == 0) {
                CompatMemoryUtil.memSet64(ptr, value, (int)bytes & 0xFF);
                return;
            }
        } else if ((p & 3) == 0) {
            CompatMemoryUtil.memSet32(p, value, (int)bytes & 0xFF);
            return;
        }
    }

    private static void memSet64(long ptr, int value, int bytes) {
        int aligned = bytes & 0xFFFFFFF8;
        long valuel = (long)(value & 0xFF) * FILL_PATTERN_64;
        for (int i = 0; i < aligned; i += 8) {
            UNSAFE.putLong(null, ptr + (long)i, valuel);
        }
        byte valueb = (byte)(value & 0xFF);
        for (int i = aligned; i < bytes; ++i) {
            UNSAFE.putByte(null, ptr + (long)i, valueb);
        }
    }

    private static void memSet32(int ptr, int value, int bytes) {
        int aligned = bytes & 0xFFFFFFFC;
        int vi = (value & 0xFF) * FILL_PATTERN_32;
        for (int i = 0; i < aligned; i += 4) {
            UNSAFE.putInt(null, (long)(ptr + i) & 0xFFFFFFFFL, vi);
        }
        byte vb = (byte)(value & 0xFF);
        for (int i = aligned; i < bytes; ++i) {
            UNSAFE.putByte(null, (long)(ptr + i) & 0xFFFFFFFFL, vb);
        }
    }

    public static boolean memGetBoolean(long ptr) {
        return UNSAFE.getByte(null, ptr) != 0;
    }

    public static byte memGetByte(long ptr) {
        return UNSAFE.getByte(null, ptr);
    }

    public static short memGetShort(long ptr) {
        return UNSAFE.getShort(null, ptr);
    }

    public static int memGetInt(long ptr) {
        return UNSAFE.getInt(null, ptr);
    }

    public static long memGetLong(long ptr) {
        return UNSAFE.getLong(null, ptr);
    }

    public static float memGetFloat(long ptr) {
        return UNSAFE.getFloat(null, ptr);
    }

    public static double memGetDouble(long ptr) {
        return UNSAFE.getDouble(null, ptr);
    }

    public static void memPutByte(long ptr, byte value) {
        UNSAFE.putByte(null, ptr, value);
    }

    public static void memPutShort(long ptr, short value) {
        UNSAFE.putShort(null, ptr, value);
    }

    public static void memPutInt(long ptr, int value) {
        UNSAFE.putInt(null, ptr, value);
    }

    public static void memPutLong(long ptr, long value) {
        UNSAFE.putLong(null, ptr, value);
    }

    public static void memPutFloat(long ptr, float value) {
        UNSAFE.putFloat(null, ptr, value);
    }

    public static void memPutDouble(long ptr, double value) {
        UNSAFE.putDouble(null, ptr, value);
    }

    private static Unsafe getUnsafeInstance() {
        Field[] fields;
        for (Field field : fields = Unsafe.class.getDeclaredFields()) {
            int modifiers;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
            try {
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                break;
            }
        }
        throw new UnsupportedOperationException("LWJGL requires sun.misc.Unsafe to be available.");
    }

    private static long getFieldOffset(Class<?> containerType, Class<?> fieldType, String name) {
        for (Class<?> c = containerType; c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(fieldType) || Modifier.isStatic(field.getModifiers()) || field.isSynthetic()) continue;
                long offset = UNSAFE.objectFieldOffset(field);
                if (!field.getName().equals(name)) continue;
                return offset;
            }
        }
        throw new UnsupportedOperationException("Failed to find field offset in class.");
    }

    private static long getFieldOffset(Class<?> containerType, Class<?> fieldType, LongPredicate predicate) {
        for (Class<?> c = containerType; c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                long offset;
                if (!field.getType().isAssignableFrom(fieldType) || Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || !predicate.test(offset = UNSAFE.objectFieldOffset(field))) continue;
                return offset;
            }
        }
        throw new UnsupportedOperationException("Failed to find field offset in class.");
    }

    private static long getFieldOffsetInt(Object container, int value) {
        return CompatMemoryUtil.getFieldOffset(container.getClass(), Integer.TYPE, offset -> UNSAFE.getInt(container, offset) == value);
    }

    private static long getAddressOffset() {
        ByteBuffer bb = ByteBuffer.allocateDirect(0);
        return CompatMemoryUtil.getFieldOffset(bb.getClass(), Long.TYPE, "address");
    }

    private static long getMarkOffset() {
        ByteBuffer bb = ByteBuffer.allocateDirect(0);
        return CompatMemoryUtil.getFieldOffsetInt(bb, -1);
    }

    private static long getPositionOffset() {
        ByteBuffer bb = ByteBuffer.allocateDirect(219540062);
        bb.position(16435934);
        return CompatMemoryUtil.getFieldOffsetInt(bb, 16435934);
    }

    private static long getLimitOffset() {
        ByteBuffer bb = ByteBuffer.allocateDirect(219540062);
        bb.limit(16435934);
        return CompatMemoryUtil.getFieldOffsetInt(bb, 16435934);
    }

    private static long getCapacityOffset() {
        ByteBuffer bb = ByteBuffer.allocateDirect(219540062);
        bb.limit(0);
        return CompatMemoryUtil.getFieldOffsetInt(bb, 219540062);
    }

    static IntBuffer wrapBufferInt(long address, int capacity) {
        IntBuffer buffer;
        try {
            buffer = (IntBuffer)UNSAFE.allocateInstance(BUFFER_INT);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException(e);
        }
        UNSAFE.putLong(buffer, ADDRESS, address);
        UNSAFE.putInt(buffer, MARK, -1);
        UNSAFE.putInt(buffer, LIMIT, capacity);
        UNSAFE.putInt(buffer, CAPACITY, capacity);
        return buffer;
    }

    static FloatBuffer wrapBufferFloat(long address, int capacity) {
        FloatBuffer buffer;
        try {
            buffer = (FloatBuffer)UNSAFE.allocateInstance(BUFFER_FLOAT);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException(e);
        }
        UNSAFE.putLong(buffer, ADDRESS, address);
        UNSAFE.putInt(buffer, MARK, -1);
        UNSAFE.putInt(buffer, LIMIT, capacity);
        UNSAFE.putInt(buffer, CAPACITY, capacity);
        return buffer;
    }

    static {
        ByteBuffer bb = ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());
        BUFFER_BYTE = bb.getClass();
        BUFFER_INT = bb.asIntBuffer().getClass();
        BUFFER_FLOAT = bb.asFloatBuffer().getClass();
        UNSAFE = CompatMemoryUtil.getUnsafeInstance();
        MARK = CompatMemoryUtil.getMarkOffset();
        POSITION = CompatMemoryUtil.getPositionOffset();
        LIMIT = CompatMemoryUtil.getLimitOffset();
        CAPACITY = CompatMemoryUtil.getCapacityOffset();
        ADDRESS = CompatMemoryUtil.getAddressOffset();
        FILL_PATTERN_32 = Integer.divideUnsigned(-1, 255);
        FILL_PATTERN_64 = Long.divideUnsigned(-1L, 255L);
    }
}

