/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.hudcaching;

import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizons.angelica.compat.ModStatus;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import com.gtnewhorizons.angelica.mixins.interfaces.GuiIngameAccessor;
import com.gtnewhorizons.angelica.mixins.interfaces.GuiIngameForgeAccessor;
import com.gtnewhorizons.angelica.mixins.interfaces.RenderGameOverlayEventAccessor;
import com.kentington.thaumichorizons.common.ThaumicHorizons;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.dries007.holoInventory.client.Renderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import thaumcraft.common.Thaumcraft;
import xaero.common.core.XaeroMinimapCore;

public class HUDCaching {
    private static final Minecraft mc = Minecraft.func_71410_x();
    public static Framebuffer framebuffer;
    private static boolean dirty;
    private static long nextHudRefresh;
    public static boolean renderingCacheOverride;
    public static boolean renderVignetteCaptured;
    public static boolean renderHelmetCaptured;
    public static float renderPortalCapturedTicks;
    public static boolean renderCrosshairsCaptured;
    private static final RenderGameOverlayEvent fakeTextEvent;
    private static final RenderGameOverlayEvent fakePreEvent;
    public static final HUDCaching INSTANCE;

    private HUDCaching() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onJoinWorld(WorldEvent.Load event) {
        if (event.world.field_72995_K) {
            AngelicaTweaker.LOGGER.info("World loaded - Initializing HUDCaching");
            framebuffer = new Framebuffer(0, 0, true);
            framebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    public static void renderCachedHud(EntityRenderer renderer, GuiIngame ingame, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        if (ModStatus.isXaerosMinimapLoaded && ingame instanceof GuiIngameForge) {
            XaeroMinimapCore.beforeIngameGuiRender((float)partialTicks);
        }
        if (!OpenGlHelper.func_148822_b() || framebuffer == null) {
            ingame.func_73830_a(partialTicks, hasScreen, mouseX, mouseY);
            return;
        }
        if (System.currentTimeMillis() > nextHudRefresh) {
            dirty = true;
        }
        if (dirty) {
            dirty = false;
            nextHudRefresh = System.currentTimeMillis() + (long)(1000 / AngelicaConfig.hudCachingFPS);
            HUDCaching.resetFramebuffer(HUDCaching.mc.field_71443_c, HUDCaching.mc.field_71440_d);
            framebuffer.func_147610_a(false);
            renderingCacheOverride = true;
            ingame.func_73830_a(partialTicks, hasScreen, mouseX, mouseY);
            renderingCacheOverride = false;
            mc.func_147110_a().func_147610_a(false);
        } else {
            renderer.func_78478_c();
        }
        ScaledResolution resolution = new ScaledResolution(mc, HUDCaching.mc.field_71443_c, HUDCaching.mc.field_71440_d);
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        GLStateManager.enableBlend();
        GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GuiIngameAccessor gui = (GuiIngameAccessor)ingame;
        if (renderVignetteCaptured) {
            gui.callRenderVignette(HUDCaching.mc.field_71439_g.func_70013_c(partialTicks), width, height);
        } else {
            GLStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        }
        if (ingame instanceof GuiIngameForge) {
            GuiIngameForgeAccessor guiForge = (GuiIngameForgeAccessor)ingame;
            if (renderHelmetCaptured) {
                guiForge.callRenderHelmet(resolution, partialTicks, hasScreen, mouseX, mouseY);
                if (ModStatus.isHoloInventoryLoaded) {
                    Renderer.INSTANCE.angelicaOverride = false;
                    ((RenderGameOverlayEventAccessor)fakePreEvent).setPartialTicks(partialTicks);
                    Renderer.INSTANCE.renderEvent(fakePreEvent);
                }
            }
            if (renderPortalCapturedTicks > 0.0f) {
                guiForge.callRenderPortal(width, height, partialTicks);
            }
            if (renderCrosshairsCaptured) {
                guiForge.callRenderCrosshairs(width, height);
            }
            if (ModStatus.isThaumcraftLoaded || ModStatus.isThaumicHorizonsLoaded) {
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setPartialTicks(partialTicks);
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setResolution(resolution);
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setMouseX(mouseX);
                ((RenderGameOverlayEventAccessor)fakeTextEvent).setMouseY(mouseY);
                if (ModStatus.isThaumcraftLoaded) {
                    Thaumcraft.instance.renderEventHandler.renderOverlay(fakeTextEvent);
                }
                if (ModStatus.isThaumicHorizonsLoaded) {
                    ThaumicHorizons.instance.renderEventHandler.renderOverlay(fakeTextEvent);
                }
            }
        } else {
            if (renderHelmetCaptured) {
                gui.callRenderPumpkinBlur(width, height);
            }
            if (renderPortalCapturedTicks > 0.0f) {
                gui.callRenderPortal(renderPortalCapturedTicks, width, height);
            }
        }
        Tessellator tessellator = TessellatorManager.get();
        GLStateManager.enableBlend();
        GLStateManager.tryBlendFuncSeparate(1, 771, 1, 771);
        GLStateManager.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        framebuffer.func_147612_c();
        HUDCaching.drawTexturedRect(tessellator, (float)resolution.func_78327_c(), (float)resolution.func_78324_d());
        GLStateManager.tryBlendFuncSeparate(1, 771, 1, 0);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    public static void fixGLStateBeforeRenderingCache() {
        GLStateManager.glDepthMask(true);
        GLStateManager.enableDepthTest();
        GLStateManager.enableAlphaTest();
        GLStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GLStateManager.disableBlend();
    }

    private static void resetFramebuffer(int width, int height) {
        if (HUDCaching.framebuffer.field_147621_c != width || HUDCaching.framebuffer.field_147618_d != height) {
            framebuffer.func_147613_a(width, height);
            framebuffer.func_147607_a(9728);
        } else {
            framebuffer.func_147614_f();
        }
        OpenGlHelper.func_153171_g((int)36008, (int)HUDCaching.mc.func_147110_a().field_147616_f);
        OpenGlHelper.func_153171_g((int)36009, (int)HUDCaching.framebuffer.field_147616_f);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)width, (int)height, (int)1280, (int)9728);
    }

    private static void drawTexturedRect(Tessellator tessellator, float width, float height) {
        GLStateManager.enableTexture();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)height, 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)width, (double)height, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)width, 0.0, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 1.0);
        tessellator.func_78381_a();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
    }

    public static void disableHoloInventory() {
        if (ModStatus.isHoloInventoryLoaded) {
            Renderer.INSTANCE.angelicaOverride = true;
        }
    }

    static {
        dirty = true;
        fakeTextEvent = new RenderGameOverlayEvent.Text(new RenderGameOverlayEvent(0.0f, null, 0, 0), null, null);
        fakePreEvent = new RenderGameOverlayEvent.Pre(new RenderGameOverlayEvent(0.0f, null, 0, 0), RenderGameOverlayEvent.ElementType.HELMET);
        INSTANCE = new HUDCaching();
    }

    public static class HUDCachingHooks {
        public static boolean shouldReturnEarly() {
            return renderingCacheOverride;
        }
    }
}

