/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.batchedentityrendering.impl.ordering;

import com.gtnewhorizons.angelica.compat.toremove.RenderLayer;
import de.odysseus.ithaka.digraph.Digraph;
import de.odysseus.ithaka.digraph.Digraphs;
import de.odysseus.ithaka.digraph.MapDigraph;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSet;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSetPolicy;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSetProvider;
import de.odysseus.ithaka.digraph.util.fas.SimpleFeedbackArcSetProvider;
import java.util.ArrayList;
import java.util.EnumMap;
import net.coderbot.batchedentityrendering.impl.BlendingStateHolder;
import net.coderbot.batchedentityrendering.impl.TransparencyType;
import net.coderbot.batchedentityrendering.impl.WrappableRenderType;
import net.coderbot.batchedentityrendering.impl.ordering.RenderOrderManager;

public class GraphTranslucencyRenderOrderManager
implements RenderOrderManager {
    private final FeedbackArcSetProvider feedbackArcSetProvider = new SimpleFeedbackArcSetProvider();
    private final EnumMap<TransparencyType, Digraph<RenderLayer>> types = new EnumMap(TransparencyType.class);
    private boolean inGroup = false;
    private final EnumMap<TransparencyType, RenderLayer> currentTypes = new EnumMap(TransparencyType.class);

    public GraphTranslucencyRenderOrderManager() {
        for (TransparencyType type : TransparencyType.values()) {
            this.types.put(type, new MapDigraph());
        }
    }

    private static TransparencyType getTransparencyType(RenderLayer type) {
        while (type instanceof WrappableRenderType) {
            type = ((WrappableRenderType)((Object)type)).unwrap();
        }
        if (type instanceof BlendingStateHolder) {
            BlendingStateHolder blendingState = (BlendingStateHolder)((Object)type);
            return blendingState.getTransparencyType();
        }
        return TransparencyType.GENERAL_TRANSPARENT;
    }

    @Override
    public void begin(RenderLayer renderType) {
        TransparencyType transparencyType = GraphTranslucencyRenderOrderManager.getTransparencyType(renderType);
        Digraph<RenderLayer> graph = this.types.get((Object)transparencyType);
        graph.add(renderType);
        if (this.inGroup) {
            RenderLayer previous = this.currentTypes.put(transparencyType, renderType);
            if (previous == null) {
                return;
            }
            int weight = graph.get(previous, renderType).orElse(0);
            graph.put(previous, renderType, ++weight);
        }
    }

    @Override
    public void startGroup() {
        if (this.inGroup) {
            throw new IllegalStateException("Already in a group");
        }
        this.currentTypes.clear();
        this.inGroup = true;
    }

    @Override
    public boolean maybeStartGroup() {
        if (this.inGroup) {
            return false;
        }
        this.currentTypes.clear();
        this.inGroup = true;
        return true;
    }

    @Override
    public void endGroup() {
        if (!this.inGroup) {
            throw new IllegalStateException("Not in a group");
        }
        this.currentTypes.clear();
        this.inGroup = false;
    }

    @Override
    public void reset() {
        this.types.clear();
        for (TransparencyType type : TransparencyType.values()) {
            this.types.put(type, new MapDigraph());
        }
    }

    @Override
    public Iterable<RenderLayer> getRenderOrder() {
        int layerCount = 0;
        for (Digraph<RenderLayer> graph : this.types.values()) {
            layerCount += graph.getVertexCount();
        }
        ArrayList<RenderLayer> allLayers = new ArrayList<RenderLayer>(layerCount);
        for (Digraph<RenderLayer> graph : this.types.values()) {
            FeedbackArcSet<RenderLayer> arcSet = this.feedbackArcSetProvider.getFeedbackArcSet(graph, graph, FeedbackArcSetPolicy.MIN_WEIGHT);
            if (arcSet.getEdgeCount() > 0) {
                for (RenderLayer source : arcSet.vertices()) {
                    for (RenderLayer target : arcSet.targets(source)) {
                        graph.remove(source, target);
                    }
                }
            }
            allLayers.addAll(Digraphs.toposort(graph, false));
        }
        return allLayers;
    }
}

