/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.gui;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import java.io.IOException;
import java.util.ArrayList;
import jss.notfine.config.NotFineConfig;
import jss.notfine.core.Settings;
import jss.notfine.core.SettingsManager;
import jss.notfine.gui.options.control.NotFineControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.named.GraphicsMode;
import me.jellysquid.mods.sodium.client.gui.options.named.GraphicsQuality;
import me.jellysquid.mods.sodium.client.gui.options.named.LightingQuality;
import me.jellysquid.mods.sodium.client.gui.options.named.ParticleMode;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.MultidrawChunkRenderBackend;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.option.IrisVideoSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import org.lwjgl.opengl.Display;

public class NotFineGameOptionPages {
    private static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();

    public static OptionPage general() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(GraphicsMode.class, vanillaOpts).setName(I18n.func_135052_a((String)"options.graphics", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.graphics_quality.tooltip", (Object[])new Object[0])).setControl(option -> new CyclingControl<GraphicsMode>((Option<GraphicsMode>)option, GraphicsMode.class)).setBinding((opts, value) -> {
            opts.field_74347_j = value.isFancy();
            SettingsManager.graphicsUpdated();
        }, opts -> GraphicsMode.fromBoolean(opts.field_74347_j)).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.renderDistance", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.view_distance.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 2, (int)GameSettings.Options.RENDER_DISTANCE.func_148267_f(), 1, ControlValueFormatter.quantity("options.chunks"))).setBinding((options, value) -> {
            options.field_151451_c = value;
        }, options -> options.field_151451_c).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.vsync", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.v_sync.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74352_v = value;
            Display.setVSyncEnabled((boolean)opts.field_74352_v);
        }, opts -> opts.field_74352_v).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.fullscreen", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.fullscreen.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74353_u = value;
            Minecraft client = Minecraft.func_71410_x();
            if (client.func_71372_G() != opts.field_74353_u) {
                client.func_71352_k();
                opts.field_74353_u = client.func_71372_G();
            }
        }, opts -> opts.field_74353_u).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.framerateLimit", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.fps_limit.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 5, 260, 1, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.field_74350_i = value;
        }, opts -> opts.field_74350_i).build()).build());
        int maxGuiScale = Math.max(3, Math.min(Minecraft.func_71410_x().field_71443_c / 320, Minecraft.func_71410_x().field_71440_d / 240));
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.guiScale", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.gui_scale.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, maxGuiScale, 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.field_74335_Z = value;
        }, opts -> opts.field_74335_Z).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.viewBobbing", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.view_bobbing.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74336_f = value;
        }, opts -> opts.field_74336_f).build()).add(OptionImpl.createBuilder(LightingQuality.class, vanillaOpts).setName(I18n.func_135052_a((String)"options.ao", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.smooth_lighting.tooltip", (Object[])new Object[0])).setControl(option -> new CyclingControl<LightingQuality>((Option<LightingQuality>)option, LightingQuality.class)).setBinding((opts, value) -> {
            opts.field_74348_k = value.getVanilla();
        }, opts -> LightingQuality.fromOrdinal(opts.field_74348_k)).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.gamma", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.brightness.tooltip", (Object[])new Object[0])).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> {
            opts.field_74333_Y = (float)value.intValue() * 0.01f;
        }, opts -> (int)(opts.field_74333_Y / 0.01f)).build()).add(Settings.MODE_LIGHT_FLICKER.option).add(Settings.DYNAMIC_FOV.option).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.mipmapLevels", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.mipmap_levels.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> {
            opts.field_151442_I = value;
        }, opts -> opts.field_151442_I).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.anisotropicFiltering", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.anisotropic_filtering.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, NotFineControlValueFormatter.powerOfTwo())).setBinding((opts, value) -> {
            opts.field_151443_J = value == 0 ? 1 : (int)Math.pow(2.0, value.intValue());
        }, opts -> opts.field_151443_J == 1 ? 0 : (int)(Math.log(opts.field_151443_J) / Math.log(2.0))).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        if (AngelicaConfig.enableIris) {
            OptionImpl<GameSettings, Integer> maxShadowDistanceSlider = OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.iris.shadowDistance", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"options.iris.shadowDistance.sodium_tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 32, 1, ControlValueFormatter.quantity("options.chunks"))).setBinding((options, value) -> {
                IrisVideoSettings.shadowDistance = value;
                try {
                    Iris.getIrisConfig().save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }, options -> IrisVideoSettings.getOverriddenShadowDistance(IrisVideoSettings.shadowDistance)).setImpact(OptionImpact.HIGH).setEnabled(true).build();
            maxShadowDistanceSlider.iris$dynamicallyEnable(IrisVideoSettings::isShadowDistanceSliderEnabled);
            groups.add(OptionGroup.createBuilder().add(maxShadowDistanceSlider).build());
        }
        return new OptionPage(I18n.func_135052_a((String)"options.video", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage detail() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(Settings.MODE_LEAVES.option).add(OptionImpl.createBuilder(GraphicsQuality.class, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.grass_quality.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.grass_quality.tooltip", (Object[])new Object[0])).setControl(option -> new CyclingControl<GraphicsQuality>((Option<GraphicsQuality>)option, GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.grassQuality = value;
        }, opts -> opts.quality.grassQuality).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(Settings.MODE_WATER.option).add(Settings.DOWNFALL_DISTANCE.option).add(Settings.MODE_VIGNETTE.option).add(Settings.DYNAMIC_LIGHTS.option, AngelicaConfig.enableDynamicLights).add(Settings.DYNAMIC_LIGHTS_SHADER_FORCE.option, AngelicaConfig.enableDynamicLights).add(Settings.MODE_SHADOWS.option).add(Settings.VOID_FOG.option).add(Settings.MODE_DROPPED_ITEMS.option).add(Settings.MODE_GLINT_WORLD.option).add(Settings.MODE_GLINT_INV.option).build());
        return new OptionPage(I18n.func_135052_a((String)"options.button.detail", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage atmosphere() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(Settings.MODE_SKY.option).add(Settings.MODE_SUN_MOON.option).add(Settings.MODE_CLOUDS.option).add(Settings.RENDER_DISTANCE_CLOUDS.option).add(Settings.CLOUD_HEIGHT.option).add(Settings.CLOUD_SCALE.option).add(Settings.MODE_CLOUD_TRANSLUCENCY.option).add(Settings.MODE_STARS.option).add(Settings.TOTAL_STARS.option).add(Settings.FOG_NEAR_DISTANCE.option).build());
        return new OptionPage(I18n.func_135052_a((String)"options.button.sky", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage particles() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(ParticleMode.class, vanillaOpts).setName(I18n.func_135052_a((String)"options.particles", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.particle_quality.tooltip", (Object[])new Object[0])).setControl(opt -> new CyclingControl<ParticleMode>((Option<ParticleMode>)opt, ParticleMode.class)).setBinding((opts, value) -> {
            opts.field_74362_aa = value.ordinal();
        }, opts -> ParticleMode.fromOrdinal(opts.field_74362_aa)).setImpact(OptionImpact.LOW).build()).add(Settings.PARTICLES_VOID.option).add(Settings.PARTICLES_ENC_TABLE.option).build());
        return new OptionPage(I18n.func_135052_a((String)"options.button.particle", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage other() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.advancedOpengl", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.advanced_opengl.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74349_h = value;
        }, opts -> opts.field_74349_h).setImpact(OptionImpact.VARIES).setEnabled(NotFineConfig.allowAdvancedOpenGL).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.fboEnable", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.fbo.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_151448_g = value;
        }, opts -> opts.field_151448_g).setEnabled(NotFineConfig.allowToggleFBO).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.anaglyph", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.anaglyph.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74337_g = value;
        }, opts -> opts.field_74337_g).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).setEnabled(NotFineConfig.allowToggle3DAnaglyph).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.showCape", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.show_cape.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_82880_z = value;
        }, opts -> opts.field_82880_z).build()).add(Settings.MODE_GUI_BACKGROUND.option).build());
        groups.add(OptionGroup.createBuilder().add(Settings.GUI_BACKGROUND.option).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_chunk_multidraw.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_chunk_multidraw.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useChunkMultidraw = value;
        }, opts -> opts.advanced.useChunkMultidraw).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).setImpact(OptionImpact.EXTREME).setEnabled(MultidrawChunkRenderBackend.isSupported(NotFineGameOptionPages.sodiumOpts.getData().advanced.ignoreDriverBlacklist)).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_vertex_objects.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_vertex_objects.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useVertexArrayObjects = value;
        }, opts -> opts.advanced.useVertexArrayObjects).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_block_face_culling.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_block_face_culling.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useBlockFaceCulling = value;
        }, opts -> opts.advanced.useBlockFaceCulling).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_compact_vertex_format.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_compact_vertex_format.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useCompactVertexFormat = value;
        }, opts -> opts.advanced.useCompactVertexFormat).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_fog_occlusion.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_fog_occlusion.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useFogOcclusion = value;
        }, opts -> opts.advanced.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.translucency_sorting.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.translucency_sorting.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.translucencySorting = value;
        }, opts -> opts.advanced.translucencySorting).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_entity_culling.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_entity_culling.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useEntityCulling = value;
        }, opts -> opts.advanced.useEntityCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_particle_culling.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_particle_culling.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useParticleCulling = value;
        }, opts -> opts.advanced.useParticleCulling).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.animate_only_visible_textures.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.animate_only_visible_textures.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.animateOnlyVisibleTextures = value;
        }, opts -> opts.advanced.animateOnlyVisibleTextures).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.allow_direct_memory_access.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.allow_direct_memory_access.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.advanced.allowDirectMemoryAccess = value;
        }, opts -> opts.advanced.allowDirectMemoryAccess).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.ignore_driver_blacklist.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.ignore_driver_blacklist.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.ignoreDriverBlacklist = value;
        }, opts -> opts.advanced.ignoreDriverBlacklist).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.chunk_update_threads.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.chunk_update_threads.tooltip", (Object[])new Object[0])).setControl(o -> new SliderControl((Option<Integer>)o, 0, Runtime.getRuntime().availableProcessors(), 1, ControlValueFormatter.quantityOrDisabled("sodium.options.threads.value", "sodium.options.default"))).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.chunkBuilderThreads = value;
        }, opts -> opts.performance.chunkBuilderThreads).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.always_defer_chunk_updates.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.always_defer_chunk_updates.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.alwaysDeferChunkUpdates = value;
        }, opts -> opts.performance.alwaysDeferChunkUpdates).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_no_error_context.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_no_error_context.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.LOW).setBinding((opts, value) -> {
            opts.performance.useNoErrorGLContext = value;
        }, opts -> opts.performance.useNoErrorGLContext).setFlags(OptionFlag.REQUIRES_GAME_RESTART).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName(I18n.func_135052_a((String)"sodium.options.use_gl_state_cache.name", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.use_gl_state_cache.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.EXTREME).setBinding((opts, value) -> {
            GLStateManager.BYPASS_CACHE = value == false;
        }, opts -> !GLStateManager.BYPASS_CACHE).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        return new OptionPage(I18n.func_135052_a((String)"options.button.other", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }
}

