/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import java.util.Objects;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.minecraft.client.Minecraft;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public class ClearPass {
    private final Vector4f color;
    private final IntSupplier viewportX;
    private final IntSupplier viewportY;
    private final GlFramebuffer framebuffer;
    private final int clearFlags;

    public ClearPass(Vector4f color, IntSupplier viewportX, IntSupplier viewportY, GlFramebuffer framebuffer, int clearFlags) {
        this.color = color;
        this.viewportX = viewportX;
        this.viewportY = viewportY;
        this.framebuffer = framebuffer;
        this.clearFlags = clearFlags;
    }

    public void execute(Vector4f defaultClearColor) {
        GL11.glViewport((int)0, (int)0, (int)this.viewportX.getAsInt(), (int)this.viewportY.getAsInt());
        this.framebuffer.bind();
        Vector4f color = Objects.requireNonNull(defaultClearColor);
        if (this.color != null) {
            color = this.color;
        }
        GL11.glClearColor((float)color.x, (float)color.y, (float)color.z, (float)color.w);
        GL11.glClear((int)this.clearFlags);
        if (Minecraft.field_142025_a) {
            GL11.glGetError();
        }
    }

    public GlFramebuffer getFramebuffer() {
        return this.framebuffer;
    }
}

