/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.properties.ModelQuadFacing;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.jellysquid.mods.sodium.client.gl.buffer.VertexData;
import me.jellysquid.mods.sodium.client.gl.util.BufferSlice;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBufferSorter;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheLocal;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import org.joml.Vector3d;
import org.lwjgl.BufferUtils;

public class ChunkRenderTranslucencySortTask<T extends ChunkGraphicsState>
extends ChunkRenderBuildTask<T> {
    private static final BlockRenderPass[] TRANSLUCENT_PASSES = (BlockRenderPass[])Arrays.stream(BlockRenderPass.VALUES).filter(BlockRenderPass::isTranslucent).toArray(BlockRenderPass[]::new);
    private static final BlockRenderPass[] NO_PASSES = new BlockRenderPass[0];
    private final ChunkRenderContainer<T> render;
    private final BlockPos offset;
    private final Vector3d camera;

    public ChunkRenderTranslucencySortTask(ChunkRenderContainer<T> render, BlockPos offset, Vector3d camera) {
        this.render = render;
        this.offset = offset;
        this.camera = camera;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkBuildResult<T> performBuild(ChunkRenderCacheLocal cache, ChunkBuildBuffers buffers, CancellationSource cancellationSource) {
        Map<BlockRenderPass, ChunkMeshData> replacementMeshes;
        ChunkRenderData data = this.render.getData();
        if (!data.isEmpty()) {
            replacementMeshes = new HashMap();
            for (BlockRenderPass pass : TRANSLUCENT_PASSES) {
                ChunkMeshData translucentMesh;
                ByteBuffer translucencyData;
                T state = this.render.getGraphicsState(pass);
                if (state == null || (translucencyData = ((ChunkGraphicsState)state).getTranslucencyData()) == null || (translucentMesh = data.getMesh(pass)) == null) continue;
                ByteBuffer sortedData = BufferUtils.createByteBuffer((int)translucencyData.capacity());
                ByteBuffer byteBuffer = translucencyData;
                synchronized (byteBuffer) {
                    sortedData.put(translucencyData);
                    translucencyData.position(0);
                    translucencyData.limit(translucencyData.capacity());
                }
                sortedData.flip();
                ChunkBufferSorter.sortStandardFormat(buffers.getVertexType(), sortedData, sortedData.capacity(), (float)this.camera.x - (float)this.offset.getX(), (float)this.camera.y - (float)this.offset.getY(), (float)this.camera.z - (float)this.offset.getZ());
                ChunkMeshData newMesh = new ChunkMeshData();
                newMesh.setVertexData(new VertexData(sortedData, buffers.getVertexType().getCustomVertexFormat()));
                for (Map.Entry<ModelQuadFacing, BufferSlice> entry : translucentMesh.getSlices()) {
                    newMesh.setModelSlice(entry.getKey(), entry.getValue());
                }
                replacementMeshes.put(pass, newMesh);
            }
        } else {
            replacementMeshes = Collections.emptyMap();
        }
        ChunkBuildResult<T> result = new ChunkBuildResult<T>(this.render, data.copyAndReplaceMesh(replacementMeshes));
        result.passesToUpload = replacementMeshes.keySet().toArray(NO_PASSES);
        return result;
    }

    @Override
    public void releaseResources() {
    }

    public String toString() {
        return "ChunkRenderTranslucencySortTask{offset=" + this.offset + ", camera=" + this.camera + '}';
    }
}

