/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gbuffer_overrides.matching;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gbuffer_overrides.matching.RenderCondition;

public class ProgramTable<T> {
    private final List<T> table = new ArrayList<T>();

    public ProgramTable(BiFunction<RenderCondition, InputAvailability, T> constructor) {
        for (RenderCondition condition : RenderCondition.values()) {
            for (int packedAvailability = 0; packedAvailability < 8; ++packedAvailability) {
                InputAvailability availability = InputAvailability.unpack(packedAvailability);
                this.table.add(constructor.apply(condition, availability));
            }
        }
    }

    public T match(RenderCondition condition, InputAvailability availability) {
        int index = condition.ordinal() * 8 + availability.pack();
        return this.table.get(index);
    }

    public void forEach(Consumer<T> consumer) {
        this.table.forEach(consumer);
    }
}

