/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import org.lwjgl.opengl.GL20;

public final class Program
extends GlResource {
    private final ProgramUniforms uniforms;
    private final ProgramSamplers samplers;
    private final ProgramImages images;

    Program(int program, ProgramUniforms uniforms, ProgramSamplers samplers, ProgramImages images) {
        super(program);
        this.uniforms = uniforms;
        this.samplers = samplers;
        this.images = images;
    }

    public void use() {
        GL20.glUseProgram((int)this.getGlId());
        this.uniforms.update();
        this.samplers.update();
        this.images.update();
    }

    public static void unbind() {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        GL20.glUseProgram((int)0);
    }

    @Override
    public void destroyInternal() {
        GL20.glDeleteProgram((int)this.getGlId());
    }

    @Deprecated
    public int getProgramId() {
        return this.getGlId();
    }

    public int getActiveImages() {
        return this.images.getActiveImages();
    }
}

