/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.util.function.Supplier;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.uniform.Uniform;
import org.joml.Vector3i;

public class Vector3IntegerJomlUniform
extends Uniform {
    private Vector3i cachedValue = null;
    private final Supplier<Vector3i> value;

    Vector3IntegerJomlUniform(int location, Supplier<Vector3i> value) {
        this(location, value, null);
    }

    Vector3IntegerJomlUniform(int location, Supplier<Vector3i> value, ValueUpdateNotifier notifier) {
        super(location, notifier);
        this.value = value;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        Vector3i newValue = this.value.get();
        if (this.cachedValue == null || !newValue.equals((Object)this.cachedValue)) {
            this.cachedValue = newValue;
            RenderSystem.uniform3i(this.location, newValue.x, newValue.y, newValue.z);
        }
    }
}

