/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.NEIHelpers;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEIWorldCraftingHandler
implements ICraftingHandler,
IUsageHandler {
    private final Map<IItemDefinition, String> details = new HashMap<IItemDefinition, String>();
    private final List<IItemDefinition> offsets = new LinkedList<IItemDefinition>();
    private final List<PositionedStack> outputs = new LinkedList<PositionedStack>();
    private ItemStack target;

    public String getRecipeName() {
        return GuiText.InWorldCrafting.getLocal();
    }

    public int numRecipes() {
        return this.offsets.size();
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawForeground(int recipe) {
        if (this.outputs.size() > recipe) {
            String details = this.details.get(this.offsets.get(recipe));
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            fr.func_78279_b(details, 10, 25, 150, 0);
        }
    }

    public List<PositionedStack> getIngredientStacks(int recipeIndex) {
        return new ArrayList<PositionedStack>();
    }

    public List<PositionedStack> getOtherStacks(int recipeIndex) {
        return new ArrayList<PositionedStack>();
    }

    public PositionedStack getResultStack(int recipe) {
        return this.outputs.get(recipe);
    }

    public void onUpdate() {
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currentToolTip, int recipe) {
        return currentToolTip;
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currentToolTip, int recipe) {
        return currentToolTip;
    }

    public boolean keyTyped(GuiRecipe<?> gui, char keyChar, int keyCode, int recipe) {
        return false;
    }

    public boolean mouseClicked(GuiRecipe<?> gui, int button, int recipe) {
        return false;
    }

    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        return this;
    }

    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        NEIWorldCraftingHandler g = this.newInstance();
        if (results.length > 0 && results[0] instanceof ItemStack) {
            g.target = (ItemStack)results[0];
            g.addRecipes();
            return g;
        }
        return this;
    }

    private NEIWorldCraftingHandler newInstance() {
        try {
            return (NEIWorldCraftingHandler)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addRecipes() {
        IDefinitions definitions = AEApi.instance().definitions();
        IMaterials materials = definitions.materials();
        String message = AEConfig.instance.isFeatureEnabled(AEFeature.CertusQuartzWorldGen) ? GuiText.ChargedQuartz.getLocal() + "\n\n" + GuiText.ChargedQuartzFind.getLocal() : GuiText.ChargedQuartzFind.getLocal();
        this.addRecipe(materials.certusQuartzCrystalCharged(), message);
        if (AEConfig.instance.isFeatureEnabled(AEFeature.MeteoriteWorldGen)) {
            this.addRecipe(materials.logicProcessorPress(), GuiText.inWorldCraftingPresses.getLocal());
            this.addRecipe(materials.calcProcessorPress(), GuiText.inWorldCraftingPresses.getLocal());
            this.addRecipe(materials.engProcessorPress(), GuiText.inWorldCraftingPresses.getLocal());
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.InWorldFluix)) {
            this.addRecipe(materials.fluixCrystal(), GuiText.inWorldFluix.getLocal());
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.InWorldSingularity)) {
            this.addRecipe(materials.qESingularity(), GuiText.inWorldSingularity.getLocal());
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.InWorldPurification)) {
            this.addRecipe(materials.purifiedCertusQuartzCrystal(), GuiText.inWorldPurificationCertus.getLocal());
            this.addRecipe(materials.purifiedNetherQuartzCrystal(), GuiText.inWorldPurificationNether.getLocal());
            this.addRecipe(materials.purifiedFluixCrystal(), GuiText.inWorldPurificationFluix.getLocal());
        }
    }

    private void addRecipe(IItemDefinition def, String msg) {
        for (ItemStack definitionStack : def.maybeStack(1).asSet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)definitionStack, (ItemStack)this.target)) continue;
            this.offsets.add(def);
            this.outputs.add(new PositionedStack((Object)definitionStack, 75, 4));
            this.details.put(def, msg);
        }
    }
}

