/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.WorldCoord;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.me.ClientDCInternalInv;
import appeng.client.me.SlotDisconnected;
import appeng.client.render.BlockPosHighlighter;
import appeng.container.implementations.ContainerInterfaceTerminal;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.parts.reporting.PartInterfaceTerminal;
import appeng.util.Platform;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiInterfaceTerminal
extends AEBaseGui {
    private static final int LINES_ON_PAGE = 6;
    private static final int offsetX = 21;
    private final HashMap<Long, ClientDCInternalInv> byId = new HashMap();
    private final HashMultimap<String, ClientDCInternalInv> byName = HashMultimap.create();
    private final HashMap<ClientDCInternalInv, DimensionalCoord> blockPosHashMap = new HashMap();
    private final HashMap<GuiButton, ClientDCInternalInv> guiButtonHashMap = new HashMap();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Set<Object> matchedStacks = new HashSet<Object>();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private MEGuiTextField searchFieldOutputs;
    private MEGuiTextField searchFieldInputs;
    private GuiButton guiButtonHideFull;
    private GuiButton guiButtonAssemblersOnly;
    private boolean refreshList = false;
    private boolean onlyInterfacesWithFreeSlots = false;
    private boolean onlyMolecularAssemblers = false;
    private static final String MOLECULAR_ASSEMBLER = "molecular assembler";

    public GuiInterfaceTerminal(InventoryPlayer inventoryPlayer, PartInterfaceTerminal te) {
        super(new ContainerInterfaceTerminal(inventoryPlayer, te));
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.field_146999_f = 208;
        this.field_147000_g = 255;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.getScrollBar().setLeft(189);
        this.getScrollBar().setHeight(106);
        this.getScrollBar().setTop(51);
        this.searchFieldInputs = new MEGuiTextField(this.field_146289_q, this.field_147003_i + Math.max(32, 21), this.field_147009_r + 25, 65, 12);
        this.searchFieldInputs.func_146185_a(false);
        this.searchFieldInputs.func_146203_f(25);
        this.searchFieldInputs.func_146193_g(0xFFFFFF);
        this.searchFieldInputs.func_146189_e(true);
        this.searchFieldInputs.func_146195_b(false);
        this.searchFieldOutputs = new MEGuiTextField(this.field_146289_q, this.field_147003_i + Math.max(32, 21), this.field_147009_r + 38, 65, 12);
        this.searchFieldOutputs.func_146185_a(false);
        this.searchFieldOutputs.func_146203_f(25);
        this.searchFieldOutputs.func_146193_g(0xFFFFFF);
        this.searchFieldOutputs.func_146189_e(true);
        this.searchFieldOutputs.func_146195_b(true);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146292_n.clear();
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.InterfaceTerminal.getLocal()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 21 + 2, this.field_147000_g - 96 + 3, 0x404040);
        int ex = this.getScrollBar().getCurrentScroll();
        this.guiButtonAssemblersOnly = new GuiImgButton(this.field_147003_i + 123, this.field_147009_r + 25, Settings.ACTIONS, this.onlyMolecularAssemblers ? ActionItems.MOLECULAR_ASSEMBLEERS_ON : ActionItems.MOLECULAR_ASSEMBLEERS_OFF);
        this.field_146292_n.add(this.guiButtonAssemblersOnly);
        this.guiButtonHideFull = new GuiImgButton(this.field_147003_i + 141, this.field_147009_r + 25, Settings.ACTIONS, this.onlyInterfacesWithFreeSlots ? ActionItems.TOGGLE_SHOW_FULL_INTERFACES_OFF : ActionItems.TOGGLE_SHOW_FULL_INTERFACES_ON);
        this.field_146292_n.add(this.guiButtonHideFull);
        this.field_147002_h.field_75151_b.removeIf(slot -> slot instanceof SlotDisconnected);
        int offset = 51;
        for (int x = 0; x < 6 && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                for (int z = 0; z < inv.getInventory().func_70302_i_(); ++z) {
                    this.field_147002_h.field_75151_b.add(new SlotDisconnected(inv, z, z * 18 + 22, 1 + offset));
                    if (!this.matchedStacks.contains(inv.getInventory().func_70301_a(z))) continue;
                    GuiInterfaceTerminal.func_73734_a((int)(z * 18 + 22), (int)(1 + offset), (int)(z * 18 + 22 + 16), (int)(1 + offset + 16), (int)704708352);
                }
                GuiImgButton guiButton = new GuiImgButton(this.field_147003_i + 4, this.field_147009_r + offset + 1, Settings.ACTIONS, ActionItems.HIGHLIGHT_INTERFACE);
                this.guiButtonHashMap.put(guiButton, inv);
                this.field_146292_n.add(guiButton);
            } else if (lineObj instanceof String) {
                String name = (String)lineObj;
                int rows = this.byName.get((Object)name).size();
                if (rows > 1) {
                    name = name + " (" + rows + ')';
                }
                while (name.length() > 2 && this.field_146289_q.func_78256_a(name) > 155) {
                    name = name.substring(0, name.length() - 1);
                }
                this.field_146289_q.func_78276_b(name, 21 + 2, 6 + offset, 0x404040);
            }
            offset += 18;
        }
        if (this.searchFieldInputs.isMouseIn(mouseX, mouseY)) {
            this.drawTooltip(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - offsetX, mouseY - this.field_147009_r, 0, ButtonToolTips.SearchFieldInputs.getLocal());
        } else if (this.searchFieldOutputs.isMouseIn(mouseX, mouseY)) {
            this.drawTooltip(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - offsetX, mouseY - this.field_147009_r, 0, ButtonToolTips.SearchFieldOutputs.getLocal());
        }
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        this.searchFieldInputs.func_146192_a(xCoord, yCoord, btn);
        if (btn == 1 && this.searchFieldInputs.isMouseIn(xCoord, yCoord)) {
            this.searchFieldInputs.func_146180_a("");
            this.refreshList();
        }
        this.searchFieldOutputs.func_146192_a(xCoord, yCoord, btn);
        if (btn == 1 && this.searchFieldOutputs.isMouseIn(xCoord, yCoord)) {
            this.searchFieldOutputs.func_146180_a("");
            this.refreshList();
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_146284_a(GuiButton btn) {
        if (this.guiButtonHashMap.containsKey(btn)) {
            DimensionalCoord blockPos = this.blockPosHashMap.get(this.guiButtonHashMap.get(btn));
            WorldCoord blockPos2 = new WorldCoord((int)this.field_146297_k.field_71439_g.field_70165_t, (int)this.field_146297_k.field_71439_g.field_70163_u, (int)this.field_146297_k.field_71439_g.field_70161_v);
            if (this.field_146297_k.field_71441_e.field_73011_w.field_76574_g != blockPos.getDimension()) {
                this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation(PlayerMessages.InterfaceInOtherDim.getName(), new Object[]{blockPos.getDimension()}));
            } else {
                BlockPosHighlighter.highlightBlock(blockPos, System.currentTimeMillis() + 500L * WorldCoord.getTaxicabDistance(blockPos, blockPos2));
                this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation(PlayerMessages.InterfaceHighlighted.getName(), new Object[]{blockPos.x, blockPos.y, blockPos.z}));
            }
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (btn == this.guiButtonHideFull) {
            this.onlyInterfacesWithFreeSlots = !this.onlyInterfacesWithFreeSlots;
            this.refreshList();
        }
        if (btn == this.guiButtonAssemblersOnly) {
            this.onlyMolecularAssemblers = !this.onlyMolecularAssemblers;
            this.refreshList();
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/newinterfaceterminal.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        int offset = 51;
        int ex = this.getScrollBar().getCurrentScroll();
        for (int x = 0; x < 6 && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int width = inv.getInventory().func_70302_i_() * 18;
                this.func_73729_b(offsetX + 20, offsetY + offset, 20, 173, width, 18);
            }
            offset += 18;
        }
        if (this.searchFieldInputs != null) {
            this.searchFieldInputs.func_146194_f();
        }
        if (this.searchFieldOutputs != null) {
            this.searchFieldOutputs.func_146194_f();
        }
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (character == ' ' && this.searchFieldInputs.func_146179_b().isEmpty() && this.searchFieldInputs.func_146206_l()) {
                return;
            }
            if (character == ' ' && this.searchFieldOutputs.func_146179_b().isEmpty() && this.searchFieldOutputs.func_146206_l()) {
                return;
            }
            if (this.searchFieldInputs.func_146201_a(character, key) || this.searchFieldOutputs.func_146201_a(character, key)) {
                this.refreshList();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    public void postUpdate(NBTTagCompound in) {
        if (in.func_74767_n("clear")) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (Object oKey : in.func_150296_c()) {
            String key = (String)oKey;
            if (!key.startsWith("=")) continue;
            try {
                long id = Long.parseLong(key.substring(1), 36);
                NBTTagCompound invData = in.func_74775_l(key);
                ClientDCInternalInv current = this.getById(id, invData.func_74763_f("sortBy"), invData.func_74779_i("un"));
                int X = invData.func_74762_e("x");
                int Y = invData.func_74762_e("y");
                int Z = invData.func_74762_e("z");
                int dim = invData.func_74762_e("dim");
                this.blockPosHashMap.put(current, new DimensionalCoord(X, Y, Z, dim));
                for (int x = 0; x < current.getInventory().func_70302_i_(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.func_74764_b(which)) continue;
                    current.getInventory().func_70299_a(x, ItemStack.func_77949_a((NBTTagCompound)invData.func_74775_l(which)));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.onlyMolecularAssemblers = false;
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        this.field_146292_n.clear();
        this.matchedStacks.clear();
        String searchFieldInputs = this.searchFieldInputs.func_146179_b().toLowerCase();
        String searchFieldOutputs = this.searchFieldOutputs.func_146179_b().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm("IN:" + searchFieldInputs + " OUT:" + searchFieldOutputs + this.onlyInterfacesWithFreeSlots + this.onlyMolecularAssemblers);
        boolean rebuild = cachedSearch.isEmpty();
        for (ClientDCInternalInv entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFieldInputs.isEmpty() && searchFieldOutputs.isEmpty() && !this.onlyInterfacesWithFreeSlots;
            boolean interfaceHasFreeSlots = false;
            if (!found) {
                for (ItemStack itemStack : entry.getInventory()) {
                    if (!searchFieldInputs.isEmpty() && !searchFieldOutputs.isEmpty()) {
                        if (this.itemStackMatchesSearchTerm(itemStack, searchFieldInputs, 0) || this.itemStackMatchesSearchTerm(itemStack, searchFieldOutputs, 1)) {
                            found = true;
                            this.matchedStacks.add(itemStack);
                        }
                    } else if (!searchFieldInputs.isEmpty()) {
                        if (this.itemStackMatchesSearchTerm(itemStack, searchFieldInputs, 0)) {
                            found = true;
                            this.matchedStacks.add(itemStack);
                        }
                    } else if (!searchFieldOutputs.isEmpty() && this.itemStackMatchesSearchTerm(itemStack, searchFieldOutputs, 1)) {
                        found = true;
                        this.matchedStacks.add(itemStack);
                    }
                    if (itemStack != null) continue;
                    interfaceHasFreeSlots = true;
                }
            }
            String name = entry.getName().toLowerCase();
            found = this.onlyMolecularAssemblers ? (searchFieldInputs.isEmpty() && searchFieldOutputs.isEmpty() ? name.equals(MOLECULAR_ASSEMBLER) : (found &= name.equals(MOLECULAR_ASSEMBLER))) : (found |= name.contains(searchFieldInputs) && name.contains(searchFieldOutputs));
            if (found) {
                if (this.onlyInterfacesWithFreeSlots && !interfaceHasFreeSlots) continue;
                this.byName.put((Object)entry.getName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.getMaxRows());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.getScrollBar().setRange(0, this.lines.size() - 6, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm, int pass) {
        if (itemStack == null) {
            return false;
        }
        NBTTagCompound encodedValue = itemStack.func_77978_p();
        if (encodedValue == null) {
            return false;
        }
        NBTTagList tag = encodedValue.func_150295_c(pass == 0 ? "in" : "out", 10);
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            String displayName;
            ItemStack parsedItemStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_150305_b(i));
            if (parsedItemStack == null || !(displayName = Platform.getItemDisplayName(AEApi.instance().storage().createItemStack(parsedItemStack)).toLowerCase()).contains(searchTerm)) continue;
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
            return cache;
        }
        return cache;
    }

    private int getMaxRows() {
        return this.names.size() + this.byId.size();
    }

    private ClientDCInternalInv getById(long id, long sortBy, String string) {
        ClientDCInternalInv o = this.byId.get(id);
        if (o == null) {
            o = new ClientDCInternalInv(9, id, sortBy, string);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }
}

