/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.render.items.ItemEncodedPatternRenderer;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.helpers.PatternHelper;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemEncodedPattern
extends AEBaseItem
implements ICraftingPatternItem {
    private static final Map<ItemStack, ItemStack> SIMPLE_CACHE = new WeakHashMap<ItemStack, ItemStack>();

    public ItemEncodedPattern() {
        this.setFeature(EnumSet.of(AEFeature.Patterns));
        this.func_77625_d(64);
        if (Platform.isClient()) {
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)new ItemEncodedPatternRenderer());
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World w, EntityPlayer player) {
        this.clearPattern(stack, player);
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)stack, (int)1) <= 0) {
            return true;
        }
        return this.clearPattern(stack, player);
    }

    private boolean clearPattern(ItemStack stack, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer inv = player.field_71071_by;
            for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
                if (inv.func_70301_a(s) != stack) continue;
                for (ItemStack blankPattern : AEApi.instance().definitions().materials().blankPattern().maybeStack(stack.field_77994_a).asSet()) {
                    inv.func_70299_a(s, blankPattern);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        List l;
        ICraftingPatternDetails details = this.getPatternForItem(stack, player.field_70170_p);
        if (details == null) {
            lines.add(EnumChatFormatting.RED + GuiText.InvalidPattern.getLocal());
            return;
        }
        boolean isCrafting = details.isCraftable();
        boolean substitute = details.canSubstitute();
        IAEItemStack[] in = details.getCondensedInputs();
        IAEItemStack[] out = details.getCondensedOutputs();
        String label = (isCrafting ? GuiText.Crafts.getLocal() : GuiText.Creates.getLocal()) + ": ";
        String and = ' ' + GuiText.And.getLocal() + ' ';
        String with = GuiText.With.getLocal() + ": ";
        boolean first = true;
        for (IAEItemStack anOut : out) {
            if (anOut == null) continue;
            lines.add((first ? label : and) + anOut.getStackSize() + ' ' + Platform.getItemDisplayName(anOut));
            if (GuiScreen.func_146272_n()) {
                l = anOut.getItemStack().func_82840_a(player, displayMoreInfo);
                if (!l.isEmpty()) {
                    l.remove(0);
                }
                lines.addAll(l);
            }
            first = false;
        }
        first = true;
        for (IAEItemStack anIn : in) {
            if (anIn == null) continue;
            lines.add((first ? with : and) + anIn.getStackSize() + ' ' + Platform.getItemDisplayName(anIn));
            if (GuiScreen.func_146272_n()) {
                l = anIn.getItemStack().func_82840_a(player, displayMoreInfo);
                if (!l.isEmpty()) {
                    l.remove(0);
                }
                lines.addAll(l);
            }
            first = false;
        }
        String substitutionLabel = GuiText.Substitute.getLocal() + " ";
        String canSubstitute = substitute ? GuiText.Yes.getLocal() : GuiText.No.getLocal();
        lines.add(substitutionLabel + canSubstitute);
    }

    @Override
    public ICraftingPatternDetails getPatternForItem(ItemStack is, World w) {
        try {
            return new PatternHelper(is, w);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ItemStack getOutput(ItemStack item) {
        ItemStack out = SIMPLE_CACHE.get(item);
        if (out != null) {
            return out;
        }
        World w = CommonHelper.proxy.getWorld();
        if (w == null) {
            return null;
        }
        ICraftingPatternDetails details = this.getPatternForItem(item, w);
        if (details == null) {
            return null;
        }
        out = details.getCondensedOutputs()[0].getItemStack();
        SIMPLE_CACHE.put(item, out);
        return out;
    }
}

