/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.SortDir;
import appeng.api.storage.data.IAEItemStack;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IInvTweaks;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Comparator;

public class ItemSorters {
    private static SortDir Direction = SortDir.ASCENDING;
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_NAME = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            if (ItemSorters.getDirection() == SortDir.ASCENDING) {
                return Platform.getItemDisplayName(o1).compareToIgnoreCase(Platform.getItemDisplayName(o2));
            }
            return Platform.getItemDisplayName(o2).compareToIgnoreCase(Platform.getItemDisplayName(o1));
        }
    };
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_MOD = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            AEItemStack op1 = (AEItemStack)o1;
            AEItemStack op2 = (AEItemStack)o2;
            if (ItemSorters.getDirection() == SortDir.ASCENDING) {
                return this.secondarySort(op2.getModID().compareToIgnoreCase(op1.getModID()), o1, o2);
            }
            return this.secondarySort(op1.getModID().compareToIgnoreCase(op2.getModID()), o2, o1);
        }

        private int secondarySort(int compareToIgnoreCase, IAEItemStack o1, IAEItemStack o2) {
            if (compareToIgnoreCase == 0) {
                return Platform.getItemDisplayName(o2).compareToIgnoreCase(Platform.getItemDisplayName(o1));
            }
            return compareToIgnoreCase;
        }
    };
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_SIZE = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            if (ItemSorters.getDirection() == SortDir.ASCENDING) {
                return ItemSorters.compareLong(o2.getStackSize(), o1.getStackSize());
            }
            return ItemSorters.compareLong(o1.getStackSize(), o2.getStackSize());
        }
    };
    private static IInvTweaks api;
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_INV_TWEAKS;

    public static void init() {
        if (api != null) {
            return;
        }
        api = IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.InvTweaks) ? (IInvTweaks)IntegrationRegistry.INSTANCE.getInstance(IntegrationType.InvTweaks) : null;
    }

    public static int compareInt(int a, int b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static int compareLong(long a, long b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static int compareDouble(double a, double b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    private static SortDir getDirection() {
        return Direction;
    }

    public static void setDirection(SortDir direction) {
        Direction = direction;
    }

    static {
        CONFIG_BASED_SORT_BY_INV_TWEAKS = new Comparator<IAEItemStack>(){

            @Override
            public int compare(IAEItemStack o1, IAEItemStack o2) {
                if (api == null) {
                    return CONFIG_BASED_SORT_BY_NAME.compare(o1, o2);
                }
                int cmp = api.compareItems(o1.getItemStack(), o2.getItemStack());
                if (ItemSorters.getDirection() == SortDir.ASCENDING) {
                    return cmp;
                }
                return -cmp;
            }
        };
    }
}

