/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.v2;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.AELog;
import appeng.crafting.v2.CraftingCalculations;
import appeng.crafting.v2.CraftingContext;
import appeng.crafting.v2.resolvers.CraftingTask;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class CraftingRequest<StackType extends IAEStack<StackType>> {
    public final Class<StackType> stackTypeClass;
    public final StackType stack;
    public final SubstitutionMode substitutionMode;
    public final Predicate<StackType> acceptableSubstituteFn;
    public final List<UsedResolverEntry> usedResolvers = new ArrayList<UsedResolverEntry>();
    public final boolean allowSimulation;
    public volatile long remainingToProcess;
    private volatile long byteCost = 0L;
    private volatile long untransformedByteCost = 0L;
    public volatile boolean wasSimulated = false;
    public final Set<ICraftingPatternDetails> patternParents = new HashSet<ICraftingPatternDetails>();

    public CraftingRequest(StackType stack, SubstitutionMode substitutionMode, Class<StackType> stackTypeClass, boolean allowSimulation, Predicate<StackType> acceptableSubstituteFn) {
        this.stackTypeClass = stackTypeClass;
        this.stack = stack;
        this.substitutionMode = substitutionMode;
        this.acceptableSubstituteFn = acceptableSubstituteFn;
        this.remainingToProcess = stack.getStackSize();
        this.allowSimulation = allowSimulation;
        if (stackTypeClass != IAEItemStack.class && stackTypeClass != IAEFluidStack.class) {
            throw new IllegalArgumentException("Invalid stack type for a crafting request: " + stackTypeClass.getName());
        }
    }

    public CraftingRequest(StackType request, SubstitutionMode substitutionMode, Class<StackType> stackTypeClass, boolean allowSimulation) {
        this((IAEStack)request, substitutionMode, (Class<IAEStack>)stackTypeClass, allowSimulation, stack -> true);
        if (substitutionMode == SubstitutionMode.ACCEPT_FUZZY) {
            throw new IllegalArgumentException("Fuzzy requests must have a substitution-valid predicate");
        }
    }

    public long getByteCost() {
        return this.byteCost;
    }

    public String toString() {
        String readableName = "";
        if (this.stack instanceof AEItemStack) {
            try {
                readableName = "<" + ((AEItemStack)this.stack).getDisplayName() + ">";
            }
            catch (Exception e) {
                AELog.warn(e, "Trying to obtain display name for " + this.stack);
                readableName = "<EXCEPTION>";
            }
        }
        return "CraftingRequest{request=" + this.stack + readableName + ", substitutionMode=" + (Object)((Object)this.substitutionMode) + ", remainingToProcess=" + this.remainingToProcess + ", byteCost=" + this.byteCost + ", wasSimulated=" + this.wasSimulated + '}';
    }

    public void fulfill(CraftingTask origin, StackType input, CraftingContext context) {
        if (input == null || input.getStackSize() == 0L) {
            return;
        }
        if (input.getStackSize() < 0L) {
            throw new IllegalArgumentException("Can't fulfill crafting request with a negative amount of " + input + " : " + this);
        }
        if (this.remainingToProcess < input.getStackSize()) {
            throw new IllegalArgumentException("Can't fulfill crafting request with too many of " + input + " : " + this);
        }
        this.untransformedByteCost += input.getStackSize();
        this.byteCost = CraftingCalculations.adjustByteCost(this, this.untransformedByteCost);
        this.remainingToProcess -= input.getStackSize();
        this.usedResolvers.add(new UsedResolverEntry(origin, (IAEStack<?>)input.copy()));
    }

    public void partialRefund(CraftingContext context, long refundedAmount) {
        long remainingTaskAmount = refundedAmount;
        for (UsedResolverEntry resolver : this.usedResolvers) {
            if (remainingTaskAmount <= 0L) break;
            if (resolver.resolvedStack.getStackSize() <= 0L) continue;
            long taskRefunded = resolver.task.partialRefund(context, Math.min(remainingTaskAmount, resolver.resolvedStack.getStackSize()));
            remainingTaskAmount -= taskRefunded;
            resolver.resolvedStack.setStackSize(resolver.resolvedStack.getStackSize() - taskRefunded);
        }
        if (remainingTaskAmount < 0L) {
            throw new IllegalStateException("Refunds resulted in a negative amount of an item for request " + this);
        }
        if (remainingTaskAmount != 0L) {
            throw new IllegalStateException("Partial refunds could not cover all resolved items for request " + this);
        }
        long originallyRequested = this.stack.getStackSize();
        long originallyRemainingToProcess = this.remainingToProcess;
        long originallyProcessed = originallyRequested - originallyRemainingToProcess;
        long newlyRequested = originallyRequested - refundedAmount;
        long newlyProcessed = Math.min(originallyProcessed, newlyRequested);
        long newlyRemainingToProcess = newlyRequested - newlyProcessed;
        this.stack.setStackSize(newlyRequested);
        this.remainingToProcess = newlyRemainingToProcess;
        this.untransformedByteCost -= refundedAmount;
        this.byteCost = CraftingCalculations.adjustByteCost(this, this.untransformedByteCost);
        if (this.remainingToProcess < 0L) {
            throw new IllegalArgumentException("Refunded more items than were resolved for request " + this);
        }
    }

    public void fullRefund(CraftingContext context) {
        for (UsedResolverEntry resolver : this.usedResolvers) {
            resolver.task.fullRefund(context);
        }
        this.remainingToProcess = 0L;
        this.untransformedByteCost = 0L;
        this.byteCost = CraftingCalculations.adjustByteCost(this, this.untransformedByteCost);
        this.stack.setStackSize(0L);
        this.usedResolvers.clear();
    }

    public IAEStack<?> getOneResolvedType() {
        IAEStack<?> found = null;
        for (UsedResolverEntry resolver : this.usedResolvers) {
            if (resolver.resolvedStack.getStackSize() <= 0L) continue;
            if (found == null) {
                found = (IAEStack<?>)resolver.resolvedStack.copy();
                continue;
            }
            throw new IllegalStateException("Found multiple item types resolving " + this);
        }
        if (found == null) {
            throw new IllegalStateException("Found no resolution for " + this);
        }
        return found;
    }

    public static class UsedResolverEntry {
        public final CraftingTask task;
        public final IAEStack<?> resolvedStack;

        public UsedResolverEntry(CraftingTask task, IAEStack<?> resolvedStack) {
            this.task = task;
            this.resolvedStack = resolvedStack;
        }
    }

    public static enum SubstitutionMode {
        PRECISE_FRESH,
        PRECISE,
        ACCEPT_FUZZY;

    }
}

