/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.v2.resolvers;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.crafting.CraftBranchFailure;
import appeng.crafting.MECraftingInventory;
import appeng.crafting.v2.CraftingContext;
import appeng.crafting.v2.CraftingRequest;
import appeng.crafting.v2.resolvers.CraftingRequestResolver;
import appeng.crafting.v2.resolvers.CraftingTask;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class ExtractItemResolver
implements CraftingRequestResolver<IAEItemStack> {
    @Override
    @Nonnull
    public List<CraftingTask> provideCraftingRequestResolvers(@Nonnull CraftingRequest<IAEItemStack> request, @Nonnull CraftingContext context) {
        if (request.substitutionMode == CraftingRequest.SubstitutionMode.PRECISE_FRESH) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ExtractItemTask(request));
    }

    public static class ExtractItemTask
    extends CraftingTask<IAEItemStack> {
        public final List<IAEItemStack> removedFromSystem = new ArrayList<IAEItemStack>();
        public final List<IAEItemStack> removedFromByproducts = new ArrayList<IAEItemStack>();

        public ExtractItemTask(CraftingRequest<IAEItemStack> request) {
            super(request, 2147483547);
        }

        @Override
        public CraftingTask.StepOutput calculateOneStep(CraftingContext context) {
            this.state = CraftingTask.State.SUCCESS;
            if (this.request.remainingToProcess <= 0L) {
                return new CraftingTask.StepOutput(Collections.emptyList());
            }
            this.extractExact(context, context.byproductsInventory, this.removedFromByproducts);
            if (this.request.remainingToProcess > 0L) {
                this.extractExact(context, context.itemModel, this.removedFromSystem);
            }
            if (this.request.remainingToProcess > 0L && this.request.substitutionMode == CraftingRequest.SubstitutionMode.ACCEPT_FUZZY) {
                this.extractFuzzy(context, context.byproductsInventory, this.removedFromByproducts);
                if (this.request.remainingToProcess > 0L) {
                    this.extractFuzzy(context, context.itemModel, this.removedFromSystem);
                }
            }
            return new CraftingTask.StepOutput(Collections.emptyList());
        }

        private void extractExact(CraftingContext context, MECraftingInventory source, List<IAEItemStack> removedList) {
            IAEItemStack exactMatching = (IAEItemStack)source.getItemList().findPrecise((IAEItemStack)this.request.stack);
            if (exactMatching != null) {
                long requestSize = Math.min(this.request.remainingToProcess, exactMatching.getStackSize());
                IAEItemStack extracted = source.extractItems((IAEItemStack)exactMatching.copy().setStackSize(requestSize), Actionable.MODULATE, context.actionSource);
                if (extracted != null && extracted.getStackSize() > 0L) {
                    this.request.fulfill(this, extracted, context);
                    removedList.add(extracted.copy());
                }
            }
        }

        private void extractFuzzy(CraftingContext context, MECraftingInventory source, List<IAEItemStack> removedList) {
            Collection fuzzyMatching = source.getItemList().findFuzzy((IAEItemStack)this.request.stack, FuzzyMode.IGNORE_ALL);
            for (IAEItemStack candidate : fuzzyMatching) {
                if (candidate == null || !this.request.acceptableSubstituteFn.test(candidate)) continue;
                long requestSize = Math.min(this.request.remainingToProcess, candidate.getStackSize());
                IAEItemStack extracted = source.extractItems((IAEItemStack)candidate.copy().setStackSize(requestSize), Actionable.MODULATE, context.actionSource);
                if (extracted == null || extracted.getStackSize() <= 0L) continue;
                this.request.fulfill(this, extracted, context);
                removedList.add(extracted.copy());
            }
        }

        @Override
        public long partialRefund(CraftingContext context, long amount) {
            long originalAmount = amount;
            Collections.reverse(this.removedFromSystem);
            Collections.reverse(this.removedFromByproducts);
            amount = this.partialRefundFrom(context, amount, this.removedFromSystem, context.itemModel);
            amount = this.partialRefundFrom(context, amount, this.removedFromByproducts, context.byproductsInventory);
            Collections.reverse(this.removedFromSystem);
            Collections.reverse(this.removedFromByproducts);
            return originalAmount - amount;
        }

        private long partialRefundFrom(CraftingContext context, long amount, List<IAEItemStack> source, MECraftingInventory target) {
            Iterator<IAEItemStack> removedIt = source.iterator();
            while (removedIt.hasNext() && amount > 0L) {
                IAEItemStack available = removedIt.next();
                long availAmount = available.getStackSize();
                if (availAmount > amount) {
                    target.injectItems((IAEItemStack)available.copy().setStackSize(amount), Actionable.MODULATE, context.actionSource);
                    available.setStackSize(availAmount - amount);
                    amount = 0L;
                    continue;
                }
                target.injectItems(available, Actionable.MODULATE, context.actionSource);
                amount -= availAmount;
                removedIt.remove();
            }
            return amount;
        }

        @Override
        public void fullRefund(CraftingContext context) {
            for (IAEItemStack removed : this.removedFromByproducts) {
                context.byproductsInventory.injectItems(removed, Actionable.MODULATE, context.actionSource);
            }
            for (IAEItemStack removed : this.removedFromSystem) {
                context.itemModel.injectItems(removed, Actionable.MODULATE, context.actionSource);
            }
            this.removedFromSystem.clear();
        }

        @Override
        public void populatePlan(IItemList<IAEItemStack> targetPlan) {
            for (IAEItemStack removed : this.removedFromSystem) {
                targetPlan.add(removed.copy());
            }
        }

        @Override
        public void startOnCpu(CraftingContext context, CraftingCPUCluster cpuCluster, MECraftingInventory craftingInv) {
            for (IAEItemStack stack : this.removedFromSystem) {
                if (stack.getStackSize() <= 0L) continue;
                IAEItemStack extracted = craftingInv.extractItems(stack, Actionable.MODULATE, context.actionSource);
                if (extracted == null || extracted.getStackSize() != stack.getStackSize()) {
                    throw new CraftBranchFailure(stack, stack.getStackSize());
                }
                cpuCluster.addStorage(extracted);
            }
        }

        public String toString() {
            return "ExtractItemTask{request=" + this.request + ", removedFromSystem=" + this.removedFromSystem + ", priority=" + this.priority + ", state=" + (Object)((Object)this.state) + '}';
        }
    }
}

