/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.materials;

import appeng.core.AppEng;
import appeng.core.features.AEFeature;
import appeng.core.features.MaterialStackSrc;
import appeng.entity.EntityChargedQuartz;
import appeng.entity.EntityIds;
import appeng.entity.EntitySingularity;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum MaterialType {
    InvalidType(-1, AEFeature.Core),
    CertusQuartzCrystal(0, AEFeature.Core, "crystalCertusQuartz"),
    CertusQuartzCrystalCharged(1, AEFeature.Core, EntityChargedQuartz.class),
    CertusQuartzDust(2, AEFeature.Core, "dustCertusQuartz"),
    NetherQuartzDust(3, AEFeature.Core, "dustNetherQuartz"),
    Flour(4, AEFeature.Flour, "dustWheat"),
    GoldDust(51, AEFeature.Core, "dustGold"),
    IronDust(49, AEFeature.Core, "dustIron"),
    IronNugget(50, AEFeature.Core, "nuggetIron"),
    Silicon(5, AEFeature.Core, "itemSilicon"),
    MatterBall(6),
    FluixCrystal(7, AEFeature.Core, "crystalFluix"),
    FluixDust(8, AEFeature.Core, "dustFluix"),
    FluixPearl(9, AEFeature.Core, "pearlFluix"),
    PurifiedCertusQuartzCrystal(10),
    PurifiedNetherQuartzCrystal(11),
    PurifiedFluixCrystal(12),
    CalcProcessorPress(13),
    EngProcessorPress(14),
    LogicProcessorPress(15),
    CalcProcessorPrint(16),
    EngProcessorPrint(17),
    LogicProcessorPrint(18),
    SiliconPress(19),
    SiliconPrint(20),
    NamePress(21),
    LogicProcessor(22),
    CalcProcessor(23),
    EngProcessor(24),
    BasicCard(25),
    CardRedstone(26),
    CardCapacity(27),
    AdvCard(28),
    CardFuzzy(29),
    CardSpeed(30),
    CardInverter(31),
    Cell2SpatialPart(32, AEFeature.SpatialIO),
    Cell16SpatialPart(33, AEFeature.SpatialIO),
    Cell128SpatialPart(34, AEFeature.SpatialIO),
    Cell1kPart(35, AEFeature.StorageCells),
    Cell4kPart(36, AEFeature.StorageCells),
    Cell16kPart(37, AEFeature.StorageCells),
    Cell64kPart(38, AEFeature.StorageCells),
    EmptyStorageCell(39, AEFeature.StorageCells),
    WoodenGear(40, AEFeature.GrindStone, "gearWood"),
    Wireless(41, AEFeature.WirelessAccessTerminal),
    WirelessBooster(42, AEFeature.WirelessAccessTerminal),
    FormationCore(43),
    AnnihilationCore(44),
    SkyDust(45, AEFeature.Core),
    EnderDust(46, AEFeature.QuantumNetworkBridge, "dustEnder,dustEnderPearl", EntitySingularity.class),
    Singularity(47, AEFeature.QuantumNetworkBridge, EntitySingularity.class),
    QESingularity(48, AEFeature.QuantumNetworkBridge, EntitySingularity.class),
    BlankPattern(52),
    CardCrafting(53),
    CardPatternCapacity(54),
    CardOreFilter(55),
    CardSuperSpeed(56),
    Cell256kPart(57, AEFeature.StorageCells),
    Cell1024kPart(58, AEFeature.StorageCells),
    Cell4096kPart(59, AEFeature.StorageCells),
    Cell16384kPart(60, AEFeature.StorageCells),
    EmptyAdvancedStorageCell(61, AEFeature.StorageCells);

    private final EnumSet<AEFeature> features;
    @SideOnly(value=Side.CLIENT)
    private IIcon IIcon;
    private Item itemInstance;
    private int damageValue;
    private MaterialStackSrc stackSrc;
    private String oreName;
    private Class<? extends Entity> droppedEntity;
    private boolean isRegistered = false;

    private MaterialType(int metaValue) {
        this.setDamageValue(metaValue);
        this.features = EnumSet.of(AEFeature.Core);
    }

    private MaterialType(int metaValue, AEFeature part) {
        this.setDamageValue(metaValue);
        this.features = EnumSet.of(part);
    }

    private MaterialType(int metaValue, AEFeature part, Class<? extends Entity> c) {
        this.features = EnumSet.of(part);
        this.setDamageValue(metaValue);
        this.droppedEntity = c;
        EntityRegistry.registerModEntity(this.droppedEntity, (String)this.droppedEntity.getSimpleName(), (int)EntityIds.get(this.droppedEntity), (Object)AppEng.instance(), (int)16, (int)4, (boolean)true);
    }

    private MaterialType(int metaValue, AEFeature part, String oreDictionary, Class<? extends Entity> c) {
        this.features = EnumSet.of(part);
        this.setDamageValue(metaValue);
        this.oreName = oreDictionary;
        this.droppedEntity = c;
        EntityRegistry.registerModEntity(this.droppedEntity, (String)this.droppedEntity.getSimpleName(), (int)EntityIds.get(this.droppedEntity), (Object)AppEng.instance(), (int)16, (int)4, (boolean)true);
    }

    private MaterialType(int metaValue, AEFeature part, String oreDictionary) {
        this.features = EnumSet.of(part);
        this.setDamageValue(metaValue);
        this.oreName = oreDictionary;
    }

    public ItemStack stack(int size) {
        return new ItemStack(this.getItemInstance(), size, this.getDamageValue());
    }

    EnumSet<AEFeature> getFeature() {
        return this.features;
    }

    public String getOreName() {
        return this.oreName;
    }

    boolean hasCustomEntity() {
        return this.droppedEntity != null;
    }

    Class<? extends Entity> getCustomEntityClass() {
        return this.droppedEntity;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    void markReady() {
        this.isRegistered = true;
    }

    public int getDamageValue() {
        return this.damageValue;
    }

    void setDamageValue(int damageValue) {
        this.damageValue = damageValue;
    }

    public Item getItemInstance() {
        return this.itemInstance;
    }

    void setItemInstance(Item itemInstance) {
        this.itemInstance = itemInstance;
    }

    IIcon getIIcon() {
        return this.IIcon;
    }

    void setIIcon(IIcon iIcon) {
        this.IIcon = iIcon;
    }

    MaterialStackSrc getStackSrc() {
        return this.stackSrc;
    }

    void setStackSrc(MaterialStackSrc stackSrc) {
        this.stackSrc = stackSrc;
    }
}

