/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.definitions.IParts;
import appeng.api.implementations.parts.IPartCable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEColoredItemDefinition;
import appeng.api.util.IReadOnlyCollection;
import appeng.block.AEBaseBlock;
import appeng.client.texture.CableBusTextures;
import appeng.client.texture.FlippableIcon;
import appeng.client.texture.TaughtIcon;
import appeng.items.parts.ItemMultiPart;
import appeng.me.GridAccessException;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.EnumSet;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class PartCable
extends AEBasePart
implements IPartCable {
    private final int[] channelsOnSide = new int[]{0, 0, 0, 0, 0, 0};
    private EnumSet<ForgeDirection> connections = EnumSet.noneOf(ForgeDirection.class);
    private boolean powered = false;

    public PartCable(ItemStack is) {
        super(is);
        this.getProxy().setFlags(GridFlags.PREFERRED);
        this.getProxy().setIdlePowerUsage(0.0);
        this.getProxy().setColor(AEColor.values()[((ItemMultiPart)is.func_77973_b()).variantOf(is.func_77960_j())]);
    }

    @Override
    public BusSupport supportsBuses() {
        return BusSupport.CABLE;
    }

    @Override
    public AEColor getCableColor() {
        return this.getProxy().getColor();
    }

    @Override
    public AECableType getCableConnectionType() {
        return AECableType.GLASS;
    }

    @Override
    public boolean changeColor(AEColor newColor, EntityPlayer who) {
        if (this.getCableColor() != newColor) {
            ItemStack newPart = null;
            IParts parts = AEApi.instance().definitions().parts();
            if (this.getCableConnectionType() == AECableType.GLASS) {
                newPart = parts.cableGlass().stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.COVERED) {
                newPart = parts.cableCovered().stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.SMART) {
                newPart = parts.cableSmart().stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.DENSE) {
                newPart = parts.cableDense().stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.DENSE_COVERED) {
                newPart = parts.cableDenseCovered().stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.ULTRA_DENSE) {
                newPart = parts.cableUltraDenseSmart().stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.ULTRA_DENSE_SMART) {
                newPart = parts.cableUltraDenseCovered().stack(newColor, 1);
            }
            boolean hasPermission = true;
            try {
                hasPermission = this.getProxy().getSecurity().hasPermission(who, SecurityPermissions.BUILD);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            if (newPart != null && hasPermission) {
                if (Platform.isClient()) {
                    return true;
                }
                this.getHost().removePart(ForgeDirection.UNKNOWN, true);
                this.getHost().addPart(newPart, ForgeDirection.UNKNOWN, who);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValidSides(EnumSet<ForgeDirection> sides) {
        this.getProxy().setValidSides(sides);
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        return this.getConnections().contains(side);
    }

    public void markForUpdate() {
        this.getHost().markForUpdate();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        IPartHost ph;
        bch.addBox(6.0, 6.0, 6.0, 10.0, 10.0, 10.0);
        if (Platform.isServer()) {
            IGridNode n = this.getGridNode();
            if (n != null) {
                this.setConnections(n.getConnectedSides());
            } else {
                this.getConnections().clear();
            }
        }
        if ((ph = this.getHost()) != null) {
            block16: for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                double dist;
                IPart p = ph.getPart(dir);
                if (!(p instanceof IGridHost) || (dist = (double)p.cableConnectionRenderTo()) > 8.0) continue;
                switch (dir) {
                    case DOWN: {
                        bch.addBox(6.0, dist, 6.0, 10.0, 6.0, 10.0);
                        continue block16;
                    }
                    case EAST: {
                        bch.addBox(10.0, 6.0, 6.0, 16.0 - dist, 10.0, 10.0);
                        continue block16;
                    }
                    case NORTH: {
                        bch.addBox(6.0, 6.0, dist, 10.0, 10.0, 6.0);
                        continue block16;
                    }
                    case SOUTH: {
                        bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0 - dist);
                        continue block16;
                    }
                    case UP: {
                        bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0 - dist, 10.0);
                        continue block16;
                    }
                    case WEST: {
                        bch.addBox(dist, 6.0, 6.0, 6.0, 10.0, 10.0);
                        continue block16;
                    }
                }
            }
        }
        for (ForgeDirection of : this.getConnections()) {
            switch (of) {
                case DOWN: {
                    bch.addBox(6.0, 0.0, 6.0, 10.0, 6.0, 10.0);
                    break;
                }
                case EAST: {
                    bch.addBox(10.0, 6.0, 6.0, 16.0, 10.0, 10.0);
                    break;
                }
                case NORTH: {
                    bch.addBox(6.0, 6.0, 0.0, 10.0, 10.0, 6.0);
                    break;
                }
                case SOUTH: {
                    bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0);
                    break;
                }
                case UP: {
                    bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0, 10.0);
                    break;
                }
                case WEST: {
                    bch.addBox(0.0, 6.0, 6.0, 6.0, 10.0, 10.0);
                    break;
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        GL11.glTranslated((double)-0.0, (double)-0.0, (double)0.3);
        rh.setTexture(this.getTexture(this.getCableColor()));
        rh.setBounds(6.0f, 6.0f, 2.0f, 10.0f, 10.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(null);
    }

    public IIcon getTexture(AEColor c) {
        return this.getGlassTexture(c);
    }

    public IIcon getGlassTexture(AEColor c) {
        switch (c) {
            case Black: {
                return CableBusTextures.MECable_Black.getIcon();
            }
            case Blue: {
                return CableBusTextures.MECable_Blue.getIcon();
            }
            case Brown: {
                return CableBusTextures.MECable_Brown.getIcon();
            }
            case Cyan: {
                return CableBusTextures.MECable_Cyan.getIcon();
            }
            case Gray: {
                return CableBusTextures.MECable_Grey.getIcon();
            }
            case Green: {
                return CableBusTextures.MECable_Green.getIcon();
            }
            case LightBlue: {
                return CableBusTextures.MECable_LightBlue.getIcon();
            }
            case LightGray: {
                return CableBusTextures.MECable_LightGrey.getIcon();
            }
            case Lime: {
                return CableBusTextures.MECable_Lime.getIcon();
            }
            case Magenta: {
                return CableBusTextures.MECable_Magenta.getIcon();
            }
            case Orange: {
                return CableBusTextures.MECable_Orange.getIcon();
            }
            case Pink: {
                return CableBusTextures.MECable_Pink.getIcon();
            }
            case Purple: {
                return CableBusTextures.MECable_Purple.getIcon();
            }
            case Red: {
                return CableBusTextures.MECable_Red.getIcon();
            }
            case White: {
                return CableBusTextures.MECable_White.getIcon();
            }
            case Yellow: {
                return CableBusTextures.MECable_Yellow.getIcon();
            }
        }
        AEColoredItemDefinition glassCable = AEApi.instance().definitions().parts().cableGlass();
        ItemStack glassCableStack = glassCable.stack(AEColor.Transparent, 1);
        return glassCable.item(AEColor.Transparent).func_77650_f(glassCableStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, this, this.getRenderCache()));
        boolean useCovered = false;
        boolean requireDetailed = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IGridHost gh;
            IPart p = this.getHost().getPart(dir);
            if (p instanceof IGridHost) {
                IGridHost igh = (IGridHost)((Object)p);
                AECableType type = igh.getCableConnectionType(dir.getOpposite());
                if (type != AECableType.COVERED && type != AECableType.SMART) continue;
                useCovered = true;
                break;
            }
            if (!this.getConnections().contains(dir)) continue;
            TileEntity te = this.getTile().func_145831_w().func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            IPartHost partHost = te instanceof IPartHost ? (IPartHost)te : null;
            IGridHost iGridHost = gh = te instanceof IGridHost ? (IGridHost)te : null;
            if (partHost != null || gh == null || gh.getCableConnectionType(dir) == AECableType.GLASS) continue;
            requireDetailed = true;
        }
        if (useCovered) {
            rh.setTexture(this.getCoveredTexture(this.getCableColor()));
        } else {
            rh.setTexture(this.getTexture(this.getCableColor()));
        }
        IPartHost ph = this.getHost();
        block14: for (ForgeDirection of : EnumSet.complementOf(this.getConnections())) {
            int len;
            IPart bp = ph.getPart(of);
            if (!(bp instanceof IGridHost) || (len = bp.cableConnectionRenderTo()) >= 8) continue;
            switch (of) {
                case DOWN: {
                    rh.setBounds(6.0f, len, 6.0f, 10.0f, 6.0f, 10.0f);
                    break;
                }
                case EAST: {
                    rh.setBounds(10.0f, 6.0f, 6.0f, 16 - len, 10.0f, 10.0f);
                    break;
                }
                case NORTH: {
                    rh.setBounds(6.0f, 6.0f, len, 10.0f, 10.0f, 6.0f);
                    break;
                }
                case SOUTH: {
                    rh.setBounds(6.0f, 6.0f, 10.0f, 10.0f, 10.0f, 16 - len);
                    break;
                }
                case UP: {
                    rh.setBounds(6.0f, 10.0f, 6.0f, 10.0f, 16 - len, 10.0f);
                    break;
                }
                case WEST: {
                    rh.setBounds(len, 6.0f, 6.0f, 6.0f, 10.0f, 10.0f);
                    break;
                }
                default: {
                    continue block14;
                }
            }
            rh.renderBlock(x, y, z, renderer);
        }
        if (this.getConnections().size() != 2 || !this.nonLinear(this.getConnections()) || useCovered || requireDetailed) {
            if (useCovered) {
                rh.setBounds(5.0f, 5.0f, 5.0f, 11.0f, 11.0f, 11.0f);
                rh.renderBlock(x, y, z, renderer);
            } else {
                rh.setBounds(6.0f, 6.0f, 6.0f, 10.0f, 10.0f, 10.0f);
                rh.renderBlock(x, y, z, renderer);
            }
            for (ForgeDirection of : this.getConnections()) {
                this.renderGlassConnection(x, y, z, rh, renderer, of);
            }
        } else {
            IIcon def = this.getTexture(this.getCableColor());
            rh.setTexture(def);
            for (ForgeDirection of : this.getConnections()) {
                rh.setFacesToRender(EnumSet.complementOf(EnumSet.of(of, of.getOpposite())));
                switch (of) {
                    case DOWN: 
                    case UP: {
                        renderer.func_147782_a(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        renderer.field_147873_r = 1;
                        renderer.field_147875_q = 1;
                        renderer.field_147867_u = 1;
                        renderer.field_147865_v = 1;
                        renderer.func_147782_a(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        renderer.field_147871_s = 1;
                        renderer.field_147869_t = 1;
                        renderer.func_147782_a(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
                        break;
                    }
                }
            }
            rh.renderBlockCurrentBounds(x, y, z, renderer);
        }
        rh.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
        rh.setTexture(null);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        IGridNode node;
        super.writeToNBT(data);
        if (Platform.isServer() && (node = this.getGridNode()) != null) {
            int howMany = 0;
            for (IGridConnection gc : node.getConnections()) {
                howMany = Math.max(gc.getUsedChannels(), howMany);
            }
            data.func_74777_a("usedChannels", (short)howMany);
        }
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        int cs = 0;
        int sideOut = 0;
        IGridNode n = this.getGridNode();
        if (n != null) {
            for (ForgeDirection thisSide : ForgeDirection.VALID_DIRECTIONS) {
                IPart part = this.getHost().getPart(thisSide);
                if (part == null || part.getGridNode() == null) continue;
                IReadOnlyCollection<IGridConnection> set = part.getGridNode().getConnections();
                for (IGridConnection gc : set) {
                    if (this.getProxy().getNode().hasFlag(GridFlags.ULTRA_DENSE_CAPACITY) && gc.getOtherSide(this.getProxy().getNode()).hasFlag(GridFlags.ULTRA_DENSE_CAPACITY)) {
                        sideOut |= gc.getUsedChannels() / 16 << 4 * thisSide.ordinal();
                        continue;
                    }
                    if (this.getProxy().getNode().hasFlag(GridFlags.DENSE_CAPACITY) && gc.getOtherSide(this.getProxy().getNode()).hasFlag(GridFlags.DENSE_CAPACITY)) {
                        sideOut |= gc.getUsedChannels() / 4 << 4 * thisSide.ordinal();
                        continue;
                    }
                    sideOut |= gc.getUsedChannels() << 4 * thisSide.ordinal();
                }
            }
            for (IGridConnection gc : n.getConnections()) {
                ForgeDirection side = gc.getDirection(n);
                if (side == ForgeDirection.UNKNOWN) continue;
                boolean isTier3a = this.getProxy().getNode().hasFlag(GridFlags.ULTRA_DENSE_CAPACITY);
                boolean isTier3b = gc.getOtherSide(this.getProxy().getNode()).hasFlag(GridFlags.ULTRA_DENSE_CAPACITY);
                boolean isTier2a = this.getProxy().getNode().hasFlag(GridFlags.DENSE_CAPACITY);
                boolean isTier2b = gc.getOtherSide(this.getProxy().getNode()).hasFlag(GridFlags.DENSE_CAPACITY);
                sideOut = isTier3a && isTier3b ? (sideOut |= gc.getUsedChannels() / 16 << 4 * side.ordinal()) : ((isTier3a || isTier2a) && (isTier2b || isTier3b) ? (sideOut |= gc.getUsedChannels() / 4 << 4 * side.ordinal()) : (sideOut |= gc.getUsedChannels() << 4 * side.ordinal()));
                cs |= 1 << side.ordinal();
            }
        }
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                cs |= 1 << ForgeDirection.UNKNOWN.ordinal();
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        data.writeByte((int)((byte)cs));
        data.writeInt(sideOut);
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        byte cs = data.readByte();
        int sideOut = data.readInt();
        Object myC = this.getConnections().clone();
        boolean wasPowered = this.powered;
        this.powered = false;
        boolean channelsChanged = false;
        for (ForgeDirection d : ForgeDirection.values()) {
            int id;
            int ch;
            if (d != ForgeDirection.UNKNOWN && (ch = sideOut >> d.ordinal() * 4 & 0xF) != this.getChannelsOnSide()[d.ordinal()]) {
                channelsChanged = true;
                this.getChannelsOnSide()[d.ordinal()] = ch;
            }
            if (d == ForgeDirection.UNKNOWN) {
                id = 1 << d.ordinal();
                if (id != (cs & id)) continue;
                this.powered = true;
                continue;
            }
            id = 1 << d.ordinal();
            if (id == (cs & id)) {
                this.getConnections().add(d);
                continue;
            }
            this.getConnections().remove(d);
        }
        return !((AbstractSet)myC).equals(this.getConnections()) || wasPowered != this.powered || channelsChanged;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBreakingTexture() {
        return this.getTexture(this.getCableColor());
    }

    public IIcon getCoveredTexture(AEColor c) {
        switch (c) {
            case Black: {
                return CableBusTextures.MECovered_Black.getIcon();
            }
            case Blue: {
                return CableBusTextures.MECovered_Blue.getIcon();
            }
            case Brown: {
                return CableBusTextures.MECovered_Brown.getIcon();
            }
            case Cyan: {
                return CableBusTextures.MECovered_Cyan.getIcon();
            }
            case Gray: {
                return CableBusTextures.MECovered_Gray.getIcon();
            }
            case Green: {
                return CableBusTextures.MECovered_Green.getIcon();
            }
            case LightBlue: {
                return CableBusTextures.MECovered_LightBlue.getIcon();
            }
            case LightGray: {
                return CableBusTextures.MECovered_LightGrey.getIcon();
            }
            case Lime: {
                return CableBusTextures.MECovered_Lime.getIcon();
            }
            case Magenta: {
                return CableBusTextures.MECovered_Magenta.getIcon();
            }
            case Orange: {
                return CableBusTextures.MECovered_Orange.getIcon();
            }
            case Pink: {
                return CableBusTextures.MECovered_Pink.getIcon();
            }
            case Purple: {
                return CableBusTextures.MECovered_Purple.getIcon();
            }
            case Red: {
                return CableBusTextures.MECovered_Red.getIcon();
            }
            case White: {
                return CableBusTextures.MECovered_White.getIcon();
            }
            case Yellow: {
                return CableBusTextures.MECovered_Yellow.getIcon();
            }
        }
        AEColoredItemDefinition coveredCable = AEApi.instance().definitions().parts().cableCovered();
        ItemStack coveredCableStack = coveredCable.stack(AEColor.Transparent, 1);
        return coveredCable.item(AEColor.Transparent).func_77650_f(coveredCableStack);
    }

    protected boolean nonLinear(EnumSet<ForgeDirection> sides) {
        return sides.contains(ForgeDirection.EAST) && sides.contains(ForgeDirection.WEST) || sides.contains(ForgeDirection.NORTH) && sides.contains(ForgeDirection.SOUTH) || sides.contains(ForgeDirection.UP) && sides.contains(ForgeDirection.DOWN);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderGlassConnection(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer, ForgeDirection of) {
        TileEntity te = this.getTile().func_145831_w().func_147438_o(x + of.offsetX, y + of.offsetY, z + of.offsetZ);
        IPartHost partHost = te instanceof IPartHost ? (IPartHost)te : null;
        IGridHost gh = te instanceof IGridHost ? (IGridHost)te : null;
        rh.setFacesToRender(EnumSet.complementOf(EnumSet.of(of)));
        if (gh != null && partHost != null && gh.getCableConnectionType(of.getOpposite()) == AECableType.GLASS && partHost.getColor() != AEColor.Transparent && partHost.getPart(of.getOpposite()) == null) {
            rh.setTexture(this.getTexture(partHost.getColor()));
        } else if (partHost == null && gh != null && gh.getCableConnectionType(of.getOpposite()) != AECableType.GLASS) {
            rh.setTexture(this.getCoveredTexture(this.getCableColor()));
            switch (of) {
                case DOWN: {
                    rh.setBounds(5.0f, 0.0f, 5.0f, 11.0f, 4.0f, 11.0f);
                    break;
                }
                case EAST: {
                    rh.setBounds(12.0f, 5.0f, 5.0f, 16.0f, 11.0f, 11.0f);
                    break;
                }
                case NORTH: {
                    rh.setBounds(5.0f, 5.0f, 0.0f, 11.0f, 11.0f, 4.0f);
                    break;
                }
                case SOUTH: {
                    rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 16.0f);
                    break;
                }
                case UP: {
                    rh.setBounds(5.0f, 12.0f, 5.0f, 11.0f, 16.0f, 11.0f);
                    break;
                }
                case WEST: {
                    rh.setBounds(0.0f, 5.0f, 5.0f, 4.0f, 11.0f, 11.0f);
                    break;
                }
                default: {
                    return;
                }
            }
            rh.renderBlock(x, y, z, renderer);
            rh.setTexture(this.getTexture(this.getCableColor()));
        } else {
            rh.setTexture(this.getTexture(this.getCableColor()));
        }
        switch (of) {
            case DOWN: {
                rh.setBounds(6.0f, 0.0f, 6.0f, 10.0f, 6.0f, 10.0f);
                break;
            }
            case EAST: {
                rh.setBounds(10.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
                break;
            }
            case NORTH: {
                rh.setBounds(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 6.0f);
                break;
            }
            case SOUTH: {
                rh.setBounds(6.0f, 6.0f, 10.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case UP: {
                rh.setBounds(6.0f, 10.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case WEST: {
                rh.setBounds(0.0f, 6.0f, 6.0f, 6.0f, 10.0f, 10.0f);
                break;
            }
            default: {
                return;
            }
        }
        rh.renderBlock(x, y, z, renderer);
        rh.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
    }

    @SideOnly(value=Side.CLIENT)
    void renderCoveredConnection(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer, int channels, ForgeDirection of) {
        TileEntity te = this.getTile().func_145831_w().func_147438_o(x + of.offsetX, y + of.offsetY, z + of.offsetZ);
        IPartHost partHost = te instanceof IPartHost ? (IPartHost)te : null;
        IGridHost ghh = te instanceof IGridHost ? (IGridHost)te : null;
        rh.setFacesToRender(EnumSet.complementOf(EnumSet.of(of)));
        if (ghh != null && partHost != null && ghh.getCableConnectionType(of.getOpposite()) == AECableType.GLASS && partHost.getPart(of.getOpposite()) == null && partHost.getColor() != AEColor.Transparent) {
            rh.setTexture(this.getGlassTexture(partHost.getColor()));
        } else if (partHost == null && ghh != null && ghh.getCableConnectionType(of.getOpposite()) != AECableType.GLASS) {
            rh.setTexture(this.getCoveredTexture(this.getCableColor()));
            switch (of) {
                case DOWN: {
                    rh.setBounds(5.0f, 0.0f, 5.0f, 11.0f, 4.0f, 11.0f);
                    break;
                }
                case EAST: {
                    rh.setBounds(12.0f, 5.0f, 5.0f, 16.0f, 11.0f, 11.0f);
                    break;
                }
                case NORTH: {
                    rh.setBounds(5.0f, 5.0f, 0.0f, 11.0f, 11.0f, 4.0f);
                    break;
                }
                case SOUTH: {
                    rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 16.0f);
                    break;
                }
                case UP: {
                    rh.setBounds(5.0f, 12.0f, 5.0f, 11.0f, 16.0f, 11.0f);
                    break;
                }
                case WEST: {
                    rh.setBounds(0.0f, 5.0f, 5.0f, 4.0f, 11.0f, 11.0f);
                    break;
                }
                default: {
                    return;
                }
            }
            rh.renderBlock(x, y, z, renderer);
            rh.setTexture(this.getTexture(this.getCableColor()));
        } else if (ghh != null && partHost != null && ghh.getCableConnectionType(of.getOpposite()) == AECableType.COVERED && partHost.getColor() != AEColor.Transparent && partHost.getPart(of.getOpposite()) == null) {
            rh.setTexture(this.getCoveredTexture(partHost.getColor()));
        } else {
            rh.setTexture(this.getCoveredTexture(this.getCableColor()));
        }
        switch (of) {
            case DOWN: {
                rh.setBounds(6.0f, 0.0f, 6.0f, 10.0f, 5.0f, 10.0f);
                break;
            }
            case EAST: {
                rh.setBounds(11.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
                break;
            }
            case NORTH: {
                rh.setBounds(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 5.0f);
                break;
            }
            case SOUTH: {
                rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case UP: {
                rh.setBounds(6.0f, 11.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case WEST: {
                rh.setBounds(0.0f, 6.0f, 6.0f, 5.0f, 10.0f, 10.0f);
                break;
            }
            default: {
                return;
            }
        }
        rh.renderBlock(x, y, z, renderer);
        rh.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
        rh.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
    }

    @SideOnly(value=Side.CLIENT)
    void renderSmartConnection(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer, int channels, ForgeDirection of) {
        TaughtIcon secondIcon;
        TaughtIcon firstIcon;
        TileEntity te = this.getTile().func_145831_w().func_147438_o(x + of.offsetX, y + of.offsetY, z + of.offsetZ);
        IPartHost partHost = te instanceof IPartHost ? (IPartHost)te : null;
        IGridHost ghh = te instanceof IGridHost ? (IGridHost)te : null;
        AEColor myColor = this.getCableColor();
        rh.setFacesToRender(EnumSet.complementOf(EnumSet.of(of)));
        boolean isGlass = false;
        if (ghh != null && partHost != null && ghh.getCableConnectionType(of.getOpposite()) == AECableType.GLASS && partHost.getPart(of.getOpposite()) == null && partHost.getColor() != AEColor.Transparent) {
            isGlass = true;
            myColor = partHost.getColor();
            rh.setTexture(this.getGlassTexture(myColor));
        } else if (partHost == null && ghh != null && ghh.getCableConnectionType(of.getOpposite()) != AECableType.GLASS) {
            rh.setTexture(this.getSmartTexture(myColor));
            switch (of) {
                case DOWN: {
                    rh.setBounds(5.0f, 0.0f, 5.0f, 11.0f, 4.0f, 11.0f);
                    break;
                }
                case EAST: {
                    rh.setBounds(12.0f, 5.0f, 5.0f, 16.0f, 11.0f, 11.0f);
                    break;
                }
                case NORTH: {
                    rh.setBounds(5.0f, 5.0f, 0.0f, 11.0f, 11.0f, 4.0f);
                    break;
                }
                case SOUTH: {
                    rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 16.0f);
                    break;
                }
                case UP: {
                    rh.setBounds(5.0f, 12.0f, 5.0f, 11.0f, 16.0f, 11.0f);
                    break;
                }
                case WEST: {
                    rh.setBounds(0.0f, 5.0f, 5.0f, 4.0f, 11.0f, 11.0f);
                    break;
                }
                default: {
                    return;
                }
            }
            rh.renderBlock(x, y, z, renderer);
            this.setSmartConnectionRotations(of, renderer);
            firstIcon = new TaughtIcon(this.getChannelTex(channels, false).getIcon(), -0.2f);
            secondIcon = new TaughtIcon(this.getChannelTex(channels, true).getIcon(), -0.2f);
            if (of == ForgeDirection.EAST || of == ForgeDirection.WEST) {
                AEBaseBlock blk = (AEBaseBlock)rh.getBlock();
                FlippableIcon ico = blk.getRendererInstance().getTexture(ForgeDirection.EAST);
                ico.setFlip(false, true);
            }
            Tessellator.field_78398_a.func_78380_c(0xF000F0);
            Tessellator.field_78398_a.func_78378_d(myColor.blackVariant);
            rh.setTexture(firstIcon, firstIcon, firstIcon, firstIcon, firstIcon, firstIcon);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            Tessellator.field_78398_a.func_78378_d(myColor.whiteVariant);
            rh.setTexture(secondIcon, secondIcon, secondIcon, secondIcon, secondIcon, secondIcon);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            renderer.field_147873_r = 0;
            renderer.field_147867_u = 0;
            renderer.field_147871_s = 0;
            renderer.field_147869_t = 0;
            renderer.field_147875_q = 0;
            renderer.field_147865_v = 0;
            rh.setTexture(this.getTexture(this.getCableColor()));
        } else if (ghh != null && partHost != null && ghh.getCableConnectionType(of.getOpposite()) != AECableType.GLASS && partHost.getColor() != AEColor.Transparent && partHost.getPart(of.getOpposite()) == null) {
            myColor = partHost.getColor();
            rh.setTexture(this.getSmartTexture(myColor));
        } else {
            rh.setTexture(this.getSmartTexture(this.getCableColor()));
        }
        switch (of) {
            case DOWN: {
                rh.setBounds(6.0f, 0.0f, 6.0f, 10.0f, 5.0f, 10.0f);
                break;
            }
            case EAST: {
                rh.setBounds(11.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
                break;
            }
            case NORTH: {
                rh.setBounds(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 5.0f);
                break;
            }
            case SOUTH: {
                rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case UP: {
                rh.setBounds(6.0f, 11.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case WEST: {
                rh.setBounds(0.0f, 6.0f, 6.0f, 5.0f, 10.0f, 10.0f);
                break;
            }
            default: {
                return;
            }
        }
        rh.renderBlock(x, y, z, renderer);
        rh.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
        if (!isGlass) {
            this.setSmartConnectionRotations(of, renderer);
            firstIcon = new TaughtIcon(this.getChannelTex(channels, false).getIcon(), -0.2f);
            secondIcon = new TaughtIcon(this.getChannelTex(channels, true).getIcon(), -0.2f);
            Tessellator.field_78398_a.func_78380_c(0xF000F0);
            Tessellator.field_78398_a.func_78378_d(myColor.blackVariant);
            rh.setTexture(firstIcon, firstIcon, firstIcon, firstIcon, firstIcon, firstIcon);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            Tessellator.field_78398_a.func_78378_d(myColor.whiteVariant);
            rh.setTexture(secondIcon, secondIcon, secondIcon, secondIcon, secondIcon, secondIcon);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            renderer.field_147873_r = 0;
            renderer.field_147867_u = 0;
            renderer.field_147871_s = 0;
            renderer.field_147869_t = 0;
            renderer.field_147875_q = 0;
            renderer.field_147865_v = 0;
        }
    }

    IIcon getSmartTexture(AEColor c) {
        switch (c) {
            case Black: {
                return CableBusTextures.MESmart_Black.getIcon();
            }
            case Blue: {
                return CableBusTextures.MESmart_Blue.getIcon();
            }
            case Brown: {
                return CableBusTextures.MESmart_Brown.getIcon();
            }
            case Cyan: {
                return CableBusTextures.MESmart_Cyan.getIcon();
            }
            case Gray: {
                return CableBusTextures.MESmart_Gray.getIcon();
            }
            case Green: {
                return CableBusTextures.MESmart_Green.getIcon();
            }
            case LightBlue: {
                return CableBusTextures.MESmart_LightBlue.getIcon();
            }
            case LightGray: {
                return CableBusTextures.MESmart_LightGrey.getIcon();
            }
            case Lime: {
                return CableBusTextures.MESmart_Lime.getIcon();
            }
            case Magenta: {
                return CableBusTextures.MESmart_Magenta.getIcon();
            }
            case Orange: {
                return CableBusTextures.MESmart_Orange.getIcon();
            }
            case Pink: {
                return CableBusTextures.MESmart_Pink.getIcon();
            }
            case Purple: {
                return CableBusTextures.MESmart_Purple.getIcon();
            }
            case Red: {
                return CableBusTextures.MESmart_Red.getIcon();
            }
            case White: {
                return CableBusTextures.MESmart_White.getIcon();
            }
            case Yellow: {
                return CableBusTextures.MESmart_Yellow.getIcon();
            }
        }
        IParts parts = AEApi.instance().definitions().parts();
        ItemStack smartCableStack = parts.cableSmart().stack(AEColor.Transparent, 1);
        return parts.cableCovered().item(AEColor.Transparent).func_77650_f(smartCableStack);
    }

    @SideOnly(value=Side.CLIENT)
    protected void setSmartConnectionRotations(ForgeDirection of, RenderBlocks renderer) {
        switch (of) {
            case DOWN: 
            case UP: {
                renderer.field_147867_u = 0;
                renderer.field_147865_v = 0;
                renderer.field_147871_s = 3;
                renderer.field_147875_q = 3;
                break;
            }
            case NORTH: 
            case SOUTH: {
                renderer.field_147867_u = 3;
                renderer.field_147865_v = 3;
                renderer.field_147869_t = 1;
                renderer.field_147871_s = 2;
                renderer.field_147873_r = 1;
                break;
            }
            case EAST: 
            case WEST: {
                renderer.field_147875_q = 2;
                renderer.field_147873_r = 1;
                renderer.field_147865_v = 2;
                renderer.field_147867_u = 1;
                renderer.field_147871_s = 3;
                renderer.field_147869_t = 0;
                break;
            }
        }
    }

    protected CableBusTextures getChannelTex(int i, boolean b) {
        if (!this.powered) {
            i = 0;
        }
        if (b) {
            switch (i) {
                default: {
                    return CableBusTextures.Channels10;
                }
                case 5: {
                    return CableBusTextures.Channels11;
                }
                case 6: {
                    return CableBusTextures.Channels12;
                }
                case 7: {
                    return CableBusTextures.Channels13;
                }
                case 8: 
            }
            return CableBusTextures.Channels14;
        }
        switch (i) {
            case 0: {
                return CableBusTextures.Channels00;
            }
            case 1: {
                return CableBusTextures.Channels01;
            }
            case 2: {
                return CableBusTextures.Channels02;
            }
            case 3: {
                return CableBusTextures.Channels03;
            }
        }
        return CableBusTextures.Channels04;
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderAllFaces(AEBaseBlock blk, int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setBounds((float)renderer.field_147859_h * 16.0f, (float)renderer.field_147855_j * 16.0f, (float)renderer.field_147851_l * 16.0f, (float)renderer.field_147861_i * 16.0f, (float)renderer.field_147857_k * 16.0f, (float)renderer.field_147853_m * 16.0f);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.WEST), ForgeDirection.WEST, renderer);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.EAST), ForgeDirection.EAST, renderer);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.NORTH), ForgeDirection.NORTH, renderer);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.SOUTH), ForgeDirection.SOUTH, renderer);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.DOWN), ForgeDirection.DOWN, renderer);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.UP), ForgeDirection.UP, renderer);
    }

    int[] getChannelsOnSide() {
        return this.channelsOnSide;
    }

    EnumSet<ForgeDirection> getConnections() {
        return this.connections;
    }

    void setConnections(EnumSet<ForgeDirection> connections) {
        this.connections = connections;
    }
}

