/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.block.crafting.BlockAdvancedCraftingStorage;
import appeng.tile.crafting.TileCraftingTile;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class TileCraftingStorageTile
extends TileCraftingTile {
    private static final int KILO_SCALAR = 1024;

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        IBlocks blocks = AEApi.instance().definitions().blocks();
        int storage = ((TileCraftingTile)obj).getStorageBytes() / 1024;
        switch (storage) {
            case 4: {
                Iterator iterator = blocks.craftingStorage4k().maybeStack(1).asSet().iterator();
                if (!iterator.hasNext()) break;
                ItemStack stack = (ItemStack)iterator.next();
                return stack;
            }
            case 16: {
                Iterator iterator = blocks.craftingStorage16k().maybeStack(1).asSet().iterator();
                if (!iterator.hasNext()) break;
                ItemStack stack = (ItemStack)iterator.next();
                return stack;
            }
            case 64: {
                Iterator iterator = blocks.craftingStorage64k().maybeStack(1).asSet().iterator();
                if (!iterator.hasNext()) break;
                ItemStack stack = (ItemStack)iterator.next();
                return stack;
            }
            case 256: {
                Iterator iterator = blocks.craftingStorage256k().maybeStack(1).asSet().iterator();
                if (!iterator.hasNext()) break;
                ItemStack stack = (ItemStack)iterator.next();
                return stack;
            }
            case 1024: {
                Iterator iterator = blocks.craftingStorage1024k().maybeStack(1).asSet().iterator();
                if (!iterator.hasNext()) break;
                ItemStack stack = (ItemStack)iterator.next();
                return stack;
            }
            case 4096: {
                Iterator iterator = blocks.craftingStorage4096k().maybeStack(1).asSet().iterator();
                if (!iterator.hasNext()) break;
                ItemStack stack = (ItemStack)iterator.next();
                return stack;
            }
            case 16384: {
                Iterator iterator = blocks.craftingStorage16384k().maybeStack(1).asSet().iterator();
                if (!iterator.hasNext()) break;
                ItemStack stack = (ItemStack)iterator.next();
                return stack;
            }
        }
        return super.getItemFromTile(obj);
    }

    @Override
    public boolean isAccelerator() {
        return false;
    }

    @Override
    public boolean isStorage() {
        return true;
    }

    @Override
    public int getStorageBytes() {
        if (this.field_145850_b == null || this.notLoaded()) {
            return 0;
        }
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int blockMultiplier = block instanceof BlockAdvancedCraftingStorage ? 256 : 1;
        switch (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 3) {
            default: {
                return 1024 * blockMultiplier;
            }
            case 1: {
                return 4096 * blockMultiplier;
            }
            case 2: {
                return 16384 * blockMultiplier;
            }
            case 3: 
        }
        return 65536 * blockMultiplier;
    }
}

