/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.calculators;

import appeng.util.calculators.ArithHelper;
import java.util.Collections;
import java.util.Stack;

public class Calculator {
    private final Stack<String> postfixStack = new Stack();
    private final Stack<Character> opStack = new Stack();
    private final int[] operatPriority = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

    public static double conversion(String expression) {
        double result = 0.0;
        if (expression == null) {
            return Double.NaN;
        }
        expression = expression.replace(" ", "");
        Calculator cal = new Calculator();
        if (expression.length() == 1 && Character.isDigit(expression.charAt(0))) {
            return expression.charAt(0) - 48;
        }
        try {
            expression = Calculator.transform(expression);
            result = cal.calculate(expression);
        }
        catch (Exception e) {
            return Double.NaN;
        }
        return result;
    }

    private static String transform(String expression) {
        char[] arr = expression.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != '-') continue;
            if (i == 0) {
                arr[i] = 126;
                continue;
            }
            char c = arr[i - 1];
            if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(' && c != 'E' && c != 'e') continue;
            arr[i] = 126;
        }
        if (arr[0] == '~' || arr[1] == '(') {
            arr[0] = 45;
            return "0" + new String(arr);
        }
        return new String(arr);
    }

    public double calculate(String expression) {
        Stack<String> resultStack = new Stack<String>();
        this.prepare(expression);
        Collections.reverse(this.postfixStack);
        while (!this.postfixStack.isEmpty()) {
            String currentValue = this.postfixStack.pop();
            if (!Calculator.isOperator(currentValue.charAt(0))) {
                currentValue = currentValue.replace("~", "-");
                resultStack.push(currentValue);
                continue;
            }
            String secondValue = (String)resultStack.pop();
            String firstValue = (String)resultStack.pop();
            firstValue = firstValue.replace("~", "-");
            secondValue = secondValue.replace("~", "-");
            String tempResult = this.calculate(firstValue, secondValue, currentValue.charAt(0));
            resultStack.push(String.valueOf(tempResult));
        }
        return Double.parseDouble((String)resultStack.pop());
    }

    private void prepare(String expression) {
        this.opStack.push(Character.valueOf(','));
        char[] arr = expression.toCharArray();
        int currentIndex = 0;
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            char currentOp = arr[i];
            if (Calculator.isOperator(currentOp)) {
                if (count > 0) {
                    this.postfixStack.push(new String(arr, currentIndex, count));
                }
                char peekOp = this.opStack.peek().charValue();
                if (currentOp == ')') {
                    while (this.opStack.peek().charValue() != '(') {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                    }
                    this.opStack.pop();
                } else {
                    while (currentOp != '(' && peekOp != ',' && this.compare(currentOp, peekOp)) {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                        peekOp = this.opStack.peek().charValue();
                    }
                    this.opStack.push(Character.valueOf(currentOp));
                }
                count = 0;
                currentIndex = i + 1;
                continue;
            }
            ++count;
        }
        if (count > 1 || count == 1 && !Calculator.isOperator(arr[currentIndex])) {
            this.postfixStack.push(new String(arr, currentIndex, count));
        }
        while (this.opStack.peek().charValue() != ',') {
            this.postfixStack.push(String.valueOf(this.opStack.pop()));
        }
    }

    public static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '(' || c == ')';
    }

    public boolean compare(char cur, char peek) {
        boolean result = false;
        if (this.operatPriority[peek - 40] >= this.operatPriority[cur - 40]) {
            result = true;
        }
        return result;
    }

    private String calculate(String firstValue, String secondValue, char currentOp) {
        String result = "";
        switch (currentOp) {
            case '+': {
                result = ArithHelper.add(firstValue, secondValue);
                break;
            }
            case '-': {
                result = ArithHelper.sub(firstValue, secondValue);
                break;
            }
            case '*': {
                result = ArithHelper.mul(firstValue, secondValue);
                break;
            }
            case '/': {
                result = ArithHelper.div(firstValue, secondValue);
            }
        }
        return result;
    }
}

