/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerCellWorkbench;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.container.implementations.ContainerLevelEmitter;
import appeng.container.implementations.ContainerNetworkTool;
import appeng.container.implementations.ContainerOreFilter;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.implementations.ContainerPatternTermEx;
import appeng.container.implementations.ContainerPriority;
import appeng.container.implementations.ContainerQuartzKnife;
import appeng.container.implementations.ContainerRenamer;
import appeng.container.implementations.ContainerSecurity;
import appeng.container.implementations.ContainerStorageBus;
import appeng.container.interfaces.ICraftingCPUSelectorContainer;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.IMouseWheelItem;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class PacketValueConfig
extends AppEngPacket {
    private final String Name;
    private final String Value;

    public PacketValueConfig(ByteBuf stream) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(stream.array(), stream.readerIndex(), stream.readableBytes()));
        this.Name = dis.readUTF();
        this.Value = dis.readUTF();
    }

    public PacketValueConfig(String name, String value) throws IOException {
        this.Name = name;
        this.Value = value;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeUTF(name);
        dos.writeUTF(value);
        data.writeBytes(bos.toByteArray());
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        block53: {
            Container c;
            block69: {
                block67: {
                    ContainerCellWorkbench ccw;
                    block68: {
                        block65: {
                            ContainerStorageBus ccw2;
                            block66: {
                                block64: {
                                    block63: {
                                        block62: {
                                            block61: {
                                                block60: {
                                                    block59: {
                                                        block58: {
                                                            block57: {
                                                                block56: {
                                                                    block55: {
                                                                        block54: {
                                                                            block52: {
                                                                                c = player.field_71070_bA;
                                                                                if (!this.Name.equals("Item") || player.func_70694_bm() == null || !(player.func_70694_bm().func_77973_b() instanceof IMouseWheelItem)) break block52;
                                                                                ItemStack is = player.func_70694_bm();
                                                                                IMouseWheelItem si = (IMouseWheelItem)is.func_77973_b();
                                                                                si.onWheel(is, this.Value.equals("WheelUp"));
                                                                                break block53;
                                                                            }
                                                                            if (!this.Name.equals("CPUTable.Cpu.Set") || !(c instanceof ICraftingCPUSelectorContainer)) break block54;
                                                                            ICraftingCPUSelectorContainer qk = (ICraftingCPUSelectorContainer)c;
                                                                            qk.selectCPU(Integer.parseInt(this.Value));
                                                                            break block53;
                                                                        }
                                                                        if (!this.Name.equals("Terminal.Start") || !(c instanceof ContainerCraftConfirm)) break block55;
                                                                        ContainerCraftConfirm qk = (ContainerCraftConfirm)c;
                                                                        qk.startJob();
                                                                        break block53;
                                                                    }
                                                                    if (!this.Name.equals("TileCrafting.Cancel") || !(c instanceof ContainerCraftingCPU)) break block56;
                                                                    ContainerCraftingCPU qk = (ContainerCraftingCPU)c;
                                                                    qk.cancelCrafting();
                                                                    break block53;
                                                                }
                                                                if (!this.Name.equals("QuartzKnife.Name") || !(c instanceof ContainerQuartzKnife)) break block57;
                                                                ContainerQuartzKnife qk = (ContainerQuartzKnife)c;
                                                                qk.setName(this.Value);
                                                                break block53;
                                                            }
                                                            if (!this.Name.equals("QuartzKnife.ReName") || !(c instanceof ContainerRenamer)) break block58;
                                                            ContainerRenamer qk = (ContainerRenamer)c;
                                                            qk.setNewName(this.Value);
                                                            break block53;
                                                        }
                                                        if (!this.Name.equals("TileSecurity.ToggleOption") || !(c instanceof ContainerSecurity)) break block59;
                                                        ContainerSecurity sc = (ContainerSecurity)c;
                                                        sc.toggleSetting(this.Value, player);
                                                        break block53;
                                                    }
                                                    if (!this.Name.equals("PriorityHost.Priority") || !(c instanceof ContainerPriority)) break block60;
                                                    ContainerPriority pc = (ContainerPriority)c;
                                                    pc.setPriority(Integer.parseInt(this.Value), player);
                                                    break block53;
                                                }
                                                if (!this.Name.equals("OreFilter") || !(c instanceof ContainerOreFilter)) break block61;
                                                ContainerOreFilter fc = (ContainerOreFilter)c;
                                                fc.setFilter(this.Value);
                                                break block53;
                                            }
                                            if (!this.Name.equals("LevelEmitter.Value") || !(c instanceof ContainerLevelEmitter)) break block62;
                                            ContainerLevelEmitter lvc = (ContainerLevelEmitter)c;
                                            lvc.setLevel(Long.parseLong(this.Value), player);
                                            break block53;
                                        }
                                        if (!this.Name.startsWith("PatternTerminal.") || !(c instanceof ContainerPatternTerm)) break block63;
                                        ContainerPatternTerm cpt = (ContainerPatternTerm)c;
                                        switch (this.Name) {
                                            case "PatternTerminal.CraftMode": {
                                                cpt.getPatternTerminal().setCraftingRecipe(this.Value.equals("1"));
                                                break;
                                            }
                                            case "PatternTerminal.Encode": {
                                                if (this.Value.equals("2")) {
                                                    cpt.encodeAndMoveToInventory(false);
                                                    break;
                                                }
                                                if (this.Value.equals("6")) {
                                                    cpt.encodeAndMoveToInventory(true);
                                                    break;
                                                }
                                                cpt.encode();
                                                break;
                                            }
                                            case "PatternTerminal.Clear": {
                                                cpt.clear();
                                                break;
                                            }
                                            case "PatternTerminal.Substitute": {
                                                cpt.getPatternTerminal().setSubstitution(this.Value.equals("1"));
                                                break;
                                            }
                                            case "PatternTerminal.BeSubstitute": {
                                                cpt.getPatternTerminal().setCanBeSubstitution(this.Value.equals("1"));
                                                break;
                                            }
                                            case "PatternTerminal.Double": {
                                                cpt.doubleStacks(this.Value.equals("1"));
                                            }
                                        }
                                        break block53;
                                    }
                                    if (!this.Name.startsWith("PatternTerminalEx.") || !(c instanceof ContainerPatternTermEx)) break block64;
                                    ContainerPatternTermEx cpt = (ContainerPatternTermEx)c;
                                    switch (this.Name) {
                                        case "PatternTerminalEx.Encode": {
                                            if (this.Value.equals("2")) {
                                                cpt.encodeAndMoveToInventory(false);
                                                break;
                                            }
                                            if (this.Value.equals("6")) {
                                                cpt.encodeAndMoveToInventory(true);
                                                break;
                                            }
                                            cpt.encode();
                                            break;
                                        }
                                        case "PatternTerminalEx.Clear": {
                                            cpt.clear();
                                            break;
                                        }
                                        case "PatternTerminalEx.Substitute": {
                                            cpt.getPatternTerminal().setSubstitution(this.Value.equals("1"));
                                            break;
                                        }
                                        case "PatternTerminalEx.BeSubstitute": {
                                            cpt.getPatternTerminal().setCanBeSubstitution(this.Value.equals("1"));
                                            break;
                                        }
                                        case "PatternTerminalEx.Invert": {
                                            cpt.getPatternTerminal().setInverted(this.Value.equals("1"));
                                            break;
                                        }
                                        case "PatternTerminalEx.Double": {
                                            cpt.doubleStacks(this.Value.equals("1"));
                                            break;
                                        }
                                        case "PatternTerminalEx.ActivePage": {
                                            cpt.getPatternTerminal().setActivePage(Integer.parseInt(this.Value));
                                        }
                                    }
                                    break block53;
                                }
                                if (!this.Name.startsWith("StorageBus.") || !(c instanceof ContainerStorageBus)) break block65;
                                ccw2 = (ContainerStorageBus)c;
                                if (!this.Name.equals("StorageBus.Action")) break block53;
                                if (!this.Value.equals("Partition")) break block66;
                                ccw2.partition();
                                break block53;
                            }
                            if (!this.Value.equals("Clear")) break block53;
                            ccw2.clear();
                            break block53;
                        }
                        if (!this.Name.startsWith("CellWorkbench.") || !(c instanceof ContainerCellWorkbench)) break block67;
                        ccw = (ContainerCellWorkbench)c;
                        if (!this.Name.equals("CellWorkbench.Action")) break block68;
                        switch (this.Value) {
                            case "CopyMode": {
                                ccw.nextWorkBenchCopyMode();
                                break;
                            }
                            case "Partition": {
                                ccw.partition();
                                break;
                            }
                            case "Clear": {
                                ccw.clear();
                            }
                        }
                        break block53;
                    }
                    if (!this.Name.equals("CellWorkbench.Fuzzy")) break block53;
                    ccw.setFuzzy(FuzzyMode.valueOf(this.Value));
                    break block53;
                }
                if (!(c instanceof ContainerNetworkTool)) break block69;
                if (!this.Name.equals("NetworkTool") || !this.Value.equals("Toggle")) break block53;
                ((ContainerNetworkTool)c).toggleFacadeMode();
                break block53;
            }
            if (c instanceof IConfigurableObject) {
                IConfigManager cm = ((IConfigurableObject)c).getConfigManager();
                for (Settings e : cm.getSettings()) {
                    if (!e.name().equals(this.Name)) continue;
                    Enum<?> def = cm.getSetting(e);
                    try {
                        cm.putSetting(e, (Enum<?>)Enum.valueOf(def.getClass(), this.Value));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
            }
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        block5: {
            Container c;
            block7: {
                block6: {
                    block4: {
                        c = player.field_71070_bA;
                        if (!this.Name.equals("CustomName") || !(c instanceof AEBaseContainer)) break block4;
                        ((AEBaseContainer)c).setCustomName(this.Value);
                        break block5;
                    }
                    if (!this.Name.startsWith("SyncDat.")) break block6;
                    ((AEBaseContainer)c).stringSync(Integer.parseInt(this.Name.substring(8)), this.Value);
                    break block5;
                }
                if (!this.Name.equals("CraftingStatus") || !this.Value.equals("Clear")) break block7;
                GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
                if (!(gs instanceof GuiCraftingCPU)) break block5;
                ((GuiCraftingCPU)gs).clearItems();
                break block5;
            }
            if (c instanceof IConfigurableObject) {
                IConfigManager cm = ((IConfigurableObject)c).getConfigManager();
                for (Settings e : cm.getSettings()) {
                    if (!e.name().equals(this.Name)) continue;
                    Enum<?> def = cm.getSetting(e);
                    try {
                        cm.putSetting(e, (Enum<?>)Enum.valueOf(def.getClass(), this.Value));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
            }
        }
    }
}

