/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.client.gui.widgets.GuiCraftingCPUTable;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.client.gui.widgets.ICraftingCPUTableHolder;
import appeng.container.implementations.ContainerCraftingStatus;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartPatternTerminalEx;
import appeng.parts.reporting.PartTerminal;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

public class GuiCraftingStatus
extends GuiCraftingCPU
implements ICraftingCPUTableHolder {
    private final ContainerCraftingStatus status = (ContainerCraftingStatus)this.field_147002_h;
    private GuiButton selectCPU;
    private final GuiCraftingCPUTable cpuTable;
    private GuiTabButton originalGuiBtn;
    private GuiBridge originalGui;
    private ItemStack myIcon = null;
    private boolean tallMode = AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) == TerminalStyle.TALL;
    private GuiImgButton switchTallMode;

    public GuiCraftingStatus(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerCraftingStatus(inventoryPlayer, te));
        ItemStack stack;
        Iterator iterator;
        this.recalculateScreenSize();
        Object target = this.status.getTarget();
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        this.cpuTable = new GuiCraftingCPUTable(this, this.status.getCPUTable());
        if (target instanceof WirelessTerminalGuiObject) {
            iterator = definitions.items().wirelessTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                ItemStack wirelessTerminalStack;
                this.myIcon = wirelessTerminalStack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_WIRELESS_TERM;
        }
        if (target instanceof PartTerminal) {
            iterator = parts.terminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_ME;
        }
        if (target instanceof PartCraftingTerminal) {
            iterator = parts.craftingTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        if (target instanceof PartPatternTerminal) {
            iterator = parts.patternTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
        if (target instanceof PartPatternTerminalEx) {
            iterator = parts.patternTerminalEx().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL_EX;
        }
    }

    @Override
    public GuiCraftingCPUTable getCPUTable() {
        return this.cpuTable;
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.selectCPU) {
            this.cpuTable.cycleCPU(backwards);
        } else if (btn == this.originalGuiBtn) {
            NetworkHandler.instance.sendToServer(new PacketSwitchGuis(this.originalGui));
        } else if (btn == this.switchTallMode) {
            this.tallMode = !this.tallMode;
            this.switchTallMode.set(this.tallMode ? TerminalStyle.TALL : TerminalStyle.SMALL);
            this.recalculateScreenSize();
            this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
    }

    @Override
    public void func_73866_w_() {
        this.recalculateScreenSize();
        super.func_73866_w_();
        this.setScrollBar();
        this.selectCPU = new GuiButton(0, this.field_147003_i + 8, this.field_147009_r + this.field_147000_g - 25, 150, 20, GuiText.CraftingCPU.getLocal() + ": " + (Object)((Object)GuiText.NoCraftingCPUs));
        this.field_146292_n.add(this.selectCPU);
        if (this.myIcon != null) {
            this.originalGuiBtn = new GuiTabButton(this.field_147003_i + 213, this.field_147009_r - 4, this.myIcon, this.myIcon.func_82833_r(), field_146296_j);
            this.field_146292_n.add(this.originalGuiBtn);
            this.originalGuiBtn.setHideEdge(13);
        }
        this.switchTallMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 166, Settings.TERMINAL_STYLE, this.tallMode ? TerminalStyle.TALL : TerminalStyle.SMALL);
        this.field_146292_n.add(this.switchTallMode);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float btn) {
        this.cpuTable.drawScreen();
        this.updateCPUButtonText();
        super.func_73863_a(mouseX, mouseY, btn);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawFG(offsetX, offsetY, mouseX, mouseY);
        this.cpuTable.drawFG(offsetX, offsetY, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/craftingcpu.png");
        if (this.tallMode) {
            this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, 41);
            int y = 41;
            for (int row = 1; row < this.rows - 1; ++row) {
                this.func_73729_b(offsetX, offsetY + y, 0, 41, this.field_146999_f, 23);
                y += 23;
            }
            this.func_73729_b(offsetX, offsetY + y, 0, 133, this.field_146999_f, 51);
        } else {
            this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        this.cpuTable.drawBG(offsetX, offsetY);
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        super.func_73864_a(xCoord, yCoord, btn);
        this.cpuTable.mouseClicked(xCoord - this.field_147003_i, yCoord - this.field_147009_r, btn);
    }

    @Override
    protected void func_146273_a(int x, int y, int c, long d) {
        super.func_146273_a(x, y, c, d);
        this.cpuTable.mouseClickMove(x - this.field_147003_i, y - this.field_147009_r);
    }

    @Override
    public void func_146274_d() {
        if (this.cpuTable.handleMouseInput(this.field_147003_i, this.field_147009_r)) {
            return;
        }
        super.func_146274_d();
    }

    public boolean hideItemPanelSlot(int x, int y, int w, int h) {
        return this.cpuTable.hideItemPanelSlot(x - this.field_147003_i, y - this.field_147009_r, w, h);
    }

    private void updateCPUButtonText() {
        String btnTextText = GuiText.NoCraftingJobs.getLocal();
        int selectedSerial = this.cpuTable.getContainer().selectedCpuSerial;
        if (selectedSerial >= 0) {
            String selectedCPUName = this.cpuTable.getSelectedCPUName();
            if (selectedCPUName != null && selectedCPUName.length() > 0) {
                String name = selectedCPUName.substring(0, Math.min(20, selectedCPUName.length()));
                btnTextText = GuiText.CPUs.getLocal() + ": " + name;
            } else {
                btnTextText = GuiText.CPUs.getLocal() + ": #" + selectedSerial;
            }
        }
        if (this.status.getCPUs().isEmpty()) {
            btnTextText = GuiText.NoCraftingJobs.getLocal();
        }
        this.selectCPU.field_146126_j = btnTextText;
    }

    @Override
    protected String getGuiDisplayName(String in) {
        return in;
    }

    protected void recalculateScreenSize() {
        int maxAvailableHeight = this.field_146295_m - 64;
        this.field_146999_f = 238;
        if (this.tallMode) {
            this.rows = (maxAvailableHeight - 42) / 23;
            this.field_147000_g = 47 + this.rows * 23;
        } else {
            this.rows = 6;
            this.field_147000_g = 184;
        }
    }

    private void setScrollBar() {
        int size = this.visual.size();
        this.getScrollBar().setTop(19).setLeft(218).setHeight(this.field_147000_g - 47);
        this.getScrollBar().setRange(0, (size + 2) / 3 - this.rows, 1);
    }

    @Override
    public void postUpdate(List<IAEItemStack> list, byte ref) {
        super.postUpdate(list, ref);
        this.setScrollBar();
    }
}

