/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellCacheRegistry;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.me.cache.NetworkMonitor;
import appeng.me.cache.SecurityCache;
import appeng.me.helpers.GenericInterestManager;
import appeng.me.storage.DriveWatcher;
import appeng.me.storage.ItemWatcher;
import appeng.me.storage.NetworkInventoryHandler;
import appeng.tile.storage.TileChest;
import appeng.tile.storage.TileDrive;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class GridStorageCache
implements IStorageGrid {
    private final IGrid myGrid;
    private final HashSet<ICellProvider> activeCellProviders = new HashSet();
    private final HashSet<ICellProvider> inactiveCellProviders = new HashSet();
    private final SetMultimap<IAEStack, ItemWatcher> interests = HashMultimap.create();
    private final GenericInterestManager<ItemWatcher> interestManager = new GenericInterestManager<ItemWatcher>((Multimap<IAEStack, ItemWatcher>)this.interests);
    private final NetworkMonitor<IAEItemStack> itemMonitor = new NetworkMonitor(this, StorageChannel.ITEMS);
    private final NetworkMonitor<IAEFluidStack> fluidMonitor = new NetworkMonitor(this, StorageChannel.FLUIDS);
    private final HashMap<IGridNode, IStackWatcher> watchers = new HashMap();
    private NetworkInventoryHandler<IAEItemStack> myItemNetwork;
    private NetworkInventoryHandler<IAEFluidStack> myFluidNetwork;
    private double itemBytesTotal;
    private double itemBytesUsed;
    private long itemTypesTotal;
    private long itemTypesUsed;
    private long itemCellG;
    private long itemCellO;
    private long itemCellR;
    private long itemCellCount;
    private double fluidBytesTotal;
    private double fluidBytesUsed;
    private long fluidTypesTotal;
    private long fluidTypesUsed;
    private long fluidCellG;
    private long fluidCellO;
    private long fluidCellR;
    private long fluidCellCount;
    private double essentiaBytesTotal;
    private double essentiaBytesUsed;
    private long essentiaTypesTotal;
    private long essentiaTypesUsed;
    private long essentiaCellG;
    private long essentiaCellO;
    private long essentiaCellR;
    private long essentiaCellCount;
    private int ticksCount;
    private int networkBytesUpdateFrequency;
    private static final int CELL_RED = 3;
    private static final int CELL_ORANGE = 2;
    private static final int CELL_GREEN = 1;

    public GridStorageCache(IGrid g) {
        this.myGrid = g;
        this.ticksCount = this.networkBytesUpdateFrequency = (int)(AEConfig.instance.networkBytesUpdateFrequency * 20.0);
    }

    @Override
    public void onUpdateTick() {
        this.itemMonitor.onTick();
        this.fluidMonitor.onTick();
        if (this.ticksCount < this.networkBytesUpdateFrequency) {
            ++this.ticksCount;
        } else {
            this.ticksCount = 0;
            this.updateBytesInfo();
        }
    }

    @Override
    public void removeNode(IGridNode node, IGridHost machine) {
        IStackWatcher myWatcher;
        if (machine instanceof ICellContainer) {
            ICellContainer cc = (ICellContainer)machine;
            CellChangeTracker tracker = new CellChangeTracker();
            this.removeCellProvider(cc, tracker);
            this.inactiveCellProviders.remove(cc);
            this.getGrid().postEvent(new MENetworkCellArrayUpdate());
            tracker.applyChanges();
        }
        if (machine instanceof IStackWatcherHost && (myWatcher = this.watchers.get(machine)) != null) {
            myWatcher.clear();
            this.watchers.remove(machine);
        }
    }

    @Override
    public void addNode(IGridNode node, IGridHost machine) {
        if (machine instanceof ICellContainer) {
            ICellContainer cc = (ICellContainer)machine;
            this.inactiveCellProviders.add(cc);
            this.getGrid().postEvent(new MENetworkCellArrayUpdate());
            if (node.isActive()) {
                CellChangeTracker tracker = new CellChangeTracker();
                this.addCellProvider(cc, tracker);
                tracker.applyChanges();
            }
        }
        if (machine instanceof IStackWatcherHost) {
            IStackWatcherHost swh = (IStackWatcherHost)((Object)machine);
            ItemWatcher iw = new ItemWatcher(this, swh);
            this.watchers.put(node, iw);
            swh.updateWatcher(iw);
        }
    }

    @Override
    public void onSplit(IGridStorage storageB) {
    }

    @Override
    public void onJoin(IGridStorage storageB) {
    }

    @Override
    public void populateGridStorage(IGridStorage storage) {
    }

    private CellChangeTracker addCellProvider(ICellProvider cc, CellChangeTracker tracker) {
        if (this.inactiveCellProviders.contains(cc)) {
            this.inactiveCellProviders.remove(cc);
            this.activeCellProviders.add(cc);
            BaseActionSource actionSrc = new BaseActionSource();
            if (cc instanceof IActionHost) {
                actionSrc = new MachineSource((IActionHost)((Object)cc));
            }
            for (IMEInventoryHandler h : cc.getCellArray(StorageChannel.ITEMS)) {
                tracker.postChanges(StorageChannel.ITEMS, 1, h, actionSrc);
            }
            for (IMEInventoryHandler h : cc.getCellArray(StorageChannel.FLUIDS)) {
                tracker.postChanges(StorageChannel.FLUIDS, 1, h, actionSrc);
            }
        }
        return tracker;
    }

    private CellChangeTracker removeCellProvider(ICellProvider cc, CellChangeTracker tracker) {
        if (this.activeCellProviders.contains(cc)) {
            this.activeCellProviders.remove(cc);
            this.inactiveCellProviders.add(cc);
            BaseActionSource actionSrc = new BaseActionSource();
            if (cc instanceof IActionHost) {
                actionSrc = new MachineSource((IActionHost)((Object)cc));
            }
            for (IMEInventoryHandler h : cc.getCellArray(StorageChannel.ITEMS)) {
                tracker.postChanges(StorageChannel.ITEMS, -1, h, actionSrc);
            }
            for (IMEInventoryHandler h : cc.getCellArray(StorageChannel.FLUIDS)) {
                tracker.postChanges(StorageChannel.FLUIDS, -1, h, actionSrc);
            }
        }
        return tracker;
    }

    @MENetworkEventSubscribe
    public void cellUpdate(MENetworkCellArrayUpdate ev) {
        this.myItemNetwork = null;
        this.myFluidNetwork = null;
        LinkedList<ICellProvider> ll = new LinkedList<ICellProvider>();
        ll.addAll(this.inactiveCellProviders);
        ll.addAll(this.activeCellProviders);
        CellChangeTracker tracker = new CellChangeTracker();
        for (ICellProvider cc : ll) {
            boolean active = true;
            if (cc instanceof IActionHost) {
                IGridNode node = ((IActionHost)((Object)cc)).getActionableNode();
                boolean bl = active = node != null && node.isActive();
            }
            if (active) {
                this.addCellProvider(cc, tracker);
                continue;
            }
            this.removeCellProvider(cc, tracker);
        }
        this.itemMonitor.forceUpdate();
        this.fluidMonitor.forceUpdate();
        tracker.applyChanges();
    }

    private void postChangesToNetwork(StorageChannel chan, int upOrDown, IItemList availableItems, BaseActionSource src) {
        switch (chan) {
            case FLUIDS: {
                this.fluidMonitor.postChange(upOrDown > 0, availableItems, src);
                break;
            }
            case ITEMS: {
                this.itemMonitor.postChange(upOrDown > 0, availableItems, src);
                break;
            }
        }
    }

    IMEInventoryHandler<IAEItemStack> getItemInventoryHandler() {
        if (this.myItemNetwork == null) {
            this.buildNetworkStorage(StorageChannel.ITEMS);
        }
        return this.myItemNetwork;
    }

    private void buildNetworkStorage(StorageChannel chan) {
        SecurityCache security = (SecurityCache)this.getGrid().getCache(ISecurityGrid.class);
        switch (chan) {
            case FLUIDS: {
                this.myFluidNetwork = new NetworkInventoryHandler(StorageChannel.FLUIDS, security);
                for (ICellProvider cc : this.activeCellProviders) {
                    for (IMEInventoryHandler h : cc.getCellArray(chan)) {
                        this.myFluidNetwork.addNewStorage(h);
                    }
                }
                break;
            }
            case ITEMS: {
                this.myItemNetwork = new NetworkInventoryHandler(StorageChannel.ITEMS, security);
                for (ICellProvider cc : this.activeCellProviders) {
                    for (IMEInventoryHandler h : cc.getCellArray(chan)) {
                        this.myItemNetwork.addNewStorage(h);
                    }
                }
                break;
            }
        }
    }

    IMEInventoryHandler<IAEFluidStack> getFluidInventoryHandler() {
        if (this.myFluidNetwork == null) {
            this.buildNetworkStorage(StorageChannel.FLUIDS);
        }
        return this.myFluidNetwork;
    }

    @Override
    public void postAlterationOfStoredItems(StorageChannel chan, Iterable<? extends IAEStack> input, BaseActionSource src) {
        if (chan == StorageChannel.ITEMS) {
            this.itemMonitor.postChange(true, input, src);
        } else if (chan == StorageChannel.FLUIDS) {
            this.fluidMonitor.postChange(true, input, src);
        }
    }

    @Override
    public void registerCellProvider(ICellProvider provider) {
        this.inactiveCellProviders.add(provider);
        this.addCellProvider(provider, new CellChangeTracker()).applyChanges();
    }

    @Override
    public void unregisterCellProvider(ICellProvider provider) {
        this.removeCellProvider(provider, new CellChangeTracker()).applyChanges();
        this.inactiveCellProviders.remove(provider);
    }

    @Override
    public IMEMonitor<IAEItemStack> getItemInventory() {
        return this.itemMonitor;
    }

    @Override
    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return this.fluidMonitor;
    }

    public GenericInterestManager<ItemWatcher> getInterestManager() {
        return this.interestManager;
    }

    IGrid getGrid() {
        return this.myGrid;
    }

    private void updateBytesInfo() {
        this.resetCellInfo();
        try {
            for (ICellProvider icp : this.activeCellProviders) {
                ICellCacheRegistry iccr;
                TileChest tc;
                if (icp instanceof TileDrive) {
                    ICellCacheRegistry iccr2;
                    IMEInventory iMEInventory;
                    for (IMEInventoryHandler meih : icp.getCellArray(StorageChannel.ITEMS)) {
                        iMEInventory = ((DriveWatcher)meih).getInternal();
                        if (!(iMEInventory instanceof ICellCacheRegistry) || !(iccr2 = (ICellCacheRegistry)((Object)iMEInventory)).canGetInv()) continue;
                        this.itemBytesTotal += (double)iccr2.getTotalBytes();
                        this.itemBytesUsed += (double)iccr2.getUsedBytes();
                        switch (iccr2.getCellStatus()) {
                            case 1: {
                                ++this.itemCellG;
                                break;
                            }
                            case 2: {
                                ++this.itemCellO;
                                break;
                            }
                            case 3: {
                                ++this.itemCellR;
                            }
                        }
                        this.itemTypesTotal += iccr2.getTotalTypes();
                        this.itemTypesUsed += iccr2.getUsedTypes();
                        ++this.itemCellCount;
                    }
                    for (IMEInventoryHandler meih : icp.getCellArray(StorageChannel.FLUIDS)) {
                        iMEInventory = ((DriveWatcher)meih).getInternal();
                        if (!(iMEInventory instanceof ICellCacheRegistry) || !(iccr2 = (ICellCacheRegistry)((Object)iMEInventory)).canGetInv()) continue;
                        if (iccr2.getCellType() == ICellCacheRegistry.TYPE.FLUID) {
                            this.fluidBytesTotal += (double)iccr2.getTotalBytes();
                            this.fluidBytesUsed += (double)iccr2.getUsedBytes();
                            switch (iccr2.getCellStatus()) {
                                case 1: {
                                    ++this.fluidCellG;
                                    break;
                                }
                                case 2: {
                                    ++this.fluidCellO;
                                    break;
                                }
                                case 3: {
                                    ++this.fluidCellR;
                                }
                            }
                            this.fluidTypesTotal += iccr2.getTotalTypes();
                            this.fluidTypesUsed += iccr2.getUsedTypes();
                            ++this.fluidCellCount;
                            continue;
                        }
                        if (iccr2.getCellType() != ICellCacheRegistry.TYPE.ESSENTIA) continue;
                        this.essentiaBytesTotal += (double)iccr2.getTotalBytes();
                        this.essentiaBytesUsed += (double)iccr2.getUsedBytes();
                        switch (iccr2.getCellStatus()) {
                            case 1: {
                                ++this.essentiaCellG;
                                break;
                            }
                            case 2: {
                                ++this.essentiaCellO;
                                break;
                            }
                            case 3: {
                                ++this.essentiaCellR;
                            }
                        }
                        this.essentiaTypesTotal += iccr2.getTotalTypes();
                        this.essentiaTypesUsed += iccr2.getUsedTypes();
                        ++this.essentiaCellCount;
                    }
                    continue;
                }
                if (!(icp instanceof TileChest) || (tc = (TileChest)icp).func_70301_a(1) == null) continue;
                IMEInventoryHandler handler = tc.getInternalHandler(StorageChannel.ITEMS);
                if (handler != null) {
                    if (!(handler instanceof ICellCacheRegistry) || !(iccr = (ICellCacheRegistry)((Object)handler)).canGetInv()) continue;
                    this.itemBytesTotal += (double)iccr.getTotalBytes();
                    this.itemBytesUsed += (double)iccr.getUsedBytes();
                    switch (iccr.getCellStatus()) {
                        case 1: {
                            ++this.itemCellG;
                            break;
                        }
                        case 2: {
                            ++this.itemCellO;
                            break;
                        }
                        case 3: {
                            ++this.itemCellR;
                        }
                    }
                    this.itemTypesTotal += iccr.getTotalTypes();
                    this.itemTypesUsed += iccr.getUsedTypes();
                    ++this.itemCellCount;
                    continue;
                }
                handler = tc.getInternalHandler(StorageChannel.FLUIDS);
                if (!(handler instanceof ICellCacheRegistry) || !(iccr = (ICellCacheRegistry)((Object)handler)).canGetInv()) continue;
                if (iccr.getCellType() == ICellCacheRegistry.TYPE.FLUID) {
                    this.fluidBytesTotal += (double)iccr.getTotalBytes();
                    this.fluidBytesUsed += (double)iccr.getUsedBytes();
                    switch (iccr.getCellStatus()) {
                        case 1: {
                            ++this.fluidCellG;
                            break;
                        }
                        case 2: {
                            ++this.fluidCellO;
                            break;
                        }
                        case 3: {
                            ++this.fluidCellR;
                        }
                    }
                    this.fluidTypesTotal += iccr.getTotalTypes();
                    this.fluidTypesUsed += iccr.getUsedTypes();
                    ++this.fluidCellCount;
                    continue;
                }
                if (iccr.getCellType() != ICellCacheRegistry.TYPE.ESSENTIA) continue;
                this.essentiaBytesTotal += (double)iccr.getTotalBytes();
                this.essentiaBytesUsed += (double)iccr.getUsedBytes();
                switch (iccr.getCellStatus()) {
                    case 1: {
                        ++this.essentiaCellG;
                        break;
                    }
                    case 2: {
                        ++this.essentiaCellO;
                        break;
                    }
                    case 3: {
                        ++this.essentiaCellR;
                    }
                }
                this.essentiaTypesTotal += iccr.getTotalTypes();
                this.essentiaTypesUsed += iccr.getUsedTypes();
                ++this.essentiaCellCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resetCellInfo() {
        this.itemBytesTotal = 0.0;
        this.itemBytesUsed = 0.0;
        this.itemTypesTotal = 0L;
        this.itemTypesUsed = 0L;
        this.itemCellG = 0L;
        this.itemCellO = 0L;
        this.itemCellR = 0L;
        this.itemCellCount = 0L;
        this.fluidBytesTotal = 0.0;
        this.fluidBytesUsed = 0.0;
        this.fluidTypesTotal = 0L;
        this.fluidTypesUsed = 0L;
        this.fluidCellG = 0L;
        this.fluidCellO = 0L;
        this.fluidCellR = 0L;
        this.fluidCellCount = 0L;
        this.essentiaBytesTotal = 0.0;
        this.essentiaBytesUsed = 0.0;
        this.essentiaTypesTotal = 0L;
        this.essentiaTypesUsed = 0L;
        this.essentiaCellG = 0L;
        this.essentiaCellO = 0L;
        this.essentiaCellR = 0L;
        this.essentiaCellCount = 0L;
    }

    public double getItemBytesTotal() {
        return this.itemBytesTotal;
    }

    public double getItemBytesUsed() {
        return this.itemBytesUsed;
    }

    public long getItemTypesTotal() {
        return this.itemTypesTotal;
    }

    public long getItemTypesUsed() {
        return this.itemTypesUsed;
    }

    public long getItemCellG() {
        return this.itemCellG;
    }

    public long getItemCellO() {
        return this.itemCellO;
    }

    public long getItemCellR() {
        return this.itemCellR;
    }

    public long getItemCellCount() {
        return this.itemCellCount;
    }

    public double getFluidBytesTotal() {
        return this.fluidBytesTotal;
    }

    public double getFluidBytesUsed() {
        return this.fluidBytesUsed;
    }

    public long getFluidTypesTotal() {
        return this.fluidTypesTotal;
    }

    public long getFluidTypesUsed() {
        return this.fluidTypesUsed;
    }

    public long getFluidCellG() {
        return this.fluidCellG;
    }

    public long getFluidCellO() {
        return this.fluidCellO;
    }

    public long getFluidCellR() {
        return this.fluidCellR;
    }

    public long getFluidCellCount() {
        return this.fluidCellCount;
    }

    public double getEssentiaBytesTotal() {
        return this.essentiaBytesTotal;
    }

    public double getEssentiaBytesUsed() {
        return this.essentiaBytesUsed;
    }

    public long getEssentiaTypesTotal() {
        return this.essentiaTypesTotal;
    }

    public long getEssentiaTypesUsed() {
        return this.essentiaTypesUsed;
    }

    public long getEssentiaCellG() {
        return this.essentiaCellG;
    }

    public long getEssentiaCellO() {
        return this.essentiaCellO;
    }

    public long getEssentiaCellR() {
        return this.essentiaCellR;
    }

    public long getEssentiaCellCount() {
        return this.essentiaCellCount;
    }

    private class CellChangeTracker {
        final List<CellChangeTrackerRecord> data = new LinkedList<CellChangeTrackerRecord>();

        private CellChangeTracker() {
        }

        public void postChanges(StorageChannel channel, int i, IMEInventoryHandler<? extends IAEStack> h, BaseActionSource actionSrc) {
            this.data.add(new CellChangeTrackerRecord(channel, i, h, actionSrc));
        }

        public void applyChanges() {
            for (CellChangeTrackerRecord rec : this.data) {
                rec.applyChanges();
            }
        }
    }

    private class CellChangeTrackerRecord {
        final StorageChannel channel;
        final int up_or_down;
        final IItemList list;
        final BaseActionSource src;

        public CellChangeTrackerRecord(StorageChannel channel, int i, IMEInventoryHandler<? extends IAEStack> h, BaseActionSource actionSrc) {
            this.channel = channel;
            this.up_or_down = i;
            this.src = actionSrc;
            this.list = channel == StorageChannel.ITEMS ? h.getAvailableItems(AEApi.instance().storage().createItemList()) : (channel == StorageChannel.FLUIDS ? h.getAvailableItems(AEApi.instance().storage().createFluidList()) : null);
        }

        public void applyChanges() {
            GridStorageCache.this.postChangesToNetwork(this.channel, this.up_or_down, this.list, this.src);
        }
    }
}

